/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.ManageLabelsForIndividualPreprocessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Literal;

public class ManageLabelsForPersonPreprocessor
extends ManageLabelsForIndividualPreprocessor {
    public ManageLabelsForPersonPreprocessor(EditConfigurationVTwo editConfig) {
        super(editConfig);
    }

    public void preprocess(MultiValueEditSubmission inputSubmission, VitroRequest vreq) {
        super.preprocess(inputSubmission, vreq);
        if (inputSubmission.hasLiteralValue("firstName") && inputSubmission.hasLiteralValue("lastName") && inputSubmission.hasLiteralValue("newLabelLanguage")) {
            Map literalsFromForm = inputSubmission.getLiteralsFromForm();
            List newLabelLanguages = (List)literalsFromForm.get("newLabelLanguage");
            ArrayList<Literal> firstNames = (ArrayList<Literal>)literalsFromForm.get("firstName");
            ArrayList<Literal> lastNames = (ArrayList<Literal>)literalsFromForm.get("lastName");
            List<Literal> middleNames = new ArrayList();
            if (inputSubmission.hasLiteralValue("middleName")) {
                middleNames = (List)literalsFromForm.get("middleName");
            }
            if (firstNames.size() > 0 && lastNames.size() > 0 && newLabelLanguages.size() > 0) {
                Literal newLabelLanguage = (Literal)newLabelLanguages.get(0);
                Literal firstNameLiteral = (Literal)firstNames.get(0);
                Literal lastNameLiteral = (Literal)lastNames.get(0);
                String lang = this.getLanguage(newLabelLanguage.getString());
                String firstNameValue = firstNameLiteral.getString();
                String lastNameValue = lastNameLiteral.getString();
                Literal firstNameWithLanguage = inputSubmission.createLiteral(firstNameValue, null, lang);
                Literal lastNameWithLanguage = inputSubmission.createLiteral(lastNameValue, null, lang);
                firstNames = new ArrayList<Literal>();
                lastNames = new ArrayList<Literal>();
                firstNames.add(firstNameWithLanguage);
                lastNames.add(lastNameWithLanguage);
                literalsFromForm.put("firstName", firstNames);
                literalsFromForm.put("lastName", lastNames);
                if (middleNames.size() > 0) {
                    Literal middleNameLiteral = (Literal)middleNames.get(0);
                    String middleNameValue = middleNameLiteral.getString();
                    Literal middleNameWithLanguage = inputSubmission.createLiteral(middleNameValue, null, lang);
                    middleNames = new ArrayList();
                    middleNames.add(middleNameWithLanguage);
                    literalsFromForm.put("middleName", middleNames);
                }
                inputSubmission.setLiteralsFromForm(literalsFromForm);
            }
        }
    }
}

