/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.persongrantcount;

import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.persongrantcount.PersonGrantCountQueryRunner;
import edu.cornell.mannlib.vitro.webapp.visualization.persongrantcount.PersonGrantCountVisCodeGenerator;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.SparklineData;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.SubEntity;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.jena.query.Dataset;

public class PersonGrantCountRequestHandler
implements VisualizationRequestHandler {
    @Override
    public Map<String, String> generateDataVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        String personURI = vitroRequest.getParameter("uri");
        SubEntity person = new SubEntity(personURI, UtilityFunctions.getIndividualLabelFromDAO(vitroRequest, personURI));
        PersonGrantCountQueryRunner queryManager = new PersonGrantCountQueryRunner(personURI, vitroRequest.getRDFService(), log);
        Set authorGrants = (Set)queryManager.getQueryResult();
        Map<String, Integer> yearToGrantCount = UtilityFunctions.getYearToActivityCount(authorGrants);
        return this.prepareDataResponse(person, yearToGrantCount);
    }

    @Override
    public ResponseValues generateVisualizationForShortURLRequests(Map<String, String> parameters, VitroRequest vitroRequest, Log log, Dataset dataSource) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("Person Grant Count Visualization does not provide Short URL Response.");
    }

    @Override
    public Object generateAjaxVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        String personURI = vitroRequest.getParameter("uri");
        String visMode = vitroRequest.getParameter("vis_mode");
        String visContainer = vitroRequest.getParameter("container");
        PersonGrantCountQueryRunner queryManager = new PersonGrantCountQueryRunner(personURI, vitroRequest.getRDFService(), log);
        Set authorGrants = (Set)queryManager.getQueryResult();
        Map<String, Integer> yearToGrantCount = UtilityFunctions.getYearToActivityCount(authorGrants);
        boolean shouldVIVOrenderVis = yearToGrantCount.size() > 0;
        PersonGrantCountVisCodeGenerator visualizationCodeGenerator = new PersonGrantCountVisCodeGenerator(personURI, visMode, visContainer, yearToGrantCount, log);
        SparklineData sparklineData = visualizationCodeGenerator.getValueObjectContainer();
        return this.prepareDynamicResponse(vitroRequest, sparklineData, shouldVIVOrenderVis);
    }

    @Override
    public ResponseValues generateStandardVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        String personURI = vitroRequest.getParameter("uri");
        String visMode = vitroRequest.getParameter("vis_mode");
        String visContainer = vitroRequest.getParameter("container");
        PersonGrantCountQueryRunner queryManager = new PersonGrantCountQueryRunner(personURI, vitroRequest.getRDFService(), log);
        Set authorGrants = (Set)queryManager.getQueryResult();
        Map<String, Integer> yearToGrantCount = UtilityFunctions.getYearToActivityCount(authorGrants);
        PersonGrantCountVisCodeGenerator visualizationCodeGenerator = new PersonGrantCountVisCodeGenerator(personURI, visMode, visContainer, yearToGrantCount, log);
        SparklineData sparklineData = visualizationCodeGenerator.getValueObjectContainer();
        return this.prepareStandaloneResponse(vitroRequest, sparklineData);
    }

    private String getGrantsOverTimeCSVContent(Map<String, Integer> yearToGrantCount) {
        StringBuilder csvFileContent = new StringBuilder();
        csvFileContent.append("Year, Grants\n");
        for (Map.Entry<String, Integer> currentEntry : yearToGrantCount.entrySet()) {
            csvFileContent.append(StringEscapeUtils.escapeCsv((String)currentEntry.getKey()));
            csvFileContent.append(",");
            csvFileContent.append(currentEntry.getValue());
            csvFileContent.append("\n");
        }
        return csvFileContent.toString();
    }

    private Map<String, String> prepareDataResponse(SubEntity investigator, Map<String, Integer> yearToGrantCount) {
        String piName = investigator.getIndividualLabel();
        String outputFileName = UtilityFunctions.slugify(piName) + "_grants-per-year.csv";
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileName", outputFileName);
        fileData.put("fileContentType", "application/octet-stream");
        fileData.put("fileContent", this.getGrantsOverTimeCSVContent(yearToGrantCount));
        return fileData;
    }

    private TemplateResponseValues prepareStandaloneResponse(VitroRequest vreq, SparklineData valueObjectContainer) {
        String standaloneTemplate = "personGrantCountStandaloneActivator.ftl";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", "Individual Grant Count visualization");
        body.put("sparklineVO", valueObjectContainer);
        return new TemplateResponseValues(standaloneTemplate, body);
    }

    private TemplateResponseValues prepareDynamicResponse(VitroRequest vreq, SparklineData valueObjectContainer, boolean shouldVIVOrenderVis) {
        String dynamicTemplate = "personGrantCountDynamicActivator.ftl";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("sparklineVO", valueObjectContainer);
        body.put("shouldVIVOrenderVis", shouldVIVOrenderVis);
        return new TemplateResponseValues(dynamicTemplate, body);
    }

    @Override
    public AuthorizationRequest getRequiredPrivileges() {
        return null;
    }
}

