/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.personpubcount;

import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.personpubcount.PersonPublicationCountQueryRunner;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Activity;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.jena.query.Dataset;

public class CumulativeCountRequestHandler
implements VisualizationRequestHandler {
    @Override
    public AuthorizationRequest getRequiredPrivileges() {
        return null;
    }

    @Override
    public ResponseValues generateStandardVisualization(VitroRequest vitroRequest, Log log, Dataset dataSource) throws MalformedQueryParametersException {
        return null;
    }

    @Override
    public ResponseValues generateVisualizationForShortURLRequests(Map<String, String> parameters, VitroRequest vitroRequest, Log log, Dataset dataSource) throws MalformedQueryParametersException {
        return null;
    }

    @Override
    public Object generateAjaxVisualization(VitroRequest vitroRequest, Log log, Dataset dataSource) throws MalformedQueryParametersException {
        String personURI = vitroRequest.getParameter("uri");
        PersonPublicationCountQueryRunner queryManager = new PersonPublicationCountQueryRunner(personURI, vitroRequest.getRDFService(), log);
        Set authorDocuments = (Set)queryManager.getQueryResult();
        TreeMap<Integer, Map<String, Integer>> yearToTypeCount = new TreeMap<Integer, Map<String, Integer>>();
        for (Activity currentActivity : authorDocuments) {
            Map<String, Integer> typeCounts;
            Integer activityYear;
            String activityYearStr = currentActivity.getParsedActivityYear();
            try {
                activityYear = Integer.parseInt(activityYearStr, 10);
            }
            catch (NumberFormatException nfe) {
                activityYear = 0;
            }
            if (yearToTypeCount.containsKey(activityYear)) {
                typeCounts = (Map)yearToTypeCount.get(activityYear);
            } else {
                typeCounts = new TreeMap();
                yearToTypeCount.put(activityYear, typeCounts);
            }
            String activityType = currentActivity.getActivityType();
            if (StringUtils.isEmpty((CharSequence)activityType)) {
                activityType = "http://purl.org/ontology/bibo/Document";
            }
            if (typeCounts.containsKey(activityType)) {
                typeCounts.put(activityType, (Integer)typeCounts.get(activityType) + 1);
                continue;
            }
            typeCounts.put(activityType, 1);
        }
        StringBuilder csv = new StringBuilder();
        csv.append("Year,Previous,Other,Books,Articles\n");
        int currentYear = Calendar.getInstance().get(1);
        ArrayList years = new ArrayList(yearToTypeCount.keySet());
        for (int year = currentYear - 9; year < currentYear + 1; ++year) {
            if (years.contains(year)) continue;
            years.add(year);
        }
        Collections.sort(years);
        int publicationCount = 0;
        for (Integer year : years) {
            if (year < currentYear - 9) {
                if (!yearToTypeCount.containsKey(year)) continue;
                Map typeCounts = (Map)yearToTypeCount.get(year);
                for (Map.Entry entry : typeCounts.entrySet()) {
                    publicationCount += ((Integer)entry.getValue()).intValue();
                }
                continue;
            }
            int articleCount = 0;
            int bookCount = 0;
            int otherCount = 0;
            if (yearToTypeCount.containsKey(year)) {
                Map typeCounts = (Map)yearToTypeCount.get(year);
                for (Map.Entry entry : typeCounts.entrySet()) {
                    if ("http://purl.org/ontology/bibo/AcademicArticle".equalsIgnoreCase((String)entry.getKey()) || "http://purl.org/ontology/bibo/Article".equalsIgnoreCase((String)entry.getKey())) {
                        articleCount += ((Integer)entry.getValue()).intValue();
                        continue;
                    }
                    if ("http://purl.org/ontology/bibo/Book".equalsIgnoreCase((String)entry.getKey()) || "http://purl.org/ontology/bibo/BookSection".equalsIgnoreCase((String)entry.getKey()) || "http://purl.org/ontology/bibo/Chapter".equalsIgnoreCase((String)entry.getKey()) || "http://purl.org/ontology/bibo/EditedBook".equalsIgnoreCase((String)entry.getKey())) {
                        bookCount += ((Integer)entry.getValue()).intValue();
                        continue;
                    }
                    otherCount += ((Integer)entry.getValue()).intValue();
                }
            }
            csv.append(year).append(",").append(publicationCount).append(",").append(otherCount).append(",").append(bookCount).append(",").append(articleCount).append("\n");
            publicationCount += articleCount + bookCount + otherCount;
        }
        return csv.toString();
    }

    @Override
    public Map<String, String> generateDataVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        return null;
    }
}

