/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.personpubcount;

import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.personpubcount.PersonPublicationCountQueryRunner;
import edu.cornell.mannlib.vitro.webapp.visualization.personpubcount.PersonPublicationCountVisCodeGenerator;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.SparklineData;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.jena.query.Dataset;

public class PersonPublicationCountRequestHandler
implements VisualizationRequestHandler {
    @Override
    public Object generateAjaxVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        String personURI = vitroRequest.getParameter("uri");
        String visMode = vitroRequest.getParameter("vis_mode");
        String visContainer = vitroRequest.getParameter("container");
        String requestingTemplate = vitroRequest.getParameter("template");
        PersonPublicationCountQueryRunner queryManager = new PersonPublicationCountQueryRunner(personURI, vitroRequest.getRDFService(), log);
        Set authorDocuments = (Set)queryManager.getQueryResult();
        Map<String, Integer> yearToPublicationCount = UtilityFunctions.getYearToActivityCount(authorDocuments);
        boolean shouldVIVOrenderVis = false;
        if (yearToPublicationCount.containsKey("Unknown")) {
            if (yearToPublicationCount.size() > 1) {
                shouldVIVOrenderVis = true;
            }
        } else if (yearToPublicationCount.size() > 0) {
            shouldVIVOrenderVis = true;
        }
        PersonPublicationCountVisCodeGenerator visualizationCodeGenerator = new PersonPublicationCountVisCodeGenerator(personURI, visMode, visContainer, yearToPublicationCount, log);
        SparklineData sparklineData = visualizationCodeGenerator.getValueObjectContainer();
        return this.prepareDynamicResponse(vitroRequest, sparklineData, shouldVIVOrenderVis, requestingTemplate);
    }

    @Override
    public ResponseValues generateVisualizationForShortURLRequests(Map<String, String> parameters, VitroRequest vitroRequest, Log log, Dataset dataSource) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("Person Publication Count Visualization does not provide Short URL Response.");
    }

    @Override
    public Map<String, String> generateDataVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        String personURI = vitroRequest.getParameter("uri");
        PersonPublicationCountQueryRunner queryManager = new PersonPublicationCountQueryRunner(personURI, vitroRequest.getRDFService(), log);
        Set authorDocuments = (Set)queryManager.getQueryResult();
        Map<String, Integer> yearToPublicationCount = UtilityFunctions.getYearToActivityCount(authorDocuments);
        String authorName = queryManager.getAuthorName();
        return this.prepareDataResponse(authorName, yearToPublicationCount);
    }

    @Override
    public ResponseValues generateStandardVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        String personURI = vitroRequest.getParameter("uri");
        String visMode = vitroRequest.getParameter("vis_mode");
        String visContainer = vitroRequest.getParameter("container");
        PersonPublicationCountQueryRunner queryManager = new PersonPublicationCountQueryRunner(personURI, vitroRequest.getRDFService(), log);
        Set authorDocuments = (Set)queryManager.getQueryResult();
        Map<String, Integer> yearToPublicationCount = UtilityFunctions.getYearToActivityCount(authorDocuments);
        PersonPublicationCountVisCodeGenerator visualizationCodeGenerator = new PersonPublicationCountVisCodeGenerator(personURI, visMode, visContainer, yearToPublicationCount, log);
        SparklineData sparklineData = visualizationCodeGenerator.getValueObjectContainer();
        return this.prepareStandaloneResponse(vitroRequest, sparklineData);
    }

    private String getPublicationsOverTimeCSVContent(Map<String, Integer> yearToPublicationCount) {
        StringBuilder csvFileContent = new StringBuilder();
        csvFileContent.append("Year, Publications\n");
        for (Map.Entry<String, Integer> currentEntry : yearToPublicationCount.entrySet()) {
            csvFileContent.append(StringEscapeUtils.escapeCsv((String)currentEntry.getKey()));
            csvFileContent.append(",");
            csvFileContent.append(currentEntry.getValue());
            csvFileContent.append("\n");
        }
        return csvFileContent.toString();
    }

    private Map<String, String> prepareDataResponse(String authorName, Map<String, Integer> yearToPublicationCount) {
        if (StringUtils.isBlank((CharSequence)authorName)) {
            authorName = "no-author";
        }
        String outputFileName = UtilityFunctions.slugify(authorName) + "_publications-per-year.csv";
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileName", outputFileName);
        fileData.put("fileContentType", "application/octet-stream");
        fileData.put("fileContent", this.getPublicationsOverTimeCSVContent(yearToPublicationCount));
        return fileData;
    }

    private TemplateResponseValues prepareStandaloneResponse(VitroRequest vreq, SparklineData valueObjectContainer) {
        String standaloneTemplate = "personPublicationCountStandaloneActivator.ftl";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", "Individual Publication Count visualization");
        body.put("sparklineVO", valueObjectContainer);
        return new TemplateResponseValues(standaloneTemplate, body);
    }

    private TemplateResponseValues prepareDynamicResponse(VitroRequest vreq, SparklineData valueObjectContainer, boolean shouldVIVOrenderVis, String requestingTemplate) {
        String dynamicTemplate = "personPublicationCountDynamicActivator.ftl";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("sparklineVO", valueObjectContainer);
        body.put("shouldVIVOrenderVis", shouldVIVOrenderVis);
        body.put("requestingTemplate", requestingTemplate);
        return new TemplateResponseValues(dynamicTemplate, body);
    }

    @Override
    public AuthorizationRequest getRequiredPrivileges() {
        return null;
    }
}

