/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.utilities;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.filestorage.FileServingHelper;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.GenericQueryMap;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.AllPropertiesQueryRunner;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.GenericQueryRunner;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.vivoweb.webapp.util.ModelUtils;

public class UtilitiesRequestHandler
implements VisualizationRequestHandler {
    @Override
    public Object generateAjaxVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException, JsonProcessingException {
        String individualURI = vitroRequest.getParameter("uri");
        String visMode = vitroRequest.getParameter("vis_mode");
        if ("PROFILE_INFO".equalsIgnoreCase(visMode)) {
            String filterRule = "?predicate = public:mainImage  || ?predicate = rdfs:label  || ?predicate =  <http://www.w3.org/2006/vcard/ns#title>";
            AllPropertiesQueryRunner profileQueryHandler = new AllPropertiesQueryRunner(individualURI, filterRule, vitroRequest.getRDFService(), log);
            GenericQueryMap profilePropertiesToValues = profileQueryHandler.getQueryResult();
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)profilePropertiesToValues);
        }
        if ("IMAGE_URL".equalsIgnoreCase(visMode)) {
            HashMap<String, String> fieldLabelToOutputFieldLabel = new HashMap<String, String>();
            fieldLabelToOutputFieldLabel.put("downloadLocation", "thumbnailDownloadLocationLit");
            fieldLabelToOutputFieldLabel.put("fileName", "thumbnailFileNameLit");
            String whereClause = "<" + individualURI + "> public:thumbnailImage ?thumbnailImage .  ?thumbnailImage public:downloadLocation ?downloadLocation ; public:filename ?fileName .";
            GenericQueryRunner imageQueryHandler = new GenericQueryRunner(fieldLabelToOutputFieldLabel, "", whereClause, "", dataset);
            ThumbnailInformationConsumer consumer = new ThumbnailInformationConsumer(vitroRequest, fieldLabelToOutputFieldLabel);
            imageQueryHandler.sparqlSelectQuery(vitroRequest.getRDFService(), consumer);
            return consumer.getInformation();
        }
        if ("SHOW_AUTHORSHIP_LINK".equalsIgnoreCase(visMode)) {
            HashMap<String, String> fieldLabelToOutputFieldLabel = new HashMap<String, String>();
            String aggregationRules = "(count(DISTINCT ?document) AS ?numOfPublications)";
            String whereClause = "<" + individualURI + "> rdf:type foaf:Person ; core:relatedBy ?authorshipNode . \n?authorshipNode rdf:type core:Authorship ; core:relates ?document . \n?document rdf:type bibo:Document .";
            String groupOrderClause = "GROUP BY ?authPersonLit \n";
            GenericQueryRunner numberOfPublicationsQueryHandler = new GenericQueryRunner(fieldLabelToOutputFieldLabel, aggregationRules, whereClause, groupOrderClause, dataset);
            NumPubsForIndividualConsumer consumer = new NumPubsForIndividualConsumer();
            numberOfPublicationsQueryHandler.sparqlSelectQuery(vitroRequest.getRDFService(), consumer);
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)consumer.getMap());
        }
        if ("SHOW_GRANTS_LINK".equalsIgnoreCase(visMode)) {
            HashMap<String, String> fieldLabelToOutputFieldLabel = new HashMap<String, String>();
            String aggregationRules = "(count(DISTINCT ?Grant) AS ?numOfGrants)";
            String grantType = "http://vivoweb.org/ontology/core#Grant";
            ObjectProperty predicate = ModelUtils.getPropertyForRoleInClass(grantType, vitroRequest.getWebappDaoFactory());
            String roleToGrantPredicate = "<" + predicate.getURI() + ">";
            String whereClause = "{ <" + individualURI + "> rdf:type foaf:Person ; <http://purl.obolibrary.org/obo/RO_0000053> ?Role . \n?Role rdf:type core:PrincipalInvestigatorRole . \n?Role " + roleToGrantPredicate + " ?Grant . }UNION \n{ <" + individualURI + "> rdf:type foaf:Person ; <http://purl.obolibrary.org/obo/RO_0000053> ?Role . \n?Role rdf:type core:CoPrincipalInvestigatorRole . \n?Role " + roleToGrantPredicate + " ?Grant . }UNION \n{ <" + individualURI + "> rdf:type foaf:Person ; <http://purl.obolibrary.org/obo/RO_0000053> ?Role . \n?Role rdf:type core:InvestigatorRole. \n?Role vitro:mostSpecificType ?subclass . \n?Role " + roleToGrantPredicate + " ?Grant . \nFILTER (?subclass != core:PrincipalInvestigatorRole && ?subclass != core:CoPrincipalInvestigatorRole)}";
            GenericQueryRunner numberOfGrantsQueryHandler = new GenericQueryRunner(fieldLabelToOutputFieldLabel, aggregationRules, whereClause, "", dataset);
            NumGrantsForIndividualConsumer consumer = new NumGrantsForIndividualConsumer();
            numberOfGrantsQueryHandler.sparqlSelectQuery(vitroRequest.getRDFService(), consumer);
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)consumer.getMap());
        }
        if ("COAUTHORSHIP_URL".equalsIgnoreCase(visMode)) {
            String individualLocalName = UtilityFunctions.getIndividualLocalName(individualURI, vitroRequest);
            if (StringUtils.isNotBlank((CharSequence)individualLocalName)) {
                return UrlBuilder.getUrl((String)"/vis") + "/" + "author-network" + "/" + individualLocalName;
            }
            UrlBuilder.ParamMap coAuthorProfileURLParams = new UrlBuilder.ParamMap(new String[]{"uri", individualURI, "vis", "person_level", "vis_mode", "coauthor"});
            return UrlBuilder.getUrl((String)"/visualization", (UrlBuilder.ParamMap)coAuthorProfileURLParams);
        }
        if ("COPI_URL".equalsIgnoreCase(visMode)) {
            String individualLocalName = UtilityFunctions.getIndividualLocalName(individualURI, vitroRequest);
            if (StringUtils.isNotBlank((CharSequence)individualLocalName)) {
                return UrlBuilder.getUrl((String)"/vis") + "/" + "investigator-network" + "/" + individualLocalName;
            }
            UrlBuilder.ParamMap coInvestigatorProfileURLParams = new UrlBuilder.ParamMap(new String[]{"uri", individualURI, "vis", "person_level", "vis_mode", "copi"});
            return UrlBuilder.getUrl((String)"/visualization", (UrlBuilder.ParamMap)coInvestigatorProfileURLParams);
        }
        if ("PERSON_LEVEL_URL".equalsIgnoreCase(visMode)) {
            UrlBuilder.ParamMap personLevelURLParams = new UrlBuilder.ParamMap(new String[]{"uri", individualURI, "vis", "person_level", "render_mode", "standalone"});
            return UrlBuilder.getUrl((String)"/visualization", (UrlBuilder.ParamMap)personLevelURLParams);
        }
        if ("HIGHEST_LEVEL_ORGANIZATION".equalsIgnoreCase(visMode)) {
            String staffProvidedHighestLevelOrganization = ConfigurationProperties.getBean((ServletRequest)vitroRequest).getProperty("visualization.topLevelOrg");
            if (StringUtils.isNotBlank((CharSequence)staffProvidedHighestLevelOrganization)) {
                IRIFactory iRIFactory = IRIFactory.jenaImplementation();
                IRI iri = iRIFactory.create(staffProvidedHighestLevelOrganization);
                if (iri.hasViolation(false)) {
                    String errorMsg = ((Violation)iri.violations(false).next()).getShortMessage();
                    log.error((Object)("Highest Level Organization URI provided is invalid " + errorMsg));
                } else {
                    UrlBuilder.ParamMap highestLevelOrganizationTemporalGraphVisURLParams = new UrlBuilder.ParamMap(new String[]{"uri", staffProvidedHighestLevelOrganization, "vis", "entity_comparison"});
                    return UrlBuilder.getUrl((String)"/visualization", (UrlBuilder.ParamMap)highestLevelOrganizationTemporalGraphVisURLParams);
                }
            }
            HashMap<String, String> fieldLabelToOutputFieldLabel = new HashMap<String, String>();
            fieldLabelToOutputFieldLabel.put("organization", "organizationLit");
            fieldLabelToOutputFieldLabel.put("organizationLabel", "organizationLabelLit");
            String aggregationRules = "(count(?organization) AS ?numOfChildren)";
            String whereClause = "?organization rdf:type foaf:Organization ; rdfs:label ?organizationLabel . \nOPTIONAL { ?organization core:http://purl.obolibrary.org/obo/BFO_0000051 ?subOrg  . \n           ?subOrg rdf:type foaf:Organization } . \nOPTIONAL { ?organization core:http://purl.obolibrary.org/obo/BFO_0000050 ?parent } . \n           ?parent rdf:type foaf:Organization } . \nFILTER ( !bound(?parent) ). \n";
            String groupOrderClause = "GROUP BY ?organization ?organizationLabel \nORDER BY DESC(?numOfChildren)\nLIMIT 1\n";
            GenericQueryRunner highestLevelOrganizationQueryHandler = new GenericQueryRunner(fieldLabelToOutputFieldLabel, aggregationRules, whereClause, groupOrderClause, dataset);
            HighetTopLevelOrgTemporalGraphURLConsumer consumer = new HighetTopLevelOrgTemporalGraphURLConsumer(vitroRequest, fieldLabelToOutputFieldLabel);
            highestLevelOrganizationQueryHandler.sparqlSelectQuery(vitroRequest.getRDFService(), consumer);
            return consumer.getTopLevelURL();
        }
        UrlBuilder.ParamMap individualProfileURLParams = new UrlBuilder.ParamMap(new String[]{"uri", individualURI});
        return UrlBuilder.getUrl((String)"/individual", (UrlBuilder.ParamMap)individualProfileURLParams);
    }

    private String getThumbnailInformation(ResultSet resultSet, Map<String, String> fieldLabelToOutputFieldLabel, VitroRequest vitroRequest) {
        String finalThumbNailLocation = "";
        while (resultSet.hasNext()) {
            QuerySolution querySolution = resultSet.nextSolution();
        }
        return finalThumbNailLocation;
    }

    @Override
    public Map<String, String> generateDataVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("Utilities does not provide Data Response.");
    }

    @Override
    public ResponseValues generateStandardVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("Utilities does not provide Standard Response.");
    }

    @Override
    public ResponseValues generateVisualizationForShortURLRequests(Map<String, String> parameters, VitroRequest vitroRequest, Log log, Dataset dataSource) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("Utilities Visualization does not provide Short URL Response.");
    }

    @Override
    public AuthorizationRequest getRequiredPrivileges() {
        return null;
    }

    private static class ThumbnailInformationConsumer
    extends ResultSetConsumer {
        private VitroRequest vitroRequest;
        private Map<String, String> fieldLabelToOutputFieldLabel;
        private String finalThumbNailLocation = "";

        ThumbnailInformationConsumer(VitroRequest vitroRequest, Map<String, String> fieldLabelToOutputFieldLabel) {
            this.vitroRequest = vitroRequest;
            this.fieldLabelToOutputFieldLabel = fieldLabelToOutputFieldLabel;
        }

        protected void processQuerySolution(QuerySolution qs) {
            RDFNode downloadLocationNode = qs.get(this.fieldLabelToOutputFieldLabel.get("downloadLocation"));
            RDFNode fileNameNode = qs.get(this.fieldLabelToOutputFieldLabel.get("fileName"));
            if (downloadLocationNode != null && fileNameNode != null) {
                this.finalThumbNailLocation = FileServingHelper.getBytestreamAliasUrl((String)downloadLocationNode.toString(), (String)fileNameNode.toString(), (ServletContext)this.vitroRequest.getSession().getServletContext());
            }
        }

        public String getInformation() {
            return this.finalThumbNailLocation;
        }
    }

    private static class NumPubsForIndividualConsumer
    extends ResultSetConsumer {
        GenericQueryMap queryResult = new GenericQueryMap();

        private NumPubsForIndividualConsumer() {
        }

        protected void processQuerySolution(QuerySolution qs) {
            Literal numberOfPublicationsNode = qs.getLiteral("numOfPublications");
            if (numberOfPublicationsNode != null) {
                this.queryResult.addEntry("numOfPublications", String.valueOf(numberOfPublicationsNode.asLiteral().getInt()));
            }
        }

        public GenericQueryMap getMap() {
            return this.queryResult;
        }
    }

    private static class NumGrantsForIndividualConsumer
    extends ResultSetConsumer {
        GenericQueryMap queryResult = new GenericQueryMap();

        private NumGrantsForIndividualConsumer() {
        }

        protected void processQuerySolution(QuerySolution qs) {
            Literal numberOfGrantsNode = qs.getLiteral("numOfGrants");
            if (numberOfGrantsNode != null) {
                this.queryResult.addEntry("numOfGrants", String.valueOf(numberOfGrantsNode.asLiteral().getInt()));
            }
        }

        public GenericQueryMap getMap() {
            return this.queryResult;
        }
    }

    private class HighetTopLevelOrgTemporalGraphURLConsumer
    extends ResultSetConsumer {
        private VitroRequest vitroRequest;
        private Map<String, String> fieldLabelToOutputFieldLabel;
        private String topLevelURL = null;

        HighetTopLevelOrgTemporalGraphURLConsumer(VitroRequest vitroRequest, Map<String, String> fieldLabelToOutputFieldLabel) {
            this.vitroRequest = vitroRequest;
            this.fieldLabelToOutputFieldLabel = fieldLabelToOutputFieldLabel;
        }

        protected void processQuerySolution(QuerySolution qs) {
            if (this.topLevelURL != null) {
                return;
            }
            RDFNode organizationNode = qs.get(this.fieldLabelToOutputFieldLabel.get("organization"));
            if (organizationNode != null) {
                String individualLocalName = UtilityFunctions.getIndividualLocalName(organizationNode.toString(), this.vitroRequest);
                if (StringUtils.isNotBlank((CharSequence)individualLocalName)) {
                    this.topLevelURL = UrlBuilder.getUrl((String)"/vis") + "/" + "publication-graph" + "/" + individualLocalName;
                } else {
                    UrlBuilder.ParamMap highestLevelOrganizationTemporalGraphVisURLParams = new UrlBuilder.ParamMap(new String[]{"uri", organizationNode.toString(), "vis", "entity_comparison"});
                    this.topLevelURL = UrlBuilder.getUrl((String)"/visualization", (UrlBuilder.ParamMap)highestLevelOrganizationTemporalGraphVisURLParams);
                }
            }
        }

        public String getTopLevelURL() {
            return this.topLevelURL == null ? "" : this.topLevelURL;
        }
    }
}

