/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.valueobjects;

import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Activity;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaborator;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UniqueIDGenerator;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Collaboration {
    private int collaborationID;
    private Map<String, Integer> yearToActivityCount;
    private Set<Activity> activities = new HashSet<Activity>();
    private Collaborator sourceCollaborator;
    private Collaborator targetCollaborator;

    public Collaboration(Collaborator sourceCollaborator, Collaborator targetCollaborator, Activity seedActivity, UniqueIDGenerator uniqueIDGenerator) {
        this.collaborationID = uniqueIDGenerator.getNextNumericID();
        this.sourceCollaborator = sourceCollaborator;
        this.targetCollaborator = targetCollaborator;
        this.activities.add(seedActivity);
    }

    public int getCollaborationID() {
        return this.collaborationID;
    }

    public Collaborator getSourceCollaborator() {
        return this.sourceCollaborator;
    }

    public Collaborator getTargetCollaborator() {
        return this.targetCollaborator;
    }

    public Set<Activity> getCollaborationActivities() {
        return this.activities;
    }

    public int getNumOfCollaborations() {
        return this.activities.size();
    }

    public void addActivity(Activity activity) {
        this.activities.add(activity);
    }

    public Map<String, Integer> getYearToActivityCount() {
        if (this.yearToActivityCount == null) {
            this.yearToActivityCount = UtilityFunctions.getYearToActivityCount(this.activities);
        }
        return this.yearToActivityCount;
    }

    public Map<String, Integer> getEarliestCollaborationYearCount() {
        HashSet<String> yearsToBeConsidered = new HashSet<String>(this.getYearToActivityCount().keySet());
        yearsToBeConsidered.remove("Unknown");
        if (yearsToBeConsidered.size() > 0) {
            final String earliestYear = Collections.min(yearsToBeConsidered);
            final Integer earliestYearActivityCount = this.getYearToActivityCount().get(earliestYear);
            return new HashMap<String, Integer>(){
                {
                    this.put(earliestYear, earliestYearActivityCount);
                }
            };
        }
        return null;
    }

    public Map<String, Integer> getLatestCollaborationYearCount() {
        HashSet<String> yearsToBeConsidered = new HashSet<String>(this.getYearToActivityCount().keySet());
        yearsToBeConsidered.remove("Unknown");
        if (yearsToBeConsidered.size() > 0) {
            final String latestYear = Collections.max(yearsToBeConsidered);
            final Integer latestYearActivityCount = this.getYearToActivityCount().get(latestYear);
            return new HashMap<String, Integer>(){
                {
                    this.put(latestYear, latestYearActivityCount);
                }
            };
        }
        return null;
    }

    public Integer getUnknownCollaborationYearCount() {
        Integer unknownYearActivityCount = this.getYearToActivityCount().get("Unknown");
        if (unknownYearActivityCount != null) {
            return unknownYearActivityCount;
        }
        return null;
    }
}

