/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.visutils;

import edu.cornell.mannlib.vitro.webapp.visualization.collaborationutils.CollaborationData;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaboration;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaborator;
import java.util.ArrayList;
import java.util.List;

public class CollaborationDataViewHelper {
    private static final int MAX_COLLABORATORS = 35;
    private CollaborationData data;
    private List<Collaborator> collaborators = null;
    private int[][] collaborationMatrix = null;

    public CollaborationDataViewHelper(CollaborationData data) {
        this.data = data;
    }

    public int getCollaboratorsCount() {
        this.init(35);
        return this.data.getCollaborators().size();
    }

    public int[][] getCollaborationMatrix() {
        this.init(35);
        return this.collaborationMatrix;
    }

    public List<Collaborator> getCollaborators() {
        this.init(35);
        return this.collaborators;
    }

    private synchronized void init(int max) {
        if (this.collaborators != null) {
            return;
        }
        this.collaborators = new ArrayList<Collaborator>(max);
        int threshold = Integer.MAX_VALUE;
        for (Collaborator collaborator : this.data.getCollaborators()) {
            if (collaborator.getCollaboratorID() == this.data.getEgoCollaborator().getCollaboratorID()) continue;
            if (collaborator.getNumOfActivities() > threshold) {
                if (this.collaborators.size() == max - 1) {
                    this.collaborators.remove(this.collaborators.size() - 1);
                }
                int insert = this.collaborators.size();
                while (insert > 0) {
                    if (this.collaborators.get(--insert).getNumOfActivities() <= collaborator.getNumOfActivities()) continue;
                    ++insert;
                    break;
                }
                if (insert < 0) {
                    this.collaborators.add(0, collaborator);
                } else if (insert < this.collaborators.size()) {
                    this.collaborators.add(insert, collaborator);
                } else {
                    this.collaborators.add(collaborator);
                }
                threshold = this.collaborators.get(this.collaborators.size() - 1).getNumOfActivities();
                continue;
            }
            if (this.collaborators.size() >= max - 1) continue;
            this.collaborators.add(collaborator);
            threshold = collaborator.getNumOfActivities();
        }
        this.collaborators.add(0, this.data.getEgoCollaborator());
        boolean fullMatrix = true;
        this.collaborationMatrix = new int[this.collaborators.size()][this.collaborators.size()];
        for (int x = 0; x < this.collaborators.size(); ++x) {
            Collaborator collaboratorX = this.collaborators.get(x);
            ArrayList<Collaboration> possibleCollaborations = new ArrayList<Collaboration>();
            for (Collaboration collaboration : this.data.getCollaborations()) {
                Collaborator source = collaboration.getSourceCollaborator();
                Collaborator target = collaboration.getTargetCollaborator();
                if (source.getCollaboratorID() != collaboratorX.getCollaboratorID() && target.getCollaboratorID() != collaboratorX.getCollaboratorID()) continue;
                possibleCollaborations.add(collaboration);
            }
            block4: for (int y = 0; y < this.collaborators.size(); ++y) {
                Collaborator collaboratorY = this.collaborators.get(y);
                if (x != 0 && y != 0 && !fullMatrix) continue;
                for (Collaboration collaboration : possibleCollaborations) {
                    Collaborator source = collaboration.getSourceCollaborator();
                    Collaborator target = collaboration.getTargetCollaborator();
                    if (source.getCollaboratorID() == collaboratorX.getCollaboratorID() && target.getCollaboratorID() == collaboratorY.getCollaboratorID()) {
                        this.collaborationMatrix[x][y] = collaboration.getNumOfCollaborations();
                        continue block4;
                    }
                    if (source.getCollaboratorID() != collaboratorY.getCollaboratorID() || target.getCollaboratorID() != collaboratorX.getCollaboratorID()) continue;
                    this.collaborationMatrix[x][y] = collaboration.getNumOfCollaborations();
                    continue block4;
                }
            }
        }
        this.collaborationMatrix[0][0] = 0;
    }
}

