/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.visutils;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.visualization.collaborationutils.CollaborationData;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.VOConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Activity;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaborator;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.GenericQueryMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

public class UtilityFunctions {
    public static Map<String, Integer> getYearToActivityCount(Set<Activity> activities) {
        TreeMap<String, Integer> yearToActivityCount = new TreeMap<String, Integer>();
        for (Activity currentActivity : activities) {
            String activityYear = currentActivity.getParsedActivityYear();
            if (yearToActivityCount.containsKey(activityYear)) {
                yearToActivityCount.put(activityYear, (Integer)yearToActivityCount.get(activityYear) + 1);
                continue;
            }
            yearToActivityCount.put(activityYear, 1);
        }
        return yearToActivityCount;
    }

    public static Map<String, Integer> getYearToActivityCount(Collection<Activity> activities) {
        return UtilityFunctions.getYearToActivityCount(new HashSet<Activity>(activities));
    }

    public static Map<String, Set<Collaborator>> getActivityYearToCollaborators(CollaborationData collaborationData) {
        TreeMap<String, Set<Collaborator>> yearToCollaborators = new TreeMap<String, Set<Collaborator>>();
        Collaborator egoCollaborator = collaborationData.getEgoCollaborator();
        for (Collaborator currNode : collaborationData.getCollaborators()) {
            if (currNode == egoCollaborator) continue;
            for (String year : currNode.getYearToActivityCount().keySet()) {
                Set<Collaborator> collaboratorNodes;
                if (yearToCollaborators.containsKey(year)) {
                    collaboratorNodes = (Set)yearToCollaborators.get(year);
                    collaboratorNodes.add(currNode);
                    continue;
                }
                collaboratorNodes = new HashSet();
                collaboratorNodes.add(currNode);
                yearToCollaborators.put(year, collaboratorNodes);
            }
        }
        return yearToCollaborators;
    }

    public static String slugify(String textToBeSlugified) {
        String textBlockSeparator = "-";
        return StringUtils.removeEnd((String)StringUtils.substring((String)textToBeSlugified.toLowerCase().trim().replaceAll("[^a-zA-Z0-9-]+", textBlockSeparator), (int)0, (int)20), (String)textBlockSeparator);
    }

    public static ResponseValues handleMalformedParameters(String errorPageTitle, String errorMessage, VitroRequest vitroRequest) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("error", errorMessage);
        body.put("title", errorPageTitle);
        return new TemplateResponseValues("/visualization/visualizationError.ftl", body);
    }

    public static void handleMalformedParameters(String errorMessage, HttpServletResponse response, Log log) throws IOException {
        GenericQueryMap errorDataResponse = new GenericQueryMap();
        errorDataResponse.addEntry("error", errorMessage);
        ObjectMapper mapper = new ObjectMapper();
        response.setContentType("application/octet-stream");
        mapper.writeValue((Writer)response.getWriter(), (Object)errorDataResponse);
    }

    public static DateTime getValidParsedDateTimeObject(String unparsedDateTime) {
        for (DateTimeFormatter currentFormatter : VOConstants.POSSIBLE_DATE_TIME_FORMATTERS) {
            try {
                DateTime dateTime = currentFormatter.parseDateTime(unparsedDateTime);
                return dateTime;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static String getValidYearFromCoreDateTimeString(String inputDate, String defaultYearInCaseOfError) {
        DateTime validParsedDateTimeObject;
        String parsedInputYear = defaultYearInCaseOfError;
        if (inputDate != null && (validParsedDateTimeObject = UtilityFunctions.getValidParsedDateTimeObject(inputDate)) != null) {
            return String.valueOf(validParsedDateTimeObject.getYear());
        }
        return parsedInputYear;
    }

    public static String getCSVDownloadURL(String individualURI, String visType, String visMode) {
        UrlBuilder.ParamMap csvDownloadURLParams = null;
        csvDownloadURLParams = StringUtils.isBlank((CharSequence)visMode) ? new UrlBuilder.ParamMap(new String[]{"uri", individualURI, "vis", visType}) : new UrlBuilder.ParamMap(new String[]{"uri", individualURI, "vis", visType, "vis_mode", visMode});
        String csvDownloadLink = UrlBuilder.getUrl((String)"/visualizationData", (UrlBuilder.ParamMap)csvDownloadURLParams);
        return csvDownloadLink != null ? csvDownloadLink : "";
    }

    public static String getCollaboratorshipNetworkLink(String individualURI, String visType, String visMode) {
        UrlBuilder.ParamMap collaboratorshipNetworkURLParams = new UrlBuilder.ParamMap(new String[]{"uri", individualURI, "vis", visType, "vis_mode", visMode});
        String collaboratorshipNetworkURL = UrlBuilder.getUrl((String)"/visualization", (UrlBuilder.ParamMap)collaboratorshipNetworkURLParams);
        return collaboratorshipNetworkURL != null ? collaboratorshipNetworkURL : "";
    }

    public static boolean isEntityAPerson(VitroRequest vreq, String individualURI) throws MalformedQueryParametersException {
        Individual individualByURI = vreq.getWebappDaoFactory().getIndividualDao().getIndividualByURI(individualURI);
        if (individualByURI != null) {
            return individualByURI.isVClass("http://xmlns.com/foaf/0.1/Person");
        }
        throw new MalformedQueryParametersException("Individual with " + individualURI + " not found in the system.");
    }

    public static String getIndividualLocalName(String givenURI, VitroRequest vitroRequest) {
        if (UrlBuilder.isUriInDefaultNamespace((String)givenURI, (VitroRequest)vitroRequest)) {
            try {
                Individual individual = vitroRequest.getWebappDaoFactory().getIndividualDao().getIndividualByURI(givenURI);
                return individual.getLocalName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static String getIndividualLabelFromDAO(VitroRequest vitroRequest, String entityURI) {
        IndividualDao iDao = vitroRequest.getWebappDaoFactory().getIndividualDao();
        Individual ind = iDao.getIndividualByURI(entityURI);
        String individualLabel = "Unknown Individual";
        if (ind != null) {
            individualLabel = ind.getName();
        }
        return individualLabel;
    }
}

