/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.IndividualTemplateModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VIVOIndividualTemplateModel
extends IndividualTemplateModel {
    private static final Log log = LogFactory.getLog(VIVOIndividualTemplateModel.class);
    private static final String FOAF = "http://xmlns.com/foaf/0.1/";
    private static final String PERSON_CLASS = "http://xmlns.com/foaf/0.1/Person";
    private static final String AWARD_CLASS = "http://vivoweb.org/ontology/core#Award";
    private static final String DEGREE_CLASS = "http://vivoweb.org/ontology/core#AcademicDegree";
    private static final String CONTACT_CLASS = "http://purl.obolibrary.org/obo/ARG_2000376";
    private static final String CREDENTIAL_CLASS = "http://vivoweb.org/ontology/core#Credential";
    private static final String DTP_CLASS = "http://vivoweb.org/ontology/core#DateTimeValuePrecision";
    private static final String ORGANIZATION_CLASS = "http://xmlns.com/foaf/0.1/Organization";
    private static final String EVENT_CLASS = "http://purl.org/NET/c4dm/event.owl#Event";
    private static final String INFO_CONTENT_ENTITY_CLASS = "http://purl.obolibrary.org/obo/IAO_0000030";
    private static final String BASE_VISUALIZATION_URL = UrlBuilder.getUrl((String)UrlBuilder.Route.VISUALIZATION_SHORT.path());

    VIVOIndividualTemplateModel(Individual individual, VitroRequest vreq) {
        super(individual, vreq);
    }

    private String getVisUrl(String visPath) {
        boolean isUsingDefaultNameSpace = UrlBuilder.isUriInDefaultNamespace((String)this.getUri(), (VitroRequest)this.vreq);
        String visUrl = isUsingDefaultNameSpace ? visPath + this.getLocalName() : UrlBuilder.addParams((String)visPath, (UrlBuilder.ParamMap)new UrlBuilder.ParamMap(new String[]{"uri", this.getUri()}));
        return visUrl;
    }

    public boolean conceptSubclass() {
        return this.isVClass(AWARD_CLASS) || this.isVClass(DEGREE_CLASS) || this.isVClass(CONTACT_CLASS) || this.isVClass(CREDENTIAL_CLASS) || this.isVClass(DTP_CLASS);
    }

    public boolean person() {
        return this.isVClass(PERSON_CLASS);
    }

    public boolean organization() {
        return this.isVClass(ORGANIZATION_CLASS);
    }

    public boolean event() {
        return this.isVClass(EVENT_CLASS);
    }

    public boolean infoContentEntity() {
        return this.isVClass(INFO_CONTENT_ENTITY_CLASS);
    }

    public String coAuthorVisUrl() {
        String url = BASE_VISUALIZATION_URL + "/" + "author-network" + "/";
        return this.getVisUrl(url);
    }

    public String coInvestigatorVisUrl() {
        String url = BASE_VISUALIZATION_URL + "/" + "investigator-network" + "/";
        return this.getVisUrl(url);
    }

    public String temporalGraphUrl() {
        String url = BASE_VISUALIZATION_URL + "/" + "publication-graph" + "/";
        return this.getVisUrl(url);
    }

    public String mapOfScienceUrl() {
        String url = BASE_VISUALIZATION_URL + "/" + "map-of-science" + "/";
        return this.getVisUrl(url);
    }
}

