/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.specialrelationships.RelationshipChecker;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractPropertyStatementAction;
import java.util.List;

public class CourseChecker
extends RelationshipChecker {
    private static final String URI_COURSE_TYPE = "http://vivoweb.org/ontology/core#Course";
    private static final String URI_TEACHER_ROLE_TYPE = "http://vivoweb.org/ontology/core#TeacherRole";
    private final String[] resourceUris;

    public CourseChecker(AbstractPropertyStatementAction action) {
        super(action.getOntModel());
        this.resourceUris = action.getResourceUris();
    }

    public PolicyDecision isAuthorized(List<String> userUris) {
        for (String resourceUri : this.resourceUris) {
            if (!this.isCourse(resourceUri) || !this.anyUrisInCommon(userUris, this.getUrisOfTeachers(resourceUri))) continue;
            return this.authorizedTeacher(resourceUri);
        }
        return null;
    }

    private boolean isCourse(String resourceUri) {
        return this.isResourceOfType(resourceUri, URI_COURSE_TYPE);
    }

    private List<String> getUrisOfTeachers(String resourceUri) {
        return this.getObjectsThroughLinkingNode(resourceUri, "http://purl.obolibrary.org/obo/BFO_0000055", URI_TEACHER_ROLE_TYPE, "http://purl.obolibrary.org/obo/RO_0000052");
    }

    private PolicyDecision authorizedTeacher(String resourceUri) {
        return this.authorizedDecision("User is a Teacher of " + resourceUri);
    }
}

