/*
 * Decompiled with CFR 0.152.
 */
package org.vivoweb.webapp.controller.freemarker;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.NewURIMakerVitro;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.vivoweb.webapp.createandlink.Citation;
import org.vivoweb.webapp.createandlink.CreateAndLinkResourceProvider;
import org.vivoweb.webapp.createandlink.CreateAndLinkUtils;
import org.vivoweb.webapp.createandlink.ExternalIdentifiers;
import org.vivoweb.webapp.createandlink.ResourceModel;
import org.vivoweb.webapp.createandlink.crossref.CrossrefCreateAndLinkResourceProvider;
import org.vivoweb.webapp.createandlink.pubmed.PubMedCreateAndLinkResourceProvider;

@WebServlet(name="CreateAndLinkResource", urlPatterns={"/createAndLink/*"})
public class CreateAndLinkResourceController
extends FreemarkerHttpServlet {
    public static final AuthorizationRequest REQUIRED_ACTIONS = SimplePermission.EDIT_OWN_ACCOUNT.ACTION;
    private static final Map<String, String> typeToClassMap = new HashMap<String, String>();
    private static final Map<String, CreateAndLinkResourceProvider> providers = new HashMap<String, CreateAndLinkResourceProvider>();
    private static boolean providersRegistered = false;
    public static final String BIBO_ABSTRACT = "http://purl.org/ontology/bibo/abstract";
    public static final String BIBO_ARTICLE = "http://purl.org/ontology/bibo/Article";
    public static final String BIBO_BOOK = "http://purl.org/ontology/bibo/Book";
    public static final String BIBO_DOI = "http://purl.org/ontology/bibo/doi";
    public static final String BIBO_ISBN10 = "http://purl.org/ontology/bibo/isbn10";
    public static final String BIBO_ISBN13 = "http://purl.org/ontology/bibo/isbn13";
    public static final String BIBO_ISSN = "http://purl.org/ontology/bibo/issn";
    public static final String BIBO_ISSUE = "http://purl.org/ontology/bibo/issue";
    public static final String BIBO_JOURNAL = "http://purl.org/ontology/bibo/Journal";
    public static final String BIBO_PAGE_COUNT = "http://purl.org/ontology/bibo/numPages";
    public static final String BIBO_PAGE_END = "http://purl.org/ontology/bibo/pageEnd";
    public static final String BIBO_PAGE_START = "http://purl.org/ontology/bibo/pageStart";
    public static final String BIBO_PMID = "http://purl.org/ontology/bibo/pmid";
    public static final String BIBO_VOLUME = "http://purl.org/ontology/bibo/volume";
    public static final String FOAF_FIRSTNAME = "http://xmlns.com/foaf/0.1/firstName";
    public static final String FOAF_LASTNAME = "http://xmlns.com/foaf/0.1/lastName";
    public static final String OBO_CONTACT_INFO_FOR = "http://purl.obolibrary.org/obo/ARG_2000029";
    public static final String OBO_HAS_CONTACT_INFO = "http://purl.obolibrary.org/obo/ARG_2000028";
    public static final String OBO_INHERES_IN = "http://purl.obolibrary.org/obo/RO_0000052";
    public static final String OBO_BEARER_OF = "http://purl.obolibrary.org/obo/RO_0000053";
    public static final String RDFS_LABEL = "http://www.w3.org/2000/01/rdf-schema#label";
    public static final String VIVO_AUTHORSHIP = "http://vivoweb.org/ontology/core#Authorship";
    public static final String VIVO_DATETIME = "http://vivoweb.org/ontology/core#dateTime";
    public static final String VIVO_DATETIMEPRECISION = "http://vivoweb.org/ontology/core#dateTimePrecision";
    public static final String VIVO_DATETIMEVALUE = "http://vivoweb.org/ontology/core#dateTimeValue";
    public static final String VIVO_EDITORSHIP = "http://vivoweb.org/ontology/core#Editorship";
    public static final String VIVO_HASPUBLICATIONVENUE = "http://vivoweb.org/ontology/core#hasPublicationVenue";
    public static final String VIVO_PMCID = "http://vivoweb.org/ontology/core#pmcid";
    public static final String VIVO_PUBLICATIONVENUEFOR = "http://vivoweb.org/ontology/core#publicationVenueFor";
    public static final String VIVO_PUBLISHER = "http://vivoweb.org/ontology/core#publisher";
    public static final String VIVO_PUBLISHER_CLASS = "http://vivoweb.org/ontology/core#Publisher";
    public static final String VIVO_PUBLISHER_OF = "http://vivoweb.org/ontology/core#publisherOf";
    public static final String VIVO_RANK = "http://vivoweb.org/ontology/core#rank";
    public static final String VIVO_RELATEDBY = "http://vivoweb.org/ontology/core#relatedBy";
    public static final String VIVO_RELATES = "http://vivoweb.org/ontology/core#relates";
    public static final String VCARD_FAMILYNAME = "http://www.w3.org/2006/vcard/ns#familyName";
    public static final String VCARD_GIVENNAME = "http://www.w3.org/2006/vcard/ns#givenName";
    public static final String VCARD_HAS_NAME = "http://www.w3.org/2006/vcard/ns#hasName";
    public static final String VCARD_HAS_URL = "http://www.w3.org/2006/vcard/ns#hasURL";
    public static final String VCARD_INDIVIDUAL = "http://www.w3.org/2006/vcard/ns#Individual";
    public static final String VCARD_KIND = "http://www.w3.org/2006/vcard/ns#Kind";
    public static final String VCARD_NAME = "http://www.w3.org/2006/vcard/ns#Name";
    public static final String VCARD_URL_CLASS = "http://www.w3.org/2006/vcard/ns#URL";
    public static final String VCARD_URL_PROPERTY = "http://www.w3.org/2006/vcard/ns#url";
    private static final String PROVIDER_DOI = "doi";
    private static final String PROVIDER_PMID = "pmid";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext ctx = config.getServletContext();
        ConfigurationProperties props = ConfigurationProperties.getBean((ServletContext)ctx);
        typeToClassMap.put("article", BIBO_ARTICLE);
        typeToClassMap.put("article-journal", "http://purl.org/ontology/bibo/AcademicArticle");
        typeToClassMap.put("book", BIBO_BOOK);
        typeToClassMap.put("chapter", "http://purl.org/ontology/bibo/Chapter");
        typeToClassMap.put("dataset", "http://vivoweb.org/ontology/core#Dataset");
        typeToClassMap.put("figure", "http://purl.org/ontology/bibo/Image");
        typeToClassMap.put("graphic", "http://purl.org/ontology/bibo/Image");
        typeToClassMap.put("legal_case", "http://purl.org/ontology/bibo/LegalCaseDocument");
        typeToClassMap.put("legislation", "http://purl.org/ontology/bibo/Legislation");
        typeToClassMap.put("manuscript", "http://purl.org/ontology/bibo/Manuscript");
        typeToClassMap.put("map", "http://purl.org/ontology/bibo/Map");
        typeToClassMap.put("musical_score", "http://vivoweb.org/ontology/core#Score");
        typeToClassMap.put("paper-conference", "http://vivoweb.org/ontology/core#ConferencePaper");
        typeToClassMap.put("patent", "http://purl.org/ontology/bibo/Patent");
        typeToClassMap.put("personal_communication", "http://purl.org/ontology/bibo/PersonalCommunicationDocument");
        typeToClassMap.put("post-weblog", "http://vivoweb.org/ontology/core#BlogPosting");
        typeToClassMap.put("report", "http://purl.org/ontology/bibo/Report");
        typeToClassMap.put("review", "http://vivoweb.org/ontology/core#Review");
        typeToClassMap.put("speech", "http://vivoweb.org/ontology/core#Speech");
        typeToClassMap.put("thesis", "http://purl.org/ontology/bibo/Thesis");
        typeToClassMap.put("webpage", "http://purl.org/ontology/bibo/Webpage");
        CreateAndLinkResourceController.registerProviders(props);
    }

    public static Set<String> getEnabledProviders(ConfigurationProperties props) {
        if (!providersRegistered) {
            CreateAndLinkResourceController.registerProviders(props);
        }
        return providers.keySet();
    }

    public static synchronized void registerProviders(ConfigurationProperties props) {
        if (!providersRegistered) {
            String provStr = props.getProperty("createAndLink.providers", "doi, pmid");
            if (!StringUtils.isEmpty((CharSequence)provStr)) {
                String[] provArr;
                for (String provId : provArr = provStr.split("[,]")) {
                    if (PROVIDER_DOI.equalsIgnoreCase(provId.trim())) {
                        providers.put(PROVIDER_DOI, new CrossrefCreateAndLinkResourceProvider());
                        continue;
                    }
                    if (!PROVIDER_PMID.equalsIgnoreCase(provId.trim())) continue;
                    providers.put(PROVIDER_PMID, new PubMedCreateAndLinkResourceProvider());
                }
            }
            providersRegistered = true;
        }
    }

    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return REQUIRED_ACTIONS;
    }

    protected ResponseValues processRequest(VitroRequest vreq) {
        ExternalIdentifiers allExternalIds;
        AddObjectPropertyStatement aops;
        AddDataPropertyStatement adps;
        String requestURI = vreq.getRequestURI();
        CreateAndLinkResourceProvider provider = null;
        String externalProvider = null;
        int typePos = requestURI.indexOf("/createAndLink/") + 15;
        if (typePos < requestURI.length()) {
            externalProvider = requestURI.indexOf(47, typePos) > typePos ? requestURI.substring(typePos, requestURI.indexOf(47, typePos) - 1) : requestURI.substring(typePos);
            if (providers.containsKey(externalProvider = externalProvider.trim().toLowerCase())) {
                provider = providers.get(externalProvider);
            }
        }
        if (provider == null) {
            return new TemplateResponseValues("unknownResourceType.ftl");
        }
        IndividualDao individualDao = vreq.getWebappDaoFactory().getIndividualDao();
        Individual person = null;
        String profileUri = vreq.getParameter("profileUri");
        if (!StringUtils.isEmpty((CharSequence)profileUri)) {
            person = individualDao.getIndividualByURI(profileUri);
        }
        boolean isProfileUriForLoggedIn = false;
        UserAccount loggedInAccount = LoginStatusBean.getCurrentUser((HttpServletRequest)vreq);
        SelfEditingConfiguration sec = SelfEditingConfiguration.getBean((ServletRequest)vreq);
        List assocInds = sec.getAssociatedIndividuals(vreq.getWebappDaoFactory().getIndividualDao(), loggedInAccount.getExternalAuthId());
        if (!assocInds.isEmpty()) {
            if (person == null) {
                profileUri = ((Individual)assocInds.get(0)).getURI();
                if (!StringUtils.isEmpty((CharSequence)profileUri)) {
                    person = individualDao.getIndividualByURI(profileUri);
                    isProfileUriForLoggedIn = true;
                }
            } else if (!StringUtils.isEmpty((CharSequence)profileUri)) {
                for (Individual ind : assocInds) {
                    if (!ind.getURI().equalsIgnoreCase(profileUri)) continue;
                    isProfileUriForLoggedIn = true;
                }
            }
        }
        if (person == null) {
            return new TemplateResponseValues("unknownProfile.ftl");
        }
        if (!(isProfileUriForLoggedIn || PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, (AuthorizationRequest[])new AuthorizationRequest[]{SimplePermission.DO_BACK_END_EDITING.ACTION}) || PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, (AuthorizationRequest[])new AuthorizationRequest[]{(adps = new AddDataPropertyStatement(vreq.getJenaOntModel(), profileUri, RequestedAction.SOME_URI, RequestedAction.SOME_LITERAL)).or((AuthorizationRequest)(aops = new AddObjectPropertyStatement(vreq.getJenaOntModel(), profileUri, RequestedAction.SOME_PREDICATE, RequestedAction.SOME_URI)))}))) {
            return new TemplateResponseValues("unauthorizedForProfile.ftl");
        }
        HashMap<String, Object> templateValues = new HashMap<String, Object>();
        templateValues.put("link", profileUri);
        templateValues.put("label", provider.getLabel());
        templateValues.put("provider", externalProvider);
        templateValues.put("profileUri", profileUri);
        templateValues.put("personLabel", person.getRdfsLabel());
        templateValues.put("personThumbUrl", person.getThumbUrl());
        String action = vreq.getParameter("action");
        if (action == null) {
            action = "";
        }
        String externalIdsToFind = null;
        if ("confirmID".equals(action)) {
            Object[] externalIds = vreq.getParameterValues("externalId");
            if (!ArrayUtils.isEmpty((Object[])externalIds)) {
                Model existingModel = ModelFactory.createDefaultModel();
                Model updatedModel = ModelFactory.createDefaultModel();
                for (Object externalId : externalIds) {
                    if (StringUtils.isEmpty((CharSequence)(externalId = provider.normalize((String)externalId))) || "notmine".equalsIgnoreCase(vreq.getParameter("contributor" + (String)externalId))) continue;
                    String vivoUri = vreq.getParameter("vivoUri" + (String)externalId);
                    if (StringUtils.isEmpty((CharSequence)vivoUri)) {
                        allExternalIds = provider.allExternalIDsForFind((String)externalId);
                        vivoUri = this.findInVIVO(vreq, allExternalIds, profileUri, null);
                    }
                    if (StringUtils.isEmpty((CharSequence)vivoUri)) {
                        ResourceModel resourceModel = null;
                        String typeUri = vreq.getParameter("type" + (String)externalId);
                        String resourceProvider = vreq.getParameter("externalProvider" + (String)externalId);
                        resourceModel = providers.containsKey(resourceProvider) ? providers.get(resourceProvider).makeResourceModel((String)externalId, vreq.getParameter("externalResource" + (String)externalId)) : provider.makeResourceModel((String)externalId, vreq.getParameter("externalResource" + (String)externalId));
                        if (resourceModel != null) {
                            vivoUri = this.createVIVOObject(vreq, updatedModel, resourceModel, typeUri);
                        }
                    } else {
                        Model existingResourceModel = this.getExistingResource(vreq, vivoUri);
                        existingModel.add(existingResourceModel);
                        updatedModel.add(existingResourceModel);
                    }
                    this.processRelationships(vreq, updatedModel, vivoUri, profileUri, vreq.getParameter("contributor" + (String)externalId));
                }
                this.writeChanges(vreq.getRDFService(), existingModel, updatedModel);
            }
            if (StringUtils.isEmpty((CharSequence)(externalIdsToFind = vreq.getParameter("remainderIds")))) {
                templateValues.put("showConfirmation", true);
                return new TemplateResponseValues("createAndLinkResourceEnterID.ftl", templateValues);
            }
        } else if ("findID".equals(action)) {
            externalIdsToFind = vreq.getParameter("externalIds");
        }
        if (!StringUtils.isEmpty(externalIdsToFind)) {
            String[] externalIdArr;
            HashSet<String> uniqueIds = new HashSet<String>();
            HashSet<String> remainderIds = new HashSet<String>();
            ArrayList<Citation> citations = new ArrayList<Citation>();
            for (String externalId : externalIdArr = externalIdsToFind.split("[\\s,]+")) {
                if (StringUtils.isEmpty((CharSequence)(externalId = provider.normalize(externalId))) || uniqueIds.contains(externalId)) continue;
                uniqueIds.add(externalId);
            }
            int idCount = 0;
            for (String externalId : uniqueIds) {
                if (idCount > 4) {
                    remainderIds.add(externalId);
                    continue;
                }
                Citation citation = new Citation();
                citation.externalId = externalId;
                allExternalIds = provider.allExternalIDsForFind(externalId);
                citation.vivoUri = this.findInVIVO(vreq, allExternalIds, profileUri, citation);
                if (StringUtils.isEmpty((CharSequence)citation.vivoUri)) {
                    CreateAndLinkResourceProvider doiProvider;
                    if (!StringUtils.isEmpty((CharSequence)allExternalIds.DOI) && (doiProvider = providers.get(PROVIDER_DOI)) != null) {
                        citation.externalResource = doiProvider.findInExternal(allExternalIds.DOI, citation);
                        if (!StringUtils.isEmpty((CharSequence)citation.externalResource)) {
                            citation.externalProvider = PROVIDER_DOI;
                        }
                    }
                    if (StringUtils.isEmpty((CharSequence)citation.externalResource) && !PROVIDER_DOI.equalsIgnoreCase(externalProvider)) {
                        citation.externalResource = provider.findInExternal(externalId, citation);
                        citation.externalProvider = externalProvider;
                    }
                }
                this.proposeAuthorToLink(vreq, citation, profileUri);
                citation.typeUri = typeToClassMap.getOrDefault(citation.type, BIBO_ARTICLE);
                if (citation.vivoUri != null || citation.externalResource != null) {
                    citations.add(citation);
                    ++idCount;
                    continue;
                }
                citation.showError = true;
                citations.add(citation);
            }
            if (citations.size() > 0) {
                templateValues.put("citations", citations);
                templateValues.put("publicationTypes", this.getPublicationTypes(vreq));
                if (remainderIds.size() > 0) {
                    templateValues.put("remainderIds", StringUtils.join(remainderIds, (String)"\n"));
                    templateValues.put("remainderCount", remainderIds.size());
                }
                return new TemplateResponseValues("createAndLinkResourceConfirm.ftl", templateValues);
            }
            templateValues.put("notfound", true);
            return new TemplateResponseValues("createAndLinkResourceEnterID.ftl", templateValues);
        }
        return new TemplateResponseValues("createAndLinkResourceEnterID.ftl", templateValues);
    }

    private String getFormattedProfileName(VitroRequest vreq, String profileUri) {
        final Citation.Name name = new Citation.Name();
        name.name = null;
        String vcardQuery = "SELECT ?givenName ?familyName\nWHERE\n{\n  <" + profileUri + "> <" + OBO_HAS_CONTACT_INFO + "> ?vCard .\n  ?vCard <" + VCARD_HAS_NAME + "> ?vCardName .\n  ?vCardName <" + VCARD_FAMILYNAME + "> ?familyName .\n  OPTIONAL { ?vCardName <" + VCARD_GIVENNAME + "> ?givenName . }\n}\n";
        try {
            vreq.getRDFService().sparqlSelectQuery(vcardQuery, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    Literal givenName;
                    Literal familyName = qs.contains("familyName") ? qs.getLiteral("familyName") : null;
                    Literal literal = givenName = qs.contains("givenName") ? qs.getLiteral("givenName") : null;
                    if (StringUtils.isEmpty((CharSequence)name.name) && familyName != null) {
                        name.name = givenName != null ? CreateAndLinkUtils.formatAuthorString(familyName.getString(), givenName.getString()) : CreateAndLinkUtils.formatAuthorString(familyName.getString(), null);
                    }
                }
            });
        }
        catch (RDFServiceException e) {
            e.printStackTrace();
        }
        String foafQuery = "SELECT ?givenName ?familyName\nWHERE\n{\n  <" + profileUri + "> <" + FOAF_LASTNAME + "> ?familyName .\n  OPTIONAL { <" + profileUri + "> <" + FOAF_FIRSTNAME + "> ?givenName . }\n}";
        if (StringUtils.isEmpty((CharSequence)name.name)) {
            try {
                vreq.getRDFService().sparqlSelectQuery(foafQuery, new ResultSetConsumer(){

                    protected void processQuerySolution(QuerySolution qs) {
                        Literal givenName;
                        Literal familyName = qs.contains("familyName") ? qs.getLiteral("familyName") : null;
                        Literal literal = givenName = qs.contains("givenName") ? qs.getLiteral("givenName") : null;
                        if (StringUtils.isEmpty((CharSequence)name.name) && familyName != null) {
                            name.name = givenName != null ? CreateAndLinkUtils.formatAuthorString(familyName.getString(), givenName.getString()) : CreateAndLinkUtils.formatAuthorString(familyName.getString(), null);
                        }
                    }
                });
            }
            catch (RDFServiceException e) {
                e.printStackTrace();
            }
        }
        String labelQuery = "SELECT ?label\nWHERE\n{\n  <" + profileUri + "> <" + RDFS_LABEL + "> ?label .\n}\n";
        if (StringUtils.isEmpty((CharSequence)name.name)) {
            try {
                vreq.getRDFService().sparqlSelectQuery(labelQuery, new ResultSetConsumer(){

                    protected void processQuerySolution(QuerySolution qs) {
                        Literal label = qs.contains("label") ? qs.getLiteral("label") : null;
                        String authorStr = null;
                        if (label != null && (authorStr = label.getString()).indexOf(44) > -1) {
                            int endIdx;
                            for (endIdx = authorStr.indexOf(44); endIdx < authorStr.length() && !Character.isAlphabetic(authorStr.charAt(endIdx)); ++endIdx) {
                            }
                            authorStr = endIdx < authorStr.length() ? authorStr.substring(0, endIdx + 1) : authorStr.substring(0, authorStr.indexOf(44));
                        }
                        if (authorStr != null) {
                            name.name = authorStr;
                        }
                    }
                });
            }
            catch (RDFServiceException e) {
                e.printStackTrace();
            }
        }
        return name.name;
    }

    protected void proposeAuthorToLink(VitroRequest vreq, Citation citation, String profileUri) {
        if (citation.authors == null) {
            return;
        }
        String authorStr = this.getFormattedProfileName(vreq, profileUri);
        if (StringUtils.isEmpty((CharSequence)authorStr)) {
            return;
        }
        String authorStrLwr = authorStr.toLowerCase();
        for (Citation.Name author : citation.authors) {
            String nameLwr;
            if (author == null || author.name == null || !(nameLwr = author.name.toLowerCase()).startsWith(authorStrLwr) && !authorStrLwr.startsWith(nameLwr)) continue;
            author.proposed = true;
            break;
        }
    }

    protected Model getExistingResource(VitroRequest vreq, String uri) {
        Model model = ModelFactory.createDefaultModel();
        try {
            String query = "PREFIX vcard:    <http://www.w3.org/2006/vcard/ns#>\nPREFIX vivo:     <http://vivoweb.org/ontology/core#>\nPREFIX obo:     <http://purl.obolibrary.org/obo/>\n\nCONSTRUCT\n{\n  <" + uri + "> ?pWork ?oWork .\n  ?sJournal ?pJournal ?oJournal .\n  ?sDateTime ?pDateTime ?oDateTime .\n  ?sRel ?pRel ?oRel .\n  ?sVCard a vcard:Individual .\n  ?sVCard vcard:hasName ?sVCardName .\n  ?sVCardName ?pVCardName ?oVCardName .\n  ?sPerson ?pPerson ?oPerson .\n}\nWHERE\n{\n  {\n    <" + uri + "> ?pWork ?oWork .\n  }\n  UNION\n  {\n    <" + uri + "> vivo:hasPublicationVenue ?sJournal .\n    ?sJournal ?pJournal ?oJournal .\n  }\n  UNION\n  {\n    <" + uri + "> vivo:dateTimeValue ?sDateTime .\n    ?sDateTime ?pDateTime ?oDateTime .\n  }\n  UNION\n  {\n    <" + uri + "> vivo:relatedBy ?sRel .\n    ?sRel ?pRel ?oRel .\n  }\n  UNION\n  {\n    <" + uri + "> vivo:relatedBy ?relationship .\n    ?relationship ?pRel ?sPerson .\n    ?sPerson ?pPerson ?oPerson .\n    FILTER (?sPerson != <" + uri + ">)\n  }\n  UNION\n  {\n    <" + uri + "> vivo:relatedBy ?relationship .\n    ?relationship ?pRel ?sPerson .\n    ?sPerson obo:ARG_2000028 ?sVCard .\n    ?sVCard vcard:hasName ?sVCardName .\n    ?sVCardName ?pVCardName ?oVCardName .\n  }\n  UNION\n  {\n    <" + uri + "> vivo:relatedBy ?relationship .\n    ?relationship ?pRel ?sVCard .\n    ?sVCard vcard:hasName ?sVCardName .\n    ?sVCardName ?pVCardName ?oVCardName .\n  }\n}\n";
            vreq.getRDFService().sparqlConstructQuery(query, model);
        }
        catch (RDFServiceException rDFServiceException) {
            // empty catch block
        }
        return model;
    }

    protected void processRelationships(VitroRequest vreq, Model model, String vivoUri, String userUri, String relationship) {
        if (relationship != null) {
            if (relationship.startsWith("author")) {
                Resource authorship = model.createResource(this.getUnusedUri(vreq));
                authorship.addProperty(RDF.type, (RDFNode)model.getResource(VIVO_AUTHORSHIP));
                authorship.addProperty(model.createProperty(VIVO_RELATES), (RDFNode)model.getResource(vivoUri));
                authorship.addProperty(model.createProperty(VIVO_RELATES), (RDFNode)model.getResource(userUri));
                model.getResource(vivoUri).addProperty(model.createProperty(VIVO_RELATEDBY), (RDFNode)authorship);
                model.getResource(userUri).addProperty(model.createProperty(VIVO_RELATEDBY), (RDFNode)authorship);
                if (relationship.length() > 6) {
                    String posStr = relationship.substring(6);
                    int rank = Integer.parseInt(posStr, 10);
                    this.removeAuthorship(vreq, model, vivoUri, rank);
                    try {
                        authorship.addLiteral(model.createProperty(VIVO_RANK), (long)rank);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (relationship.startsWith("editor")) {
                Resource editorship = model.createResource(this.getUnusedUri(vreq));
                editorship.addProperty(RDF.type, (RDFNode)model.getResource(VIVO_EDITORSHIP));
                editorship.addProperty(model.createProperty(VIVO_RELATES), (RDFNode)model.getResource(vivoUri));
                editorship.addProperty(model.createProperty(VIVO_RELATES), (RDFNode)model.getResource(userUri));
                model.getResource(vivoUri).addProperty(model.createProperty(VIVO_RELATEDBY), (RDFNode)editorship);
                model.getResource(userUri).addProperty(model.createProperty(VIVO_RELATEDBY), (RDFNode)editorship);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAuthorship(VitroRequest vreq, Model model, String vivoUri, int rank) {
        Property RANK_PREDICATE = model.getProperty(VIVO_RANK);
        Property RELATES_PREDICATE = model.getProperty(VIVO_RELATES);
        Resource AUTHORSHIP_RESOURCE = model.getResource(VIVO_AUTHORSHIP);
        try (ResIterator iter = model.listSubjects();){
            while (iter.hasNext()) {
                Resource subject = (Resource)iter.next();
                if (!subject.hasProperty(RDF.type, (RDFNode)AUTHORSHIP_RESOURCE) || !subject.hasProperty(RELATES_PREDICATE, (RDFNode)model.getResource(vivoUri)) || !subject.hasLiteral(RANK_PREDICATE, (long)rank)) continue;
                model.removeAll(null, null, (RDFNode)subject);
                try (StmtIterator stmtIterator = subject.listProperties(RELATES_PREDICATE);){
                    while (stmtIterator.hasNext()) {
                        Resource relatedResource;
                        Statement stmt = (Statement)stmtIterator.next();
                        RDFNode rdfNode = stmt.getObject();
                        if (!rdfNode.isResource() || !(relatedResource = rdfNode.asResource()).hasProperty(RDF.type, (RDFNode)model.getResource(VCARD_INDIVIDUAL)) || !this.isVCardOnlyLinkedToAuthorship(vreq.getRDFService(), subject.getURI(), relatedResource.getURI())) continue;
                        this.removeVCard(model, relatedResource.getURI());
                    }
                }
                subject.removeProperties();
            }
        }
    }

    private boolean isVCardOnlyLinkedToAuthorship(RDFService rdfService, final String authorshipUri, String vcardUri) {
        final ArrayList subjects = new ArrayList();
        String query = "SELECT ?s ?p\nWHERE\n{\n  {\n  \t?s ?p <" + vcardUri + "> .\n  }\n}\n";
        try {
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    Resource subject = qs.getResource("s");
                    if (!authorshipUri.equalsIgnoreCase(subject.getURI())) {
                        subjects.add(subject.getURI());
                    }
                }
            });
        }
        catch (RDFServiceException rDFServiceException) {
            // empty catch block
        }
        return subjects.size() == 0;
    }

    protected void removeVCard(Model model, String vcardUri) {
        Resource vcard = model.getResource(vcardUri);
        Statement vcardName = vcard.getProperty(model.createProperty(VCARD_HAS_NAME));
        if (vcardName != null && vcardName.getObject().isResource()) {
            vcardName.getObject().asResource().removeProperties();
        }
        vcard.removeProperties();
    }

    protected String createVIVOObject(VitroRequest vreq, Model model, ResourceModel resourceModel, String typeUri) {
        int n;
        String vivoUri = this.getUnusedUri(vreq);
        Resource work = model.createResource(vivoUri);
        if (!StringUtils.isEmpty((CharSequence)typeUri)) {
            for (PublicationType publicationType : this.getPublicationTypes(vreq)) {
                if (!typeUri.equals(publicationType.getUri())) continue;
                work.addProperty(RDF.type, (RDFNode)model.getResource(typeUri));
                break;
            }
        }
        if (!work.hasProperty(RDF.type)) {
            work.addProperty(RDF.type, (RDFNode)model.getResource(typeToClassMap.getOrDefault(resourceModel.type, BIBO_ARTICLE)));
        }
        if (!StringUtils.isEmpty((CharSequence)resourceModel.title)) {
            work.addProperty(RDFS.label, resourceModel.title);
        }
        if (!StringUtils.isEmpty((CharSequence)resourceModel.DOI)) {
            String doi = new CrossrefCreateAndLinkResourceProvider().normalize(resourceModel.DOI);
            work.addProperty(model.createProperty(BIBO_DOI), doi);
        }
        if (!StringUtils.isEmpty((CharSequence)resourceModel.PubMedID)) {
            work.addProperty(model.createProperty(BIBO_PMID), resourceModel.PubMedID.toLowerCase());
        }
        if (!StringUtils.isEmpty((CharSequence)resourceModel.PubMedCentralID)) {
            work.addProperty(model.createProperty(VIVO_PMCID), resourceModel.PubMedCentralID.toLowerCase());
        }
        if (!"book".equals(resourceModel.type) && !"chapter".equals(resourceModel.type) && resourceModel.ISSN != null && resourceModel.ISSN.length > 0) {
            Resource journal = null;
            String journalUri = this.findVIVOUriForISSNs(vreq.getRDFService(), resourceModel.ISSN);
            if (!StringUtils.isEmpty((CharSequence)journalUri)) {
                journal = model.getResource(journalUri);
            } else {
                journal = model.createResource(this.getUnusedUri(vreq));
                journal.addProperty(RDFS.label, resourceModel.containerTitle);
                journal.addProperty(RDF.type, (RDFNode)model.getResource(BIBO_JOURNAL));
                String[] stringArray = resourceModel.ISSN;
                n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String issn = stringArray[i];
                    journal.addProperty(model.getProperty(BIBO_ISSN), issn);
                }
                if (!StringUtils.isEmpty((CharSequence)resourceModel.publisher)) {
                    String publisherUri = this.findVIVOUriForPublisher(vreq.getRDFService(), resourceModel.publisher);
                    Resource publisher = null;
                    if (!StringUtils.isEmpty((CharSequence)publisherUri)) {
                        publisher = model.getResource(publisherUri);
                    } else {
                        publisher = model.createResource(this.getPublisherURI(vreq, resourceModel.publisher));
                        publisher.addProperty(RDFS.label, resourceModel.publisher);
                        publisher.addProperty(RDF.type, (RDFNode)model.getResource(VIVO_PUBLISHER_CLASS));
                    }
                    if (publisher != null) {
                        publisher.addProperty(model.createProperty(VIVO_PUBLISHER_OF), (RDFNode)journal);
                        journal.addProperty(model.createProperty(VIVO_PUBLISHER), (RDFNode)publisher);
                    }
                }
            }
            if (journal != null) {
                journal.addProperty(model.getProperty(VIVO_PUBLICATIONVENUEFOR), (RDFNode)work);
                work.addProperty(model.getProperty(VIVO_HASPUBLICATIONVENUE), (RDFNode)journal);
            }
        }
        if (resourceModel.ISBN != null && resourceModel.ISBN.length > 0) {
            int length;
            for (String isbn : resourceModel.ISBN) {
                length = this.getDigitCount(isbn);
                if (length == 10) {
                    work.addProperty(model.getProperty(BIBO_ISBN10), isbn);
                    continue;
                }
                work.addProperty(model.getProperty(BIBO_ISBN13), isbn);
            }
            if ("chapter".equals(resourceModel.type)) {
                Resource book = null;
                String bookUri = this.findVIVOUriForISBNs(vreq.getRDFService(), resourceModel.ISBN);
                if (StringUtils.isEmpty((CharSequence)bookUri)) {
                    book = model.createResource(this.getUnusedUri(vreq));
                    book.addProperty(RDFS.label, resourceModel.containerTitle);
                    book.addProperty(RDF.type, (RDFNode)model.getResource(BIBO_BOOK));
                    String[] publisherUri = resourceModel.ISBN;
                    n = publisherUri.length;
                    for (length = 0; length < n; ++length) {
                        String isbn = publisherUri[length];
                        if (this.getDigitCount(isbn) == 10) {
                            book.addProperty(model.getProperty(BIBO_ISBN10), isbn);
                            continue;
                        }
                        book.addProperty(model.getProperty(BIBO_ISBN13), isbn);
                    }
                    if (!StringUtils.isEmpty((CharSequence)resourceModel.publisher)) {
                        Resource publisher = model.createResource(this.getPublisherURI(vreq, resourceModel.publisher));
                        publisher.addProperty(RDFS.label, resourceModel.publisher);
                        publisher.addProperty(RDF.type, (RDFNode)model.getResource(VIVO_PUBLISHER_CLASS));
                        publisher.addProperty(model.createProperty(VIVO_PUBLISHER_OF), (RDFNode)book);
                        book.addProperty(model.createProperty(VIVO_PUBLISHER), (RDFNode)publisher);
                    }
                } else {
                    book = model.getResource(bookUri);
                }
                if (book != null) {
                    book.addProperty(model.getProperty(VIVO_PUBLICATIONVENUEFOR), (RDFNode)work);
                    work.addProperty(model.getProperty(VIVO_HASPUBLICATIONVENUE), (RDFNode)book);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)resourceModel.volume)) {
            work.addProperty(model.createProperty(BIBO_VOLUME), resourceModel.volume);
        }
        if (!StringUtils.isEmpty((CharSequence)resourceModel.issue)) {
            work.addProperty(model.createProperty(BIBO_ISSUE), resourceModel.issue);
        }
        if (!StringUtils.isEmpty((CharSequence)resourceModel.pageStart)) {
            work.addProperty(model.createProperty(BIBO_PAGE_START), resourceModel.pageStart);
        }
        if (!StringUtils.isEmpty((CharSequence)resourceModel.pageEnd)) {
            work.addProperty(model.createProperty(BIBO_PAGE_END), resourceModel.pageEnd);
        }
        if (!StringUtils.isEmpty((CharSequence)resourceModel.pageStart) && !StringUtils.isEmpty((CharSequence)resourceModel.pageEnd)) {
            try {
                int pageStart = Integer.parseInt(resourceModel.pageStart, 10);
                int pageEnd = Integer.parseInt(resourceModel.pageEnd, 10);
                if (pageStart > 0) {
                    if (pageEnd > pageStart) {
                        work.addLiteral(model.createProperty(BIBO_PAGE_COUNT), (long)(pageEnd - pageStart));
                    } else if (pageEnd == pageStart) {
                        work.addLiteral(model.createProperty(BIBO_PAGE_COUNT), 1L);
                    }
                }
            }
            catch (NumberFormatException pageStart) {
                // empty catch block
            }
        }
        this.addDateToResource(vreq, work, resourceModel.publicationDate);
        if (!StringUtils.isEmpty((CharSequence)resourceModel.abstractText)) {
            work.addProperty(model.createProperty(BIBO_ABSTRACT), resourceModel.abstractText);
        }
        if (resourceModel.author != null) {
            int rank = 1;
            for (ResourceModel.NameField author : resourceModel.author) {
                if (author != null) {
                    Resource vcard = model.createResource(this.getVCardURI(vreq, author.family, author.given));
                    vcard.addProperty(RDF.type, (RDFNode)model.getResource(VCARD_INDIVIDUAL));
                    Resource name = model.createResource(this.getUnusedUri(vreq));
                    vcard.addProperty(model.createProperty(VCARD_HAS_NAME), (RDFNode)name);
                    name.addProperty(RDF.type, (RDFNode)model.getResource(VCARD_NAME));
                    if (!StringUtils.isEmpty((CharSequence)author.given)) {
                        name.addProperty(model.createProperty(VCARD_GIVENNAME), author.given);
                    }
                    if (!StringUtils.isEmpty((CharSequence)author.family)) {
                        name.addProperty(model.createProperty(VCARD_FAMILYNAME), author.family);
                    }
                    Resource authorship = model.createResource(this.getUnusedUri(vreq));
                    authorship.addProperty(RDF.type, (RDFNode)model.getResource(VIVO_AUTHORSHIP));
                    authorship.addProperty(model.createProperty(VIVO_RELATES), (RDFNode)model.getResource(vivoUri));
                    authorship.addProperty(model.createProperty(VIVO_RELATES), (RDFNode)model.getResource(vcard.getURI()));
                    model.getResource(vivoUri).addProperty(model.createProperty(VIVO_RELATEDBY), (RDFNode)authorship);
                    vcard.addProperty(model.createProperty(VIVO_RELATEDBY), (RDFNode)authorship);
                    authorship.addLiteral(model.createProperty(VIVO_RANK), (long)rank);
                }
                ++rank;
            }
        }
        if (!StringUtils.isEmpty((CharSequence)resourceModel.URL)) {
            try {
                URL url = new URL(resourceModel.URL);
                Resource urlModel = model.createResource(this.getUnusedUri(vreq));
                urlModel.addProperty(RDF.type, (RDFNode)model.getResource(VCARD_URL_CLASS));
                urlModel.addLiteral(model.createProperty(VCARD_URL_PROPERTY), (Object)url);
                Resource kindModel = model.createResource(this.getUnusedUri(vreq));
                kindModel.addProperty(RDF.type, (RDFNode)model.getResource(VCARD_KIND));
                kindModel.addProperty(model.createProperty(VCARD_HAS_URL), (RDFNode)urlModel);
                kindModel.addProperty(model.createProperty(OBO_CONTACT_INFO_FOR), (RDFNode)work);
                work.addProperty(model.createProperty(OBO_HAS_CONTACT_INFO), (RDFNode)kindModel);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return vivoUri;
    }

    protected String getPublisherURI(VitroRequest vreq, String publisher) {
        return this.getUnusedUri(vreq);
    }

    protected String getVCardURI(VitroRequest vreq, String familyName, String givenName) {
        return this.getUnusedUri(vreq);
    }

    protected boolean addDateToResource(VitroRequest vreq, Resource work, ResourceModel.DateField date) {
        Model model = work.getModel();
        if (date == null || date.year == null) {
            return false;
        }
        String formattedDate = null;
        String precision = null;
        if (date.month != null) {
            if (date.day != null) {
                formattedDate = String.format("%04d-%02d-%02dT00:00:00", date.year, date.month, date.day);
                precision = "http://vivoweb.org/ontology/core#dayPrecision";
            } else {
                formattedDate = String.format("%04d-%02d-01T00:00:00", date.year, date.month);
                precision = "http://vivoweb.org/ontology/core#monthPrecision";
            }
        } else {
            formattedDate = String.format("%04d-01-01T00:00:00", date.year);
            precision = "http://vivoweb.org/ontology/core#yearPrecision";
        }
        Resource dateResource = model.createResource(this.getUnusedUri(vreq)).addProperty(RDF.type, (RDFNode)model.getResource("http://vivoweb.org/ontology/core#DateTimeValue"));
        dateResource.addProperty(model.createProperty(VIVO_DATETIME), formattedDate);
        dateResource.addProperty(model.createProperty(VIVO_DATETIMEPRECISION), precision);
        work.addProperty(model.createProperty(VIVO_DATETIMEVALUE), (RDFNode)dateResource);
        return true;
    }

    private String getUnusedUri(VitroRequest vreq) {
        NewURIMakerVitro uriMaker = new NewURIMakerVitro(vreq.getWebappDaoFactory());
        try {
            return uriMaker.getUnusedNewURI(null);
        }
        catch (InsertException insertException) {
            return null;
        }
    }

    private String findVIVOUriForISSNs(RDFService rdfService, String[] issns) {
        if (issns != null && issns.length > 0) {
            for (String issn : issns) {
                final ArrayList journals = new ArrayList();
                String query = "SELECT ?journal\nWHERE\n{\n  {\n  \t?journal <http://purl.org/ontology/bibo/issn> \"" + issn + "\" .\n  }\n}\n";
                try {
                    rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                        protected void processQuerySolution(QuerySolution qs) {
                            Resource journal = qs.getResource("journal");
                            if (journal != null) {
                                journals.add(journal.getURI());
                            }
                        }
                    });
                }
                catch (RDFServiceException rDFServiceException) {
                    // empty catch block
                }
                if (journals.size() <= 0) continue;
                return (String)journals.get(0);
            }
        }
        return null;
    }

    private String findVIVOUriForISBNs(RDFService rdfService, String[] isbns) {
        if (isbns != null && isbns.length > 0) {
            for (String isbn : isbns) {
                final ArrayList books = new ArrayList();
                String query = "SELECT ?book\nWHERE\n{\n  {\n" + (this.getDigitCount(isbn) == 10 ? "  \t?book <http://purl.org/ontology/bibo/isbn10> \"" + isbn + "\" .\n" : "  \t?book <http://purl.org/ontology/bibo/isbn13> \"" + isbn + "\" .\n") + "  \t?book a <http://purl.org/ontology/bibo/Book> .\n  }\n}\n";
                try {
                    rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                        protected void processQuerySolution(QuerySolution qs) {
                            Resource book = qs.getResource("book");
                            if (book != null) {
                                books.add(book.getURI());
                            }
                        }
                    });
                }
                catch (RDFServiceException rDFServiceException) {
                    // empty catch block
                }
                if (books.size() <= 0) continue;
                for (String url : books) {
                    if (!url.contains(PROVIDER_DOI)) continue;
                    return url;
                }
                return (String)books.get(0);
            }
        }
        return null;
    }

    private String findVIVOUriForPublisher(RDFService rdfService, String publisher) {
        final ArrayList publisherUris = new ArrayList();
        String query = "SELECT ?publisher\nWHERE\n{\n  {\n  \t?publisher a <http://vivoweb.org/ontology/core#Publisher> .\n  \t?publisher <" + RDFS.label + "> \"" + publisher + "\" .\n  }\n}\n";
        try {
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    Resource publisherUri = qs.getResource("publisher");
                    if (publisherUri != null) {
                        publisherUris.add(publisherUri.getURI());
                    }
                }
            });
        }
        catch (RDFServiceException rDFServiceException) {
            // empty catch block
        }
        if (publisherUris.size() > 0) {
            return (String)publisherUris.get(0);
        }
        return null;
    }

    private String findVIVOUriForDOI(RDFService rdfService, String doi) {
        if (!StringUtils.isEmpty((CharSequence)doi)) {
            final ArrayList works = new ArrayList();
            String query = "SELECT ?work\nWHERE\n{\n  {\n  \t?work <http://purl.org/ontology/bibo/doi> \"" + doi + "\" .\n  }\n  UNION\n  {\n  \t?work <http://purl.org/ontology/bibo/doi> \"http://doi.org/" + doi + "\" .\n  }\n  UNION\n  {\n  \t?work <http://purl.org/ontology/bibo/doi> \"https://doi.org/" + doi + "\" .\n  }\n  UNION\n  {\n  \t?work <http://purl.org/ontology/bibo/doi> \"http://dx.doi.org/" + doi + "\" .\n  }\n  UNION\n  {\n  \t?work <http://purl.org/ontology/bibo/doi> \"https://dx.doi.org/" + doi + "\" .\n  }\n}\n";
            try {
                rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                    protected void processQuerySolution(QuerySolution qs) {
                        Resource work = qs.getResource("work");
                        if (work != null) {
                            works.add(work.getURI());
                        }
                    }
                });
            }
            catch (RDFServiceException rDFServiceException) {
                // empty catch block
            }
            if (works.size() > 0) {
                return (String)works.get(0);
            }
        }
        return null;
    }

    private int getDigitCount(String id) {
        int digits = 0;
        if (id != null) {
            for (char ch : id.toCharArray()) {
                if (!Character.isDigit(ch)) continue;
                ++digits;
            }
        }
        return digits;
    }

    private String findVIVOUriForPubMedID(RDFService rdfService, String pmid) {
        if (!StringUtils.isEmpty((CharSequence)pmid)) {
            final ArrayList works = new ArrayList();
            String query = "SELECT ?work\nWHERE\n{\n  {\n  \t?work <http://purl.org/ontology/bibo/pmid> \"" + pmid + "\" .\n  }\n}\n";
            try {
                rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                    protected void processQuerySolution(QuerySolution qs) {
                        Resource work = qs.getResource("work");
                        if (work != null) {
                            works.add(work.getURI());
                        }
                    }
                });
            }
            catch (RDFServiceException rDFServiceException) {
                // empty catch block
            }
            if (works.size() == 1) {
                return (String)works.get(0);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String findInVIVO(VitroRequest vreq, ExternalIdentifiers ids, String profileUri, Citation citation) {
        vivoUri = this.findVIVOUriForDOI(vreq.getRDFService(), ids.DOI);
        if (StringUtils.isEmpty((CharSequence)vivoUri)) {
            vivoUri = this.findVIVOUriForPubMedID(vreq.getRDFService(), ids.PubMedID);
        }
        if (citation == null) return vivoUri;
        if (StringUtils.isEmpty((CharSequence)vivoUri) != false) return vivoUri;
        model = this.getExistingResource(vreq, vivoUri);
        work = model.getResource(vivoUri);
        pageStart = null;
        pageEnd = null;
        rankedAuthors = null;
        unrankedAuthors = new ArrayList<Citation.Name>();
        stmtIterator = work.listProperties();
        try {
            block34: while (true) {
                block66: {
                    block65: {
                        block69: {
                            block68: {
                                block67: {
                                    block64: {
                                        if (!stmtIterator.hasNext()) break block64;
                                        stmt = (Statement)stmtIterator.next();
                                        var14_14 = stmt.getPredicate().getURI();
                                        var15_16 = -1;
                                        switch (var14_14.hashCode()) {
                                            case -1836724996: {
                                                if (!var14_14.equals("http://www.w3.org/2000/01/rdf-schema#label")) break;
                                                var15_16 = 0;
                                                break;
                                            }
                                            case -642962563: {
                                                if (!var14_14.equals("http://purl.org/ontology/bibo/volume")) break;
                                                var15_16 = 1;
                                                break;
                                            }
                                            case -1002451946: {
                                                if (!var14_14.equals("http://purl.org/ontology/bibo/issue")) break;
                                                var15_16 = 2;
                                                break;
                                            }
                                            case -237375536: {
                                                if (!var14_14.equals("http://purl.org/ontology/bibo/pageStart")) break;
                                                var15_16 = 3;
                                                break;
                                            }
                                            case 107001801: {
                                                if (!var14_14.equals("http://purl.org/ontology/bibo/pageEnd")) break;
                                                var15_16 = 4;
                                                break;
                                            }
                                            case 1080693679: {
                                                if (!var14_14.equals("http://vivoweb.org/ontology/core#dateTimeValue")) break;
                                                var15_16 = 5;
                                                break;
                                            }
                                            case 721934518: {
                                                if (!var14_14.equals("http://vivoweb.org/ontology/core#hasPublicationVenue")) break;
                                                var15_16 = 6;
                                                break;
                                            }
                                            case -505228421: {
                                                if (!var14_14.equals("http://vivoweb.org/ontology/core#relatedBy")) break;
                                                var15_16 = 7;
                                                break;
                                            }
                                        }
                                        switch (var15_16) {
                                            case 0: {
                                                citation.title = stmt.getString();
                                                ** break;
                                            }
                                            case 1: {
                                                citation.volume = stmt.getString();
                                                ** break;
                                            }
                                            case 2: {
                                                citation.issue = stmt.getString();
                                                ** break;
                                            }
                                            case 3: {
                                                pageStart = stmt.getString();
                                                ** break;
                                            }
                                            case 4: {
                                                pageEnd = stmt.getString();
                                                ** break;
                                            }
                                            case 5: {
                                                dateTime = stmt.getResource();
                                                if (dateTime == null) ** break;
                                                stmtDate = dateTime.getProperty(model.getProperty("http://vivoweb.org/ontology/core#dateTime"));
                                                if (stmtDate == null || (dateTimeValue = stmtDate.getString()) == null || dateTimeValue.length() <= 3) break;
                                                citation.publicationYear = Integer.parseInt(dateTimeValue.substring(0, 4), 10);
                                                ** break;
                                            }
                                            case 6: {
                                                journal = stmt.getResource();
                                                if (journal == null) ** break;
                                                stmtJournalName = journal.getProperty(RDFS.label);
                                                if (stmtJournalName == null) break;
                                                citation.journal = stmtJournalName.getString();
                                                ** break;
                                            }
                                            case 7: {
                                                relationship = stmt.getResource();
                                                if (relationship == null) ** break;
                                                rank = null;
                                                if (!this.isResourceOfType(relationship, "http://vivoweb.org/ontology/core#Authorship") && !this.isResourceOfType(relationship, "http://vivoweb.org/ontology/core#Editorship")) continue block34;
                                                personResource = null;
                                                relationshipIter = relationship.listProperties();
                                                ** try [egrp 1[TRYBLOCK] [0 : 649->823)] { 
lbl90:
                                                // 1 sources

                                                ** GOTO lbl-1000
lbl91:
                                                // 1 sources

                                                finally {
                                                    relationshipIter.close();
                                                }
                                            }
                                        }
                                        continue;
                                    }
                                    if (!StringUtils.isEmpty(pageStart)) {
                                        citation.pagination = StringUtils.isEmpty(pageEnd) == false ? pageStart + "-" + pageEnd : pageStart;
                                    }
                                    if (unrankedAuthors.size() <= 0) {
                                        citation.authors = rankedAuthors;
                                        return vivoUri;
                                    }
                                    if (rankedAuthors == null) {
                                        citation.authors = unrankedAuthors.toArray(new Citation.Name[unrankedAuthors.size()]);
                                        return vivoUri;
                                    }
                                    newAuthors = new Citation.Name[rankedAuthors.length + unrankedAuthors.size()];
                                    for (i = 0; i < rankedAuthors.length; ++i) {
                                        newAuthors[i] = rankedAuthors[i];
                                    }
                                    while (i < newAuthors.length && unrankedAuthors.size() > 0) {
                                        newAuthors[i] = (Citation.Name)unrankedAuthors.remove(0);
                                        ++i;
                                    }
                                    citation.authors = newAuthors;
                                    return vivoUri;
lbl-1000:
                                    // 3 sources

                                    {
                                        block37: while (relationshipIter.hasNext()) {
                                            relationshipStmt = (Statement)relationshipIter.next();
                                            var23_24 = relationshipStmt.getPredicate().getURI();
                                            var24_27 = -1;
                                            switch (var23_24.hashCode()) {
                                                case 862043155: {
                                                    if (!var23_24.equals("http://vivoweb.org/ontology/core#relates")) break;
                                                    var24_27 = 0;
                                                    break;
                                                }
                                                case -513940749: {
                                                    if (!var23_24.equals("http://vivoweb.org/ontology/core#rank")) break;
                                                    var24_27 = 1;
                                                    break;
                                                }
                                            }
                                            switch (var24_27) {
                                                case 0: {
                                                    if (vivoUri.equals(relationshipStmt.getResource().getURI())) break;
                                                    personResource = relationshipStmt.getResource();
                                                    break;
                                                }
                                                case 1: {
                                                    rank = relationshipStmt.getInt();
                                                    continue block37;
                                                }
                                            }
                                        }
                                    }
                                    newAuthor = null;
                                    if (personResource == null) break block65;
                                    if (profileUri.equals(personResource.getURI())) {
                                        citation.alreadyClaimed = true;
                                    }
                                    if (!this.isResourceOfType(relationship, "http://vivoweb.org/ontology/core#Authorship")) break block66;
                                    linked = false;
                                    familyName = null;
                                    givenName = null;
                                    if (!this.isResourceOfType(personResource, "http://www.w3.org/2006/vcard/ns#Individual")) break block67;
                                    if (personResource.hasProperty(model.getProperty("http://www.w3.org/2006/vcard/ns#hasName")) && (vcardName = personResource.getPropertyResourceValue(model.getProperty("http://www.w3.org/2006/vcard/ns#hasName"))) != null) {
                                        if (vcardName.hasProperty(model.getProperty("http://www.w3.org/2006/vcard/ns#givenName"))) {
                                            givenName = vcardName.getProperty(model.getProperty("http://www.w3.org/2006/vcard/ns#givenName"));
                                        }
                                        if (vcardName.hasProperty(model.getProperty("http://www.w3.org/2006/vcard/ns#familyName"))) {
                                            familyName = vcardName.getProperty(model.getProperty("http://www.w3.org/2006/vcard/ns#familyName"));
                                        }
                                    }
                                    break block68;
                                }
                                if (personResource.hasProperty(model.getProperty("http://purl.obolibrary.org/obo/ARG_2000028")) && (vCard = personResource.getPropertyResourceValue(model.getProperty("http://purl.obolibrary.org/obo/ARG_2000028"))).hasProperty(model.getProperty("http://www.w3.org/2006/vcard/ns#hasName"))) {
                                    vcardName = vCard.getPropertyResourceValue(model.getProperty("http://www.w3.org/2006/vcard/ns#hasName"));
                                    if (vcardName != null) {
                                        if (vcardName.hasProperty(model.getProperty("http://www.w3.org/2006/vcard/ns#givenName"))) {
                                            givenName = vcardName.getProperty(model.getProperty("http://www.w3.org/2006/vcard/ns#givenName"));
                                        }
                                        if (vcardName.hasProperty(model.getProperty("http://www.w3.org/2006/vcard/ns#familyName"))) {
                                            familyName = vcardName.getProperty(model.getProperty("http://www.w3.org/2006/vcard/ns#familyName"));
                                        }
                                    }
                                    linked = true;
                                }
                            }
                            if (givenName == null) {
                                if (personResource.hasProperty(model.getProperty("http://xmlns.com/foaf/0.1/firstName"))) {
                                    givenName = personResource.getProperty(model.getProperty("http://xmlns.com/foaf/0.1/firstName"));
                                }
                                if (personResource.hasProperty(model.getProperty("http://xmlns.com/foaf/0.1/lastName"))) {
                                    familyName = personResource.getProperty(model.getProperty("http://xmlns.com/foaf/0.1/lastName"));
                                }
                                linked = true;
                            }
                            if (familyName == null) break block69;
                            newAuthor = new Citation.Name();
                            newAuthor.name = givenName != null ? CreateAndLinkUtils.formatAuthorString(familyName.getString(), givenName.getString()) : CreateAndLinkUtils.formatAuthorString(familyName.getString(), null);
                            newAuthor.linked = linked;
                            break block66;
                        }
                        label = personResource.getProperty(RDFS.label);
                        if (label != null) {
                            name = label.getString();
                            if (name.contains(",")) {
                                parts = name.split("\\s*,\\s*");
                                if (parts.length > 1) {
                                    name = CreateAndLinkUtils.formatAuthorString(parts[0], parts[parts.length - 1]);
                                }
                            } else {
                                parts = name.split("\\s*");
                                if (parts.length > 1) {
                                    name = CreateAndLinkUtils.formatAuthorString(parts[parts.length - 1], parts[0]);
                                }
                            }
                            newAuthor = new Citation.Name();
                            newAuthor.name = name;
                            newAuthor.linked = linked;
                        }
                        break block66;
                    }
                    if (this.isResourceOfType(relationship, "http://vivoweb.org/ontology/core#Authorship")) {
                        newAuthor = new Citation.Name();
                        newAuthor.name = "Deleted Author";
                    }
                }
                if (newAuthor == null) ** break;
                if (rank != null) {
                    if (rankedAuthors == null) {
                        rankedAuthors = new Citation.Name[rank.intValue()];
                    } else if (rankedAuthors.length < rank) {
                        newAuthors = new Citation.Name[rank.intValue()];
                        for (i = 0; i < rankedAuthors.length; ++i) {
                            newAuthors[i] = rankedAuthors[i];
                        }
                        rankedAuthors = newAuthors;
                    }
                    rankedAuthors[rank.intValue() - 1] = newAuthor;
                    ** break;
                }
                unrankedAuthors.add(newAuthor);
lbl210:
                // 14 sources

            }
        }
        finally {
            stmtIterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isResourceOfType(Resource resource, String typeUri) {
        if (resource == null) {
            return false;
        }
        try (StmtIterator iter = resource.listProperties(RDF.type);){
            while (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                if (!typeUri.equals(stmt.getResource().getURI())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeChanges(RDFService rdfService, Model existingModel, Model updatedModel) {
        Model removeModel = existingModel.difference(updatedModel);
        Model addModel = updatedModel.difference(existingModel);
        if (!addModel.isEmpty() || !removeModel.isEmpty()) {
            InputStream addStream = null;
            InputStream removeStream = null;
            InputStream is = this.makeN3InputStream(updatedModel);
            ChangeSet changeSet = rdfService.manufactureChangeSet();
            if (!addModel.isEmpty()) {
                addStream = this.makeN3InputStream(addModel);
                changeSet.addAddition(addStream, RDFService.ModelSerializationFormat.N3, "http://vitro.mannlib.cornell.edu/default/vitro-kb-2");
            }
            if (!removeModel.isEmpty()) {
                removeStream = this.makeN3InputStream(removeModel);
                changeSet.addRemoval(removeStream, RDFService.ModelSerializationFormat.N3, "http://vitro.mannlib.cornell.edu/default/vitro-kb-2");
            }
            try {
                rdfService.changeSetUpdate(changeSet);
            }
            catch (RDFServiceException rDFServiceException) {
            }
            finally {
                if (addStream != null) {
                    try {
                        addStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (removeStream != null) {
                    try {
                        removeStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private InputStream makeN3InputStream(Model m) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        m.write((OutputStream)out, "N3");
        return new ByteArrayInputStream(out.toByteArray());
    }

    private List<PublicationType> getPublicationTypes(VitroRequest vreq) {
        final ArrayList<PublicationType> types = new ArrayList<PublicationType>();
        try {
            String query = "PREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#>\n\nSELECT ?uri ?label\nWHERE {\n\t?uri rdfs:label ?label .\n\t?uri rdfs:subClassOf  <http://purl.org/ontology/bibo/Document> .\n}\n";
            vreq.getRDFService().sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    types.add(new PublicationType(qs.getLiteral("label").getString(), qs.getResource("uri").getURI()));
                }
            });
        }
        catch (RDFServiceException rDFServiceException) {
            // empty catch block
        }
        types.sort(new Comparator<PublicationType>(){

            @Override
            public int compare(PublicationType o1, PublicationType o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        return types;
    }

    public class PublicationType {
        private String label;
        private String uri;

        public PublicationType(String label, String uri) {
            this.label = label;
            this.uri = uri;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

