/*
 * Decompiled with CFR 0.152.
 */
package org.vivoweb.webapp.createandlink.pubmed;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.cornell.mannlib.vitro.webapp.utils.http.HttpClientFactory;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.vivoweb.webapp.createandlink.Citation;
import org.vivoweb.webapp.createandlink.CreateAndLinkResourceProvider;
import org.vivoweb.webapp.createandlink.ExternalIdentifiers;
import org.vivoweb.webapp.createandlink.ResourceModel;
import org.vivoweb.webapp.createandlink.utils.HttpReader;
import org.vivoweb.webapp.createandlink.utils.StringArrayDeserializer;

public class PubMedCreateAndLinkResourceProvider
implements CreateAndLinkResourceProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String PUBMED_ID_API = "http://www.ncbi.nlm.nih.gov/pmc/utils/idconv/v1.0/?format=json&ids=";
    public static final String PUBMED_SUMMARY_API = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=pubmed&retmode=json&tool=my_tool&email=my_email@example.com&id=";

    @Override
    public String normalize(String id) {
        return id.trim();
    }

    @Override
    public String getLabel() {
        return "PubMed ID";
    }

    @Override
    public ExternalIdentifiers allExternalIDsForFind(String externalId) {
        ExternalIdentifiers ids = new ExternalIdentifiers();
        ids.PubMedID = externalId;
        String json = this.readUrl(PUBMED_ID_API + externalId);
        if (!StringUtils.isEmpty((CharSequence)json)) {
            PubMedIDResponse response = null;
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                response = (PubMedIDResponse)objectMapper.readValue(json, PubMedIDResponse.class);
            }
            catch (IOException e) {
                this.logger.error((Object)"Unable to read JSON", (Throwable)e);
            }
            if (response != null && !ArrayUtils.isEmpty((Object[])response.records)) {
                ids.DOI = response.records[0].doi;
                ids.PubMedCentralID = response.records[0].pmcid;
            }
        }
        return ids;
    }

    @Override
    public String findInExternal(String id, Citation citation) {
        try {
            String json = this.readUrl(PUBMED_SUMMARY_API + id);
            if (StringUtils.isEmpty((CharSequence)json)) {
                return null;
            }
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser(json);
            if (parser != null) {
                while (!parser.isClosed() && !id.equals(parser.getCurrentName())) {
                    JsonToken jsonToken = parser.nextToken();
                }
                if (!parser.isClosed()) {
                    JsonToken token = parser.nextToken();
                    ObjectMapper objectMapper = new ObjectMapper();
                    objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    PubMedSummaryResponse response = (PubMedSummaryResponse)objectMapper.readValue(parser, PubMedSummaryResponse.class);
                    if (response != null) {
                        citation.title = response.title;
                        citation.authors = new Citation.Name[response.authors.length];
                        for (int idx = 0; idx < response.authors.length; ++idx) {
                            citation.authors[idx] = new Citation.Name();
                            citation.authors[idx].name = this.normalizeAuthorName(response.authors[idx].name);
                        }
                        citation.journal = response.fulljournalname;
                        citation.volume = response.volume;
                        citation.issue = response.issue;
                        citation.pagination = response.pages;
                        if (!StringUtils.isEmpty((CharSequence)response.pubdate) && response.pubdate.length() >= 4) {
                            citation.publicationYear = Integer.parseInt(response.pubdate.substring(0, 4), 10);
                        }
                        citation.type = this.getCiteprocTypeForPubType(response.pubtype);
                        return json;
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error((Object)("[PMID] Error resolving PMID " + id + ", cause " + e.getMessage()));
            return null;
        }
    }

    @Override
    public ResourceModel makeResourceModel(String externalId, String externalResource) {
        try {
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser(externalResource);
            if (parser != null) {
                while (!parser.isClosed() && !externalId.equals(parser.getCurrentName())) {
                    JsonToken jsonToken = parser.nextToken();
                }
                if (!parser.isClosed()) {
                    JsonToken token = parser.nextToken();
                    ObjectMapper objectMapper = new ObjectMapper();
                    objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    PubMedSummaryResponse response = (PubMedSummaryResponse)objectMapper.readValue(parser, PubMedSummaryResponse.class);
                    if (response != null) {
                        ResourceModel resourceModel = new ResourceModel();
                        resourceModel.PubMedID = externalId;
                        resourceModel.title = response.title;
                        resourceModel.author = new ResourceModel.NameField[response.authors.length];
                        for (int idx = 0; idx < response.authors.length; ++idx) {
                            resourceModel.author[idx] = new ResourceModel.NameField();
                            if (response.authors[idx].name.lastIndexOf(32) > 0) {
                                resourceModel.author[idx].family = response.authors[idx].name.substring(0, response.authors[idx].name.lastIndexOf(32));
                                resourceModel.author[idx].given = response.authors[idx].name.substring(response.authors[idx].name.lastIndexOf(32) + 1);
                                continue;
                            }
                            resourceModel.author[idx].family = response.authors[idx].name;
                        }
                        resourceModel.containerTitle = response.fulljournalname;
                        if (!StringUtils.isEmpty((CharSequence)response.issn)) {
                            resourceModel.ISSN = new String[1];
                            resourceModel.ISSN[0] = response.issn;
                        } else if (!StringUtils.isEmpty((CharSequence)response.eissn)) {
                            resourceModel.ISSN = new String[1];
                            resourceModel.ISSN[0] = response.eissn;
                        }
                        resourceModel.volume = response.volume;
                        resourceModel.issue = response.issue;
                        if (response.pages.contains("-")) {
                            int hyphen = response.pages.indexOf(45);
                            resourceModel.pageStart = response.pages.substring(0, hyphen);
                            resourceModel.pageEnd = response.pages.substring(hyphen + 1);
                        } else {
                            resourceModel.pageStart = response.pages;
                        }
                        if (!StringUtils.isEmpty((CharSequence)response.pubdate) && response.pubdate.length() >= 4) {
                            resourceModel.publicationDate = new ResourceModel.DateField();
                            resourceModel.publicationDate.year = Integer.parseInt(response.pubdate.substring(0, 4), 10);
                        }
                        if (response.articleids != null) {
                            for (PubMedSummaryResponse.ArticleID articleID : response.articleids) {
                                String id;
                                if (StringUtils.isEmpty((CharSequence)articleID.value)) continue;
                                if ("doi".equalsIgnoreCase(articleID.idtype)) {
                                    resourceModel.DOI = articleID.value.trim();
                                    continue;
                                }
                                if ("pmc".equalsIgnoreCase(articleID.idtype)) {
                                    resourceModel.PubMedCentralID = articleID.value.trim();
                                    continue;
                                }
                                if (!"pmcid".equalsIgnoreCase(articleID.idtype) || !StringUtils.isEmpty((CharSequence)resourceModel.PubMedCentralID) || StringUtils.isEmpty((CharSequence)(id = articleID.value.replaceAll(".*(PMC[0-9]+).*", "$1")))) continue;
                                resourceModel.PubMedCentralID = id;
                            }
                        }
                        resourceModel.type = this.getCiteprocTypeForPubType(response.pubtype);
                        resourceModel.publisher = response.publishername;
                        resourceModel.status = response.pubstatus;
                        return resourceModel;
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Unable to read JSON", (Throwable)e);
        }
        return null;
    }

    private String normalizeAuthorName(String name) {
        if (name.indexOf(44) < 0 && name.indexOf(32) > -1) {
            int lastSpace;
            int insertPoint;
            for (insertPoint = lastSpace = name.lastIndexOf(32); insertPoint > 0 && name.charAt(insertPoint - 1) == ' '; --insertPoint) {
            }
            return name.substring(0, insertPoint) + "," + name.substring(lastSpace);
        }
        return name;
    }

    private String getCiteprocTypeForPubType(String[] pubTypes) {
        if (pubTypes != null && pubTypes.length > 0) {
            String[] stringArray = pubTypes;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String pubType;
                switch (pubType = stringArray[i]) {
                    case "Journal Article": {
                        return "article-journal";
                    }
                    case "Incunabula": 
                    case "Monograph": 
                    case "Textbooks": {
                        return "book";
                    }
                    case "Dataset": {
                        return "dataset";
                    }
                    case "Legal Cases": {
                        return "legal_case";
                    }
                    case "Legislation": {
                        return "legislation";
                    }
                    case "Manuscripts": {
                        return "manuscript";
                    }
                    case "Maps": {
                        return "map";
                    }
                    case "Meeting Abstracts": {
                        return "paper-conference";
                    }
                    case "Patents": {
                        return "patent";
                    }
                    case "Letter": {
                        return "personal_communication";
                    }
                    case "Blogs": {
                        return "post-weblog";
                    }
                    case "Review": {
                        return "review";
                    }
                    case "Academic Dissertations": {
                        return "thesis";
                    }
                }
            }
        }
        return "article-journal";
    }

    private String readUrl(String url) {
        try {
            HttpClient client = HttpClientFactory.getHttpClient();
            HttpGet request = new HttpGet(url);
            HttpResponse response = client.execute((HttpUriRequest)request);
            return HttpReader.fromResponse(response);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static class PubMedSummaryResponse {
        public String uid;
        public String pubdate;
        public String source;
        public NameField[] authors;
        public String title;
        public String volume;
        public String issue;
        public String pages;
        @JsonDeserialize(using=StringArrayDeserializer.class)
        public String[] lang;
        public String issn;
        public String eissn;
        @JsonDeserialize(using=StringArrayDeserializer.class)
        public String[] pubtype;
        public String pubstatus;
        public ArticleID[] articleids;
        public History[] history;
        @JsonDeserialize(using=StringArrayDeserializer.class)
        public String[] attributes;
        public String fulljournalname;
        public String publishername;
        public String chapter;

        private PubMedSummaryResponse() {
        }

        public static class History {
            public String pubstatus;
            public String date;
        }

        public static class ArticleID {
            public String idtype;
            public String value;
        }

        public static class NameField {
            public String name;
        }
    }

    private static class PubMedIDResponse {
        public String status;
        public String responseDate;
        public String request;
        public String warning;
        public PubMedIDRecord[] records;

        private PubMedIDResponse() {
        }

        public static class PubMedIDRecord {
            String pmcid;
            String pmid;
            String doi;
        }
    }
}

