/*
 * Decompiled with CFR 0.152.
 */
package org.vivoweb.webapp.util;

import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModelUtils {
    private static final Log log = LogFactory.getLog((String)ModelUtils.class.getName());
    private static final String processPropertyURI = "http://purl.obolibrary.org/obo/BFO_0000054";
    private static final String processPropertyInverseURI = "http://purl.obolibrary.org/obo/BFO_0000055";
    private static final String nonProcessPropertyURI = "http://vivoweb.org/ontology/core#roleContributesTo";
    private static final String nonProcessPropertyInverseURI = "http://vivoweb.org/ontology/core#contributingRole";
    private static final String grantPropertyURI = "http://vivoweb.org/ontology/core#relatedBy";
    private static final String grantPropertyInverseURI = "http://vivoweb.org/ontology/core#relates";
    private static Set<String> processClass = new HashSet<String>();
    private static Set<String> grantClass;

    public static ObjectProperty getPropertyForRoleInClass(String classURI, WebappDaoFactory wadf) {
        if (classURI == null) {
            log.error((Object)"input classURI is null");
            return null;
        }
        if (wadf == null) {
            log.error((Object)"input WebappDaoFactory is null");
            return null;
        }
        VClassDao vcd = wadf.getVClassDao();
        List superClassURIs = vcd.getSuperClassURIs(classURI, false);
        superClassURIs.add(classURI);
        Iterator iter = superClassURIs.iterator();
        ObjectProperty op = new ObjectProperty();
        boolean isBFOProcess = false;
        boolean isGrantClass = false;
        while (iter.hasNext()) {
            String superClassURI = (String)iter.next();
            if (processClass.contains(superClassURI)) {
                isBFOProcess = true;
                break;
            }
            if (!grantClass.contains(superClassURI)) continue;
            isGrantClass = true;
            break;
        }
        if (isBFOProcess) {
            op.setURI(processPropertyURI);
            op.setURIInverse(processPropertyInverseURI);
        } else if (isGrantClass) {
            op.setURI(grantPropertyURI);
            op.setURIInverse(grantPropertyInverseURI);
        } else {
            op.setURI(nonProcessPropertyURI);
            op.setURIInverse(nonProcessPropertyInverseURI);
        }
        return op;
    }

    public static List<String> getPossiblePropertiesForRole() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(processPropertyURI);
        properties.add(nonProcessPropertyURI);
        properties.add(grantPropertyURI);
        return properties;
    }

    public static List<String> getPossibleInversePropertiesForRole() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(processPropertyInverseURI);
        properties.add(nonProcessPropertyInverseURI);
        properties.add(grantPropertyInverseURI);
        return properties;
    }

    static {
        processClass.add("http://vivoweb.org/ontology/core#Project");
        processClass.add("http://purl.org/NET/c4dm/event.owl#Event");
        processClass.add("http://vivoweb.org/ontology/core#EventSeries");
        grantClass = new HashSet<String>();
        grantClass.add("http://vivoweb.org/ontology/core#Grant");
    }
}

