/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.FirstAndLastNameValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import edu.cornell.mannlib.vitro.webapp.utils.generators.EditModeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jena.vocabulary.XSD;

public class ProjectHasParticipantGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String n3ForNewProjectRole = "@prefix core: <http://vivoweb.org/ontology/core#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>  . \n?project <http://purl.obolibrary.org/obo/BFO_0000055>  ?projectRole .\n?projectRole  a <http://vivoweb.org/ontology/core#ResearcherRole> .\n?projectRole <http://purl.obolibrary.org/obo/BFO_0000054> ?project . \n?projectRole <http://www.w3.org/2000/01/rdf-schema#label> ?roleLabel . \n";
    static final String n3ForNewPerson = "?projectRole <http://purl.obolibrary.org/obo/RO_0000052> ?newPerson . \n?newPerson <http://purl.obolibrary.org/obo/RO_0000053> ?projectRole . \n?newPerson a <http://xmlns.com/foaf/0.1/Person> . \n?newPerson <http://www.w3.org/2000/01/rdf-schema#label> ?personLabel . ";
    static final String n3ForExistingPerson = "?projectRole <http://purl.obolibrary.org/obo/RO_0000052> ?existingPerson . \n?existingPerson <http://purl.obolibrary.org/obo/RO_0000053> ?projectRole . \n ";
    static final String firstNameAssertion = "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newPerson <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?newPerson . \n?vcardPerson a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardPerson vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:givenName ?firstName .";
    static final String lastNameAssertion = "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newPerson <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?newPerson . \n?vcardPerson a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardPerson vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:familyName ?lastName .";
    static final String roleLabelQuery = "SELECT ?roleLabel WHERE {\n?projectRole <http://www.w3.org/2000/01/rdf-schema#label> ?roleLabel }\n";
    static final String existingPersonQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>   \nSELECT ?existingPerson WHERE {\n?projectRole <http://purl.obolibrary.org/obo/RO_0000052> ?existingPerson . \n?existingPerson <http://purl.obolibrary.org/obo/RO_0000053> ?projectRole . \n?existingPerson a <http://xmlns.com/foaf/0.1/Person> . \n  }";
    static final String personLabelQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>   \nSELECT ?existingPersonLabel WHERE {\n?projectRole <http://purl.obolibrary.org/obo/RO_0000052> ?existingPerson . \n?existingPerson <http://purl.obolibrary.org/obo/RO_0000053> ?projectRole .\n?existingPerson <http://www.w3.org/2000/01/rdf-schema#label> ?existingPersonLabel .\n?existingPerson a <http://xmlns.com/foaf/0.1/Person> . \n  }";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate("projectHasParticipant.ftl");
        conf.setVarNameForSubject("project");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("projectRole");
        conf.setN3Required(Arrays.asList(n3ForNewProjectRole));
        conf.setN3Optional(Arrays.asList(n3ForNewPerson, n3ForExistingPerson, firstNameAssertion, lastNameAssertion));
        conf.addNewResource("projectRole", "");
        conf.addNewResource("newPerson", "");
        conf.addNewResource("vcardPerson", "");
        conf.addNewResource("vcardName", "");
        conf.setUrisOnform(Arrays.asList("existingPerson"));
        conf.setLiteralsOnForm(Arrays.asList("personLabel", "personLabelDisplay", "roleLabel", "roleLabeldisplay", "firstName", "lastName"));
        conf.addSparqlForExistingLiteral("personLabel", personLabelQuery);
        conf.addSparqlForExistingLiteral("roleLabel", roleLabelQuery);
        conf.addSparqlForExistingUris("existingPerson", existingPersonQuery);
        conf.addField(new FieldVTwo().setName("existingPerson"));
        conf.addField(new FieldVTwo().setName("personLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(ProjectHasParticipantGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("roleLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(ProjectHasParticipantGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString(), "nonempty"})));
        conf.addField(new FieldVTwo().setName("personLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()));
        conf.addField(new FieldVTwo().setName("roleLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()));
        conf.addField(new FieldVTwo().setName("firstName").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(ProjectHasParticipantGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("lastName").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(ProjectHasParticipantGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        conf.addValidator((N3ValidatorVTwo)new FirstAndLastNameValidator("existingPerson", I18n.bundle((HttpServletRequest)vreq)));
        this.addFormSpecificData(conf, vreq);
        this.prepare(vreq, conf);
        return conf;
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, String> formSpecificData = new HashMap<String, String>();
        formSpecificData.put("editMode", this.getEditMode(vreq).name().toLowerCase());
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq) {
        ArrayList<String> predicates = new ArrayList<String>();
        predicates.add("http://purl.obolibrary.org/obo/RO_0000053");
        return EditModeUtils.getEditMode((VitroRequest)vreq, predicates);
    }
}

