/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.valueobjects;

import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Activity;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Individual;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UniqueIDGenerator;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Collaborator
extends Individual {
    private int collaboratorID;
    private Map<String, Integer> yearToActivityCount;
    private Set<Activity> activities = new HashSet<Activity>();

    public Collaborator(String collaboratorURI, UniqueIDGenerator uniqueIDGenerator) {
        super(collaboratorURI);
        this.collaboratorID = uniqueIDGenerator.getNextNumericID();
    }

    public int getCollaboratorID() {
        return this.collaboratorID;
    }

    public String getCollaboratorURI() {
        return this.getIndividualURI();
    }

    public String getCollaboratorName() {
        return this.getIndividualLabel();
    }

    public void setCollaboratorName(String collaboratorName) {
        this.setIndividualLabel(collaboratorName);
    }

    public Set<Activity> getCollaboratorActivities() {
        return this.activities;
    }

    public int getNumOfActivities() {
        return this.activities.size();
    }

    public void addActivity(Activity activity) {
        this.activities.add(activity);
    }

    public Map<String, Integer> getYearToActivityCount() {
        if (this.yearToActivityCount == null) {
            this.yearToActivityCount = UtilityFunctions.getYearToActivityCount(this.activities);
        }
        return this.yearToActivityCount;
    }

    public Map<String, Integer> getEarliestActivityYearCount() {
        HashSet<String> yearsToBeConsidered = new HashSet<String>(this.getYearToActivityCount().keySet());
        yearsToBeConsidered.remove("Unknown");
        if (yearsToBeConsidered.size() > 0) {
            final String earliestYear = Collections.min(yearsToBeConsidered);
            final Integer earliestYearActivityCount = this.getYearToActivityCount().get(earliestYear);
            return new HashMap<String, Integer>(){
                {
                    this.put(earliestYear, earliestYearActivityCount);
                }
            };
        }
        return null;
    }

    public Map<String, Integer> getLatestActivityYearCount() {
        HashSet<String> yearsToBeConsidered = new HashSet<String>(this.getYearToActivityCount().keySet());
        yearsToBeConsidered.remove("Unknown");
        if (yearsToBeConsidered.size() > 0) {
            final String latestYear = Collections.max(yearsToBeConsidered);
            final Integer latestYearActivityCount = this.getYearToActivityCount().get(latestYear);
            return new HashMap<String, Integer>(){
                {
                    this.put(latestYear, latestYearActivityCount);
                }
            };
        }
        return null;
    }

    public Integer getUnknownActivityYearCount() {
        Integer unknownYearActivityCount = this.getYearToActivityCount().get("Unknown");
        if (unknownYearActivityCount != null) {
            return unknownYearActivityCount;
        }
        return null;
    }
}

