/* $This file is distributed under the terms of the license in LICENSE$ */

package edu.cornell.mannlib.vitro.webapp.visualization.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * This contains the constants related to map of science visualization.
 * @author cdtank
 */
@SuppressWarnings("serial")
public class MapOfScienceConstants {

	public static final Map<Integer, String> DISCIPLINE_ID_TO_LABEL = new HashMap<Integer, String>() {{
		put(1, "Health Professionals");
		put(2, "Chemistry");
		put(3, "Social Sciences");
		put(4, "Humanities");
		put(5, "Brain Research");
		put(6, "Medical Specialties");
		put(7, "Infectious Diseases");
		put(8, "Biotechnology");
		put(9, "Biology");
		put(10, "Earth Sciences");
		put(11, "Chemical, Mechanical, & Civil Engineering");
		put(12, "Math & Physics");
		put(13, "Electrical Engineering & Computer Science");
	}};


	public static final Map<Integer, String> SUB_DISCIPLINE_ID_TO_LABEL = new HashMap<Integer, String>() {{
		put(1, "Clinical Cancer Research");
		put(2, "Circulation");
		put(3, "Data Mining");
		put(4, "Protein Science");
		put(5, "Signal Processing");
		put(6, "Neuroscience; Molecular & Cellular");
		put(7, "Anesthetics & Analgesics");
		put(8, "Urology");
		put(9, "Immunology");
		put(10, "Macromolecules & Polymers");
		put(11, "Affective Disorders");
		put(12, "Oncology");
		put(13, "Surface Science");
		put(14, "Nonlinear Analysis");
		put(15, "Hospital Financial Management");
		put(16, "Rheumatology");
		put(17, "Occupational Health");
		put(18, "Organic Chemistry");
		put(19, "Leukemia");
		put(20, "Virology");
		put(21, "Plant Physiology");
		put(22, "Allergy & Clinical Immunology");
		put(23, "Material Science");
		put(24, "Dermatology");
		put(25, "Kidney");
		put(26, "Pharmacology Science");
		put(27, "Law");
		put(28, "Medical Imaging");
		put(29, "Bacteriology");
		put(30, "Marine Biology");
		put(31, "Developmental Biology");
		put(32, "Digestion");
		put(33, "Toxicology Applied Pharmacology");
		put(34, "Transportation Research");
		put(35, "Inorganic Chemistry");
		put(36, "Chemical Engineering");
		put(37, "Pharmaceutical Research");
		put(38, "Semiconducting Materials");
		put(39, "Diabetes Care");
		put(40, "Clinical Neurophysiology");
		put(41, "Opthomology");
		put(42, "Nutrition");
		put(43, "Finance");
		put(44, "Neurosurgery");
		put(45, "Fertility");
		put(46, "Applied Optics");
		put(47, "Nuclear Engineering");
		put(48, "Molecular Cell Biology");
		put(49, "Food Chemistry");
		put(50, "Obstectrics");
		put(51, "Chest & Respiratory");
		put(52, "Earthquake Engineering");
		put(53, "Zoology");
		put(54, "Pharmaceutical Design");
		put(55, "AntiMicrobial Agents");
		put(56, "Systems Software");
		put(57, "Decision Support Systems");
		put(58, "Business Ethics");
		put(59, "Vascular Surgery");
		put(60, "Pulp & Paper");
		put(61, "Seismology");
		put(62, "Bone Joint Surgery");
		put(63, "Neurology");
		put(64, "Algebra");
		put(65, "Antenna");
		put(66, "Circuit Systems");
		put(67, "Nursing Specialists");
		put(68, "Retinal Surgery");
		put(69, "Psychopharmacology");
		put(70, "Aeronautics & Astronautics");
		put(71, "Psychoanalysis");
		put(72, "Oceanography");
		put(73, "Sports Medicine");
		put(74, "Operations Research");
		put(75, "Chromatography; Electrophoresis");
		put(76, "Pediatrics");
		put(77, "Cardiovascular");
		put(78, "Paleobiology");
		put(79, "Economics");
		put(80, "Hypertension");
		put(81, "Human Molecular Genetics");
		put(82, "Clinical Endocrinology");
		put(83, "Dietetics");
		put(84, "Clinical Microbiology");
		put(85, "Hospital Pharmacy");
		put(86, "Gas Turbines");
		put(87, "Remote Sensing");
		put(88, "Computational Chemistry");
		put(89, "Surgery");
		put(90, "Ceramics");
		put(91, "AIDS");
		put(92, "Military Aviation");
		put(93, "Medical Records");
		put(94, "Statistics");
		put(95, "Applied Economics");
		put(96, "Automatic Control");
		put(97, "Atmospheric Science");
		put(98, "Automotive Engineering");
		put(99, "BioStatistics");
		put(100, "Employee Health Benefit Plans");
		put(101, "Transplantation");
		put(102, "Alloys");
		put(103, "Astronomy & Astrophysics");
		put(104, "Substance-abuse Treatment");
		put(105, "Research Policy; Technology Management");
		put(106, "Drug Discovery");
		put(107, "Animal Science");
		put(108, "Chaos Fractals & Complexity");
		put(109, "Environmental Contamination");
		put(110, "Otolaryngology; Laryngoscope");
		put(111, "Mechanical Design Engineering");
		put(112, "Classics");
		put(113, "Biological Conservation");
		put(114, "Thoracic Surgery");
		put(115, "Phytochemistry");
		put(116, "Tropical Medicine");
		put(117, "Food Protection");
		put(118, "Broadband Communication");
		put(119, "Energy Fuel");
		put(120, "Soil Quality");
		put(121, "Integrated Circuit Design");
		put(122, "Philosophy Psychology");
		put(123, "Construction & Project Management");
		put(124, "Social Psychology");
		put(125, "High Energy Physics");
		put(126, "Strategic Management");
		put(127, "Genomics & Nucleic Acids");
		put(128, "Heat Transfer");
		put(129, "Cement & Concrete");
		put(130, "Pathology");
		put(131, "Pest Management Science");
		put(132, "Corrosion");
		put(133, "Veterinary Science");
		put(134, "Teacher Education; Evaluation");
		put(135, "Stem Cells");
		put(136, "Image Processing");
		put(137, "Neural Networks");
		put(138, "Nursing Education");
		put(139, "Intensive Care");
		put(140, "Alternative Complementary Medicine");
		put(141, "Petroleum Engineering");
		put(142, "Music & Theatre");
		put(143, "Memory & Cognition");
		put(144, "Vision");
		put(145, "Communication Research");
		put(146, "BioInformatics");
		put(147, "Mechanics of Solids & Structures");
		put(148, "Pharmacy");
		put(149, "Geomorphology");
		put(150, "Psychosis; Schizophrenia");
		put(151, "BioEthics");
		put(152, "Parellel Computing");
		put(153, "Power Distribution");
		put(154, "Gerontology");
		put(155, "Wood");
		put(156, "Discrete Applied Mathematics");
		put(157, "Geology & Tectonics");
		put(158, "GeoChemistry");
		put(159, "Mobil Networks");
		put(160, "Artificial Intelligence");
		put(161, "Electro Analytical Chemistry");
		put(162, "Dental Education");
		put(163, "Enzyme Microbiological Techniques");
		put(164, "Library Science; Infomation Retrieval");
		put(165, "Biomaterials");
		put(166, "Quaternary Research");
		put(167, "Endoscopy");
		put(168, "Composites");
		put(169, "Language Learning");
		put(170, "History; Gender Studies");
		put(171, "Leadership & Organizational Behavior");
		put(172, "Agricultural Engineering");
		put(173, "Computer-Aided Process Planning");
		put(174, "Geriatrics");
		put(175, "Solid State Electronics");
		put(176, "Optics & Lasers");
		put(177, "Wool");
		put(178, "Biomechanics");
		put(179, "Molecular Physics");
		put(180, "Comparative Animal Physiology");
		put(181, "Political Science");
		put(182, "History Philosophy");
		put(183, "Poetry");
		put(184, "Nuclear Medicine");
		put(185, "Nanotechnology");
		put(186, "Speech Recognitation");
		put(187, "Fluid Mechanics");
		put(188, "Computer Graphics");
		put(189, "Filtration Membrane");
		put(190, "Clinical Infectious Disease");
		put(191, "Prosthetic Dentistry");
		put(192, "Orthodontics");
		put(193, "Robotic Systems");
		put(194, "Dental Research");
		put(195, "Atomic Spectrometry");
		put(196, "Botany");
		put(197, "Public Health Service");
		put(198, "Political Geography");
		put(199, "Catalysis");
		put(200, "Radiation Protection");
		put(201, "Machine Tools");
		put(202, "Veterinary Medicine");
		put(203, "Periodontology");
		put(204, "Birth Defects");
		put(205, "Thrombosis");
		put(206, "Freshwater Biology");
		put(207, "Mental Health Nursing");
		put(208, "Artificial Evolution");
		put(209, "English Literature");
		put(210, "Plastic Surgery");
		put(211, "Nursing Administration");
		put(212, "Higher Education");
		put(213, "Ecology");
		put(214, "Modern Language");
		put(215, "Neurophsyiology & Neuroscience");
		put(216, "Mining");
		put(217, "Aquaculture");
		put(218, "Molecular Biological Evolution");
		put(219, "Photonics");
		put(220, "Urban Studies");
		put(221, "Functional Analysis");
		put(222, "Linguistics");
		put(223, "Photo-Optics");
		put(224, "Spine");
		put(225, "Robotics");
		put(226, "Audiology");
		put(227, "Soil Science");
		put(228, "Simulation");
		put(229, "Nuclear Instrumentation");
		put(230, "Hispanic Studies");
		put(231, "Forest Science");
		put(232, "Plasma Physics");
		put(233, "Proteomics");
		put(234, "Symbolic Interaction");
		put(235, "Child & Adolescent Psychiatry");
		put(236, "General Practice");
		put(237, "Environmental Management");
		put(238, "Diabetes Metabolism");
		put(239, "Geotechnical Engineering");
		put(240, "Instrumentation");
		put(241, "Clinical Chemistry");
		put(242, "Fluid Engineering");
		put(243, "Arthroscopy");
		put(244, "Eating Disorders; Sex Roles");
		put(245, "Water Quality & Resource Management");
		put(246, "Ethnic Migration");
		put(247, "Geriatric Psychiatry");
		put(248, "Sound & Vibration");
		put(249, "Ore Processing");
		put(250, "Ethnology");
		put(251, "Prenatal Diagnostics");
		put(252, "Cancer (translated)");
		put(253, "Dialectics");
		put(254, "Atmospheric GeoPhysics");
		put(255, "Flavors & Fragrance");
		put(256, "Numerical Methods in Engineering");
		put(257, "EthnoPharmcology");
		put(258, "Electrocardiography");
		put(259, "International Development");
		put(260, "Electrochemistry");
		put(261, "Political Studies");
		put(262, "Molecular Endocrinology");
		put(263, "Surface Coating Technology");
		put(264, "Molecular Biochemical Parasitology");
		put(265, "Vocational Counseling");
		put(266, "Oil & Natural Gas");
		put(267, "International Conflict");
		put(268, "Art History");
		put(269, "Applied Catalysis");
		put(270, "Agricultural Economics");
		put(271, "Social Work");
		put(272, "Medical Insurance");
		put(273, "Fluid Phase Equilibrium");
		put(274, "Biotechnology Trends");
		put(275, "Air Quality");
		put(276, "Search Engines; Web Crawling");
		put(277, "Colloid");
		put(278, "Applied Physiology; Muscle");
		put(279, "Biblical Literature");
		put(280, "Fault Tolerant Computing");
		put(281, "Third World Political Economics");
		put(282, "Public Hospitals");
		put(283, "Sociology");
		put(284, "Horticulture");
		put(285, "Bone & Osteoporosis");
		put(286, "Radiation Therapy");
		put(287, "Water Treatment");
		put(288, "Spyware; Malware");
		put(289, "Behavioral Research Therapy");
		put(290, "Science Education");
		put(291, "Design & Analysis of Algorithms");
		put(292, "Hospice Care");
		put(293, "Climatology");
		put(294, "Crop Science");
		put(295, "Fuzzy Sets");
		put(296, "Vehicle System Design");
		put(297, "Transfusion");
		put(298, "AIDS Treatment");
		put(299, "Wireless Communication");
		put(300, "Atherosclerosis");
		put(301, "Region & Medical Ethics");
		put(302, "Speech Language & Hearing");
		put(303, "Thoracic & Respiratory");
		put(304, "Veterinary Microbiology");
		put(305, "Environmental Protection");
		put(306, "Computer Systems Design");
		put(307, "Environmental Polution");
		put(308, "Electrical Networks");
		put(309, "Endoscopy");
		put(310, "Chemistry & Material Science");
		put(311, "Medical Screening & Epidemiology");
		put(312, "Child Development");
		put(313, "Pain");
		put(314, "Public Administration");
		put(315, "Soil Analysis");
		put(316, "Safety Management");
		put(317, "Pattern Recognition");
		put(318, "Mental Health Assessment");
		put(319, "Clinical Medicine (translated)");
		put(320, "Mutation; DNA Repair");
		put(321, "Human Evolution");
		put(322, "Space Research");
		put(323, "Entomology");
		put(324, "Epilepsy");
		put(325, "Plant Ecology");
		put(326, "Computer Aided Molecular Design");
		put(327, "Criminology");
		put(328, "Forensic Psychiatry");
		put(329, "Personality");
		put(330, "Test Equipment");
		put(331, "Logic");
		put(332, "Pulp Paper Science");
		put(333, "Textiles");
		put(334, "Contemporary Philosophy");
		put(335, "Hydrology Soil Contamination");
		put(336, "Child Abuse");
		put(337, "Mathematics Research");
		put(338, "Geology (International)");
		put(339, "Environmental Chemistry");
		put(340, "Parasitology");
		put(341, "Dairy Science");
		put(342, "Water Policy");
		put(343, "Fish Research");
		put(344, "Printing");
		put(345, "Genetics");
		put(346, "Industrial Chemistry");
		put(347, "Obesity");
		put(348, "Literary Criticism");
		put(349, "Hepatology");
		put(350, "Physical Therapy; Brain Injury");
		put(351, "Computational & Applied Math");
		put(352, "World Health Organization");
		put(353, "Geophysical Science");
		put(354, "Forensic Medicine");
		put(355, "Psychiatric Services");
		put(356, "Software Design and Development");
		put(357, "Wildlife Management");
		put(358, "Ocean Coastal Management");
		put(359, "Database Design & Management");
		put(360, "Financial Accounting");
		put(361, "Microbiology Biotechnology");
		put(362, "Water Utilities");
		put(363, "Sedimentary Geology");
		put(364, "Geodesy");
		put(365, "Surfactants");
		put(366, "Eye");
		put(367, "Addictive Behavior");
		put(368, "Naval Architecture");
		put(369, "Environmental Microbiology");
		put(370, "Electronic Imaging");
		put(371, "Functional Programing");
		put(372, "Applied Genetics");
		put(373, "Plant Disease");
		put(374, "Water Resource");
		put(375, "Developmental Economics");
		put(376, "Nuclear Physics");
		put(377, "International Economics");
		put(378, "Radiology");
		put(379, "German Studies");
		put(380, "Medieval History");
		put(381, "Philosophy of Education");
		put(382, "Oceanographic Instrumentation");
		put(383, "Foreign Policy");
		put(384, "Gut");
		put(385, "Microwaves; Radio Frequencies");
		put(386, "School Psychology");
		put(387, "Vaccines");
		put(388, "Environmental Law");
		put(389, "Mass Spectrometry");
		put(390, "Psychiatric Nursing");
		put(391, "Asian Studies");
		put(392, "Optimization Theory");
		put(393, "Mathematical Science (Russia)");
		put(394, "Gene Therapy");
		put(395, "Security; Cryptography");
		put(396, "Materials Processing");
		put(397, "Rural Health Care");
		put(398, "Power Systems");
		put(399, "Surgical Oncology");
		put(400, "Chip Design & Manufacturing");
		put(401, "Sociobiology");
		put(402, "Molecular Medicine");
		put(403, "Human Resource Management");
		put(404, "Ecological Modeling");
		put(405, "Clinical Rehabilitation");
		put(406, "Metallurgy");
		put(407, "Ethics");
		put(408, "Marital & Family Therapy");
		put(409, "Aerospace");
		put(410, "Critical Studies");
		put(411, "Econometrics");
		put(412, "Neuroscience Methods");
		put(413, "Mineralogy");
		put(414, "Trauma");
		put(415, "Thermal Analysis");
		put(416, "Solar & Wind Power");
		put(417, "Ocean Engineering");
		put(418, "Educational Psychology");
		put(419, "Mycology");
		put(420, "Semiotics");
		put(421, "Dyes & Pigments");
		put(422, "Drug Safety");
		put(423, "Molecular Ecology");
		put(424, "Cytogentics & Genome Mapping");
		put(425, "Clinical Psychiatry");
		put(426, "Paleogeography");
		put(427, "Water Waste");
		put(428, "Computer Networks");
		put(429, "Weed Management");
		put(430, "User Interface Design");
		put(431, "Public Policy");
		put(432, "Liquid Crystals");
		put(433, "Control Systems");
		put(434, "Environmental Policy");
		put(435, "Topology");
		put(436, "Construction");
		put(437, "Dams & Tunnels");
		put(438, "Regional Studies");
		put(439, "Electrochemical Development");
		put(440, "Digital Printing");
		put(441, "Peptides");
		put(442, "Applied Geophysics");
		put(443, "Sexually Transmitted Diseases");
		put(444, "Engineering Education");
		put(445, "NeuroImmunology");
		put(446, "Machine Learning");
		put(447, "Geriatric Nursing");
		put(448, "Sensors & Actuators");
		put(449, "Systematics & Evolutionary Microbiology");
		put(450, "Image Processing");
		put(451, "Medical Education");
		put(452, "Magnetic Resonance Imagery");
		put(453, "Hospital Management");
		put(454, "Insect Physiology");
		put(455, "Power Transmission");
		put(456, "Food Engineering");
		put(457, "Oral Surgery");
		put(458, "Computer Systems Theory");
		put(459, "Combustion");
		put(460, "Dermatological Surgery");
		put(461, "Wildlife Research");
		put(462, "Midwifery");
		put(463, "Physics; Current Developments");
		put(464, "Psychiatric & Behavioral Genetics");
		put(465, "Fractures & Fatigue");
		put(466, "Emergency Medicine");
		put(467, "Cross Disciplinary Studies");
		put(468, "Archeological Science");
		put(469, "Preventive Medicine");
		put(470, "Carbon");
		put(471, "Gynecology Oncology");
		put(472, "Psychosomatic Medicine");
		put(473, "Pharmaco Economics");
		put(474, "Computer Modeling and Animation");
		put(475, "Medical Practice");
		put(476, "Cancer Statistics");
		put(477, "Consciousness");
		put(478, "Otolaryngology; Head Neck");
		put(479, "Heart Failure; Catheters");
		put(480, "Wood & Wood Components");
		put(481, "Circuits");
		put(482, "Friction Lubrication & Wear");
		put(483, "Superconductor Science");
		put(484, "Antennae; Mobile Radio");
		put(485, "Headache");
		put(486, "Operations Management");
		put(487, "Fish Biology");
		put(488, "Economic & Human Biology");
		put(489, "Consumer Electronics");
		put(490, "Menopause");
		put(491, "Chemistry (Russia)");
		put(492, "GeoPolitics");
		put(493, "Glaciology");
		put(494, "Medical Libraries");
		put(495, "Opera");
		put(496, "Education");
		put(497, "Acoustics");
		put(498, "Pragmatics & Discourse");
		put(499, "Reproduction Veterinary");
		put(500, "Crystallography");
		put(501, "Applied Math & Computation");
		put(502, "Socio-Cultural Anthropology");
		put(503, "Poultry Science");
		put(504, "Artifical Organs");
		put(505, "Physical Therapy; Orthopedic");
		put(506, "Pulmonary");
		put(507, "Waste Management");
		put(508, "Marine Pollution");
		put(509, "Toxins");
		put(510, "Hearing Research");
		put(511, "Human Rights");
		put(512, "Lung Cancer");
		put(513, "Social Economics");
		put(514, "Carbohydrate Research");
		put(515, "Biotechnology Bioengineering");
		put(516, "Rural Studies");
		put(517, "Electronics");
		put(518, "Defects & Diffusion in Materials");
		put(519, "Forensic Science");
		put(520, "Rangeland Ecology");
		put(521, "Welding");
		put(522, "Reliability Engineering");
		put(523, "Molecular Biology Methods");
		put(524, "Mammals");
		put(525, "Impotence");
		put(526, "Fuzzy Logic");
		put(527, "Tourism");
		put(528, "Aquatic Disease");
		put(529, "Geographic Information Science");
		put(530, "Hormone Research");
		put(531, "Public Health");
		put(532, "Sleep");
		put(533, "Neurotoxicology");
		put(534, "Pediatric Research");
		put(535, "Education Psychological Measures");
		put(536, "Marketing");
		put(537, "Clinical Medicine (Romania)");
		put(538, "Green Chemistry");
		put(539, "Optometry");
		put(540, "Textile Art");
		put(541, "Italian Studies");
		put(542, "Perception Motor Skills");
		put(543, "World Trade; Law");
		put(544, "Insects");
		put(545, "Australian Ecology");
		put(546, "Paints & Coatings");
		put(547, "Nursing Theory");
		put(548, "Crustaceans");
		put(549, "Laser Surgery");
		put(550, "Bulk Solid Handling");
		put(551, "Wetlands");
		put(552, "GIS (non English)");
		put(553, "Power Transmission & Control");
		put(554, "Agricultural Environmental Medicine");
	}};

	public static final Map<Integer, Integer> SUB_DISCIPLINE_ID_TO_DISCIPLINE_ID = new HashMap<Integer, Integer>() {{
		put(1, 7);
		put(2, 6);
		put(3, 13);
		put(4, 7);
		put(5, 13);
		put(6, 5);
		put(7, 6);
		put(8, 6);
		put(9, 7);
		put(10, 2);
		put(11, 1);
		put(12, 6);
		put(13, 12);
		put(14, 12);
		put(15, 1);
		put(16, 7);
		put(17, 1);
		put(18, 2);
		put(19, 7);
		put(20, 7);
		put(21, 9);
		put(22, 6);
		put(23, 11);
		put(24, 1);
		put(25, 6);
		put(26, 5);
		put(27, 3);
		put(28, 1);
		put(29, 7);
		put(30, 11);
		put(31, 7);
		put(32, 6);
		put(33, 1);
		put(34, 11);
		put(35, 2);
		put(36, 11);
		put(37, 1);
		put(38, 12);
		put(39, 6);
		put(40, 5);
		put(41, 1);
		put(42, 6);
		put(43, 3);
		put(44, 1);
		put(45, 6);
		put(46, 13);
		put(47, 11);
		put(48, 7);
		put(49, 8);
		put(50, 6);
		put(51, 6);
		put(52, 11);
		put(53, 9);
		put(54, 2);
		put(55, 6);
		put(56, 13);
		put(57, 3);
		put(58, 3);
		put(59, 6);
		put(60, 11);
		put(61, 10);
		put(62, 1);
		put(63, 5);
		put(64, 12);
		put(65, 13);
		put(66, 13);
		put(67, 1);
		put(68, 1);
		put(69, 5);
		put(70, 11);
		put(71, 1);
		put(72, 11);
		put(73, 1);
		put(74, 3);
		put(75, 2);
		put(76, 6);
		put(77, 6);
		put(78, 10);
		put(79, 3);
		put(80, 6);
		put(81, 7);
		put(82, 6);
		put(83, 6);
		put(84, 6);
		put(85, 6);
		put(86, 11);
		put(87, 11);
		put(88, 2);
		put(89, 6);
		put(90, 11);
		put(91, 6);
		put(92, 12);
		put(93, 1);
		put(94, 3);
		put(95, 3);
		put(96, 13);
		put(97, 11);
		put(98, 11);
		put(99, 3);
		put(100, 1);
		put(101, 6);
		put(102, 11);
		put(103, 12);
		put(104, 1);
		put(105, 3);
		put(106, 6);
		put(107, 6);
		put(108, 12);
		put(109, 11);
		put(110, 1);
		put(111, 11);
		put(112, 4);
		put(113, 9);
		put(114, 6);
		put(115, 2);
		put(116, 9);
		put(117, 8);
		put(118, 13);
		put(119, 11);
		put(120, 11);
		put(121, 13);
		put(122, 4);
		put(123, 3);
		put(124, 3);
		put(125, 12);
		put(126, 3);
		put(127, 8);
		put(128, 11);
		put(129, 11);
		put(130, 7);
		put(131, 9);
		put(132, 11);
		put(133, 6);
		put(134, 3);
		put(135, 6);
		put(136, 13);
		put(137, 13);
		put(138, 1);
		put(139, 6);
		put(140, 6);
		put(141, 11);
		put(142, 4);
		put(143, 5);
		put(144, 5);
		put(145, 3);
		put(146, 8);
		put(147, 11);
		put(148, 6);
		put(149, 10);
		put(150, 1);
		put(151, 1);
		put(152, 13);
		put(153, 13);
		put(154, 1);
		put(155, 11);
		put(156, 12);
		put(157, 10);
		put(158, 10);
		put(159, 13);
		put(160, 13);
		put(161, 2);
		put(162, 1);
		put(163, 8);
		put(164, 13);
		put(165, 1);
		put(166, 10);
		put(167, 6);
		put(168, 11);
		put(169, 3);
		put(170, 4);
		put(171, 3);
		put(172, 11);
		put(173, 3);
		put(174, 1);
		put(175, 12);
		put(176, 12);
		put(177, 11);
		put(178, 1);
		put(179, 2);
		put(180, 9);
		put(181, 3);
		put(182, 4);
		put(183, 4);
		put(184, 1);
		put(185, 12);
		put(186, 13);
		put(187, 11);
		put(188, 13);
		put(189, 11);
		put(190, 6);
		put(191, 1);
		put(192, 1);
		put(193, 13);
		put(194, 1);
		put(195, 2);
		put(196, 9);
		put(197, 1);
		put(198, 3);
		put(199, 2);
		put(200, 6);
		put(201, 11);
		put(202, 6);
		put(203, 1);
		put(204, 7);
		put(205, 6);
		put(206, 9);
		put(207, 1);
		put(208, 13);
		put(209, 4);
		put(210, 1);
		put(211, 1);
		put(212, 3);
		put(213, 9);
		put(214, 4);
		put(215, 5);
		put(216, 11);
		put(217, 9);
		put(218, 9);
		put(219, 13);
		put(220, 3);
		put(221, 12);
		put(222, 4);
		put(223, 11);
		put(224, 1);
		put(225, 13);
		put(226, 1);
		put(227, 11);
		put(228, 12);
		put(229, 12);
		put(230, 4);
		put(231, 9);
		put(232, 12);
		put(233, 8);
		put(234, 3);
		put(235, 3);
		put(236, 1);
		put(237, 3);
		put(238, 6);
		put(239, 11);
		put(240, 13);
		put(241, 6);
		put(242, 11);
		put(243, 1);
		put(244, 3);
		put(245, 11);
		put(246, 3);
		put(247, 1);
		put(248, 11);
		put(249, 11);
		put(250, 3);
		put(251, 6);
		put(252, 6);
		put(253, 13);
		put(254, 11);
		put(255, 2);
		put(256, 11);
		put(257, 2);
		put(258, 6);
		put(259, 3);
		put(260, 11);
		put(261, 3);
		put(262, 6);
		put(263, 12);
		put(264, 9);
		put(265, 3);
		put(266, 11);
		put(267, 3);
		put(268, 4);
		put(269, 2);
		put(270, 3);
		put(271, 3);
		put(272, 1);
		put(273, 11);
		put(274, 8);
		put(275, 11);
		put(276, 13);
		put(277, 2);
		put(278, 1);
		put(279, 4);
		put(280, 13);
		put(281, 3);
		put(282, 1);
		put(283, 3);
		put(284, 9);
		put(285, 6);
		put(286, 6);
		put(287, 11);
		put(288, 13);
		put(289, 1);
		put(290, 3);
		put(291, 12);
		put(292, 6);
		put(293, 11);
		put(294, 9);
		put(295, 13);
		put(296, 11);
		put(297, 7);
		put(298, 1);
		put(299, 13);
		put(300, 6);
		put(301, 1);
		put(302, 5);
		put(303, 6);
		put(304, 6);
		put(305, 11);
		put(306, 13);
		put(307, 11);
		put(308, 13);
		put(309, 6);
		put(310, 2);
		put(311, 6);
		put(312, 3);
		put(313, 6);
		put(314, 3);
		put(315, 11);
		put(316, 11);
		put(317, 13);
		put(318, 1);
		put(319, 6);
		put(320, 7);
		put(321, 9);
		put(322, 12);
		put(323, 9);
		put(324, 5);
		put(325, 9);
		put(326, 2);
		put(327, 3);
		put(328, 3);
		put(329, 3);
		put(330, 13);
		put(331, 13);
		put(332, 11);
		put(333, 11);
		put(334, 4);
		put(335, 11);
		put(336, 3);
		put(337, 12);
		put(338, 10);
		put(339, 2);
		put(340, 9);
		put(341, 6);
		put(342, 11);
		put(343, 11);
		put(344, 11);
		put(345, 9);
		put(346, 11);
		put(347, 6);
		put(348, 4);
		put(349, 6);
		put(350, 5);
		put(351, 12);
		put(352, 9);
		put(353, 12);
		put(354, 1);
		put(355, 1);
		put(356, 13);
		put(357, 9);
		put(358, 11);
		put(359, 13);
		put(360, 3);
		put(361, 8);
		put(362, 11);
		put(363, 10);
		put(364, 11);
		put(365, 2);
		put(366, 1);
		put(367, 1);
		put(368, 12);
		put(369, 11);
		put(370, 13);
		put(371, 13);
		put(372, 9);
		put(373, 9);
		put(374, 11);
		put(375, 3);
		put(376, 12);
		put(377, 3);
		put(378, 6);
		put(379, 4);
		put(380, 4);
		put(381, 4);
		put(382, 11);
		put(383, 3);
		put(384, 6);
		put(385, 13);
		put(386, 3);
		put(387, 7);
		put(388, 3);
		put(389, 8);
		put(390, 1);
		put(391, 4);
		put(392, 12);
		put(393, 12);
		put(394, 7);
		put(395, 13);
		put(396, 11);
		put(397, 1);
		put(398, 13);
		put(399, 6);
		put(400, 13);
		put(401, 9);
		put(402, 1);
		put(403, 3);
		put(404, 9);
		put(405, 6);
		put(406, 11);
		put(407, 4);
		put(408, 3);
		put(409, 12);
		put(410, 4);
		put(411, 3);
		put(412, 5);
		put(413, 10);
		put(414, 1);
		put(415, 2);
		put(416, 11);
		put(417, 11);
		put(418, 3);
		put(419, 9);
		put(420, 4);
		put(421, 11);
		put(422, 6);
		put(423, 9);
		put(424, 7);
		put(425, 1);
		put(426, 10);
		put(427, 11);
		put(428, 13);
		put(429, 11);
		put(430, 13);
		put(431, 3);
		put(432, 2);
		put(433, 13);
		put(434, 3);
		put(435, 12);
		put(436, 11);
		put(437, 11);
		put(438, 3);
		put(439, 11);
		put(440, 11);
		put(441, 7);
		put(442, 11);
		put(443, 6);
		put(444, 3);
		put(445, 5);
		put(446, 13);
		put(447, 1);
		put(448, 11);
		put(449, 8);
		put(450, 13);
		put(451, 1);
		put(452, 1);
		put(453, 1);
		put(454, 9);
		put(455, 13);
		put(456, 8);
		put(457, 1);
		put(458, 13);
		put(459, 11);
		put(460, 1);
		put(461, 9);
		put(462, 1);
		put(463, 12);
		put(464, 3);
		put(465, 11);
		put(466, 6);
		put(467, 4);
		put(468, 10);
		put(469, 1);
		put(470, 2);
		put(471, 6);
		put(472, 3);
		put(473, 1);
		put(474, 13);
		put(475, 1);
		put(476, 12);
		put(477, 5);
		put(478, 1);
		put(479, 6);
		put(480, 11);
		put(481, 13);
		put(482, 11);
		put(483, 12);
		put(484, 13);
		put(485, 5);
		put(486, 3);
		put(487, 9);
		put(488, 4);
		put(489, 13);
		put(490, 6);
		put(491, 2);
		put(492, 3);
		put(493, 11);
		put(494, 1);
		put(495, 4);
		put(496, 3);
		put(497, 11);
		put(498, 3);
		put(499, 6);
		put(500, 2);
		put(501, 12);
		put(502, 4);
		put(503, 6);
		put(504, 6);
		put(505, 1);
		put(506, 6);
		put(507, 11);
		put(508, 11);
		put(509, 2);
		put(510, 1);
		put(511, 3);
		put(512, 6);
		put(513, 3);
		put(514, 8);
		put(515, 8);
		put(516, 3);
		put(517, 13);
		put(518, 11);
		put(519, 1);
		put(520, 9);
		put(521, 11);
		put(522, 3);
		put(523, 7);
		put(524, 9);
		put(525, 6);
		put(526, 13);
		put(527, 3);
		put(528, 9);
		put(529, 11);
		put(530, 6);
		put(531, 6);
		put(532, 5);
		put(533, 5);
		put(534, 6);
		put(535, 3);
		put(536, 3);
		put(537, 6);
		put(538, 2);
		put(539, 1);
		put(540, 11);
		put(541, 4);
		put(542, 1);
		put(543, 3);
		put(544, 9);
		put(545, 9);
		put(546, 11);
		put(547, 1);
		put(548, 9);
		put(549, 1);
		put(550, 11);
		put(551, 9);
		put(552, 11);
		put(553, 13);
		put(554, 6);
	}};
}
