/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.semservices.service.impl;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.semservices.bo.Concept;
import edu.cornell.mannlib.semservices.exceptions.ConceptsNotFoundException;
import edu.cornell.mannlib.semservices.service.ExternalConceptService;
import edu.cornell.mannlib.vitro.webapp.utils.json.JacksonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpVersion;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.util.StringUtils;

public class UMLSService
implements ExternalConceptService {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static String UTS_REST_API_URL = "https://uts-ws.nlm.nih.gov/rest";
    private static String SEARCH_PATH = "/search/current";
    private static String SEARCH_PARAMETER = "string";
    private static String SEARCH_TYPE_PARAMETER = "searchType";
    private static String SEARCH_TYPE = "rightTruncation";
    private static String PAGE_SIZE_PARAMETER = "pageSize";
    private static String RETURN_TYPE_PARAMETER = "returnIdType";
    private static String RETURN_TYPE = "concept";
    private static String TICKET_PARAMETER = "ticket";
    private static String ticketGrantingTicketURL = null;
    private static long lastUpdate = -1L;
    private static String username = null;
    private static String password = null;
    private static String apikey = null;
    private static String pageSize = "50";
    private static String UMLS_AUTH_USER_URL = "https://utslogin.nlm.nih.gov/cas/v1/tickets";
    private static String UMLS_AUTH_KEY_URL = "https://utslogin.nlm.nih.gov/cas/v1/api-key";
    private static String UTS_SERVICE_URL = "http://umlsks.nlm.nih.gov";
    private static final String UMLS_PROPERTIES = "/umls.properties";
    private static final Log log = LogFactory.getLog(UMLSService.class);

    public UMLSService() {
        if (username == null || apikey == null) {
            Properties properties = new Properties();
            try (InputStream stream = this.getClass().getResourceAsStream(UMLS_PROPERTIES);){
                properties.load(stream);
                username = properties.getProperty("username");
                password = properties.getProperty("password");
                apikey = properties.getProperty("apikey");
                String exPageSize = properties.getProperty("pagesize");
                try {
                    int iPageSize;
                    if (!StringUtils.isEmpty((Object)exPageSize) && (iPageSize = Integer.parseInt(exPageSize, 10)) > 5 && iPageSize < 200) {
                        pageSize = Integer.toString(iPageSize, 10);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    public static boolean configurationFileExists() {
        URL config = UMLSService.class.getResource(UMLS_PROPERTIES);
        return config != null;
    }

    public boolean isConfigured() {
        return !StringUtils.isEmpty((Object)username) || !StringUtils.isEmpty((Object)apikey);
    }

    public List<Concept> getConcepts(String term) throws Exception {
        String ticket = this.getSingleUseTicket();
        ArrayList<Concept> conceptList = new ArrayList();
        String results = null;
        try {
            URIBuilder b = new URIBuilder(UTS_REST_API_URL + SEARCH_PATH);
            b.addParameter(SEARCH_PARAMETER, term);
            b.addParameter(RETURN_TYPE_PARAMETER, RETURN_TYPE);
            b.addParameter(SEARCH_TYPE_PARAMETER, SEARCH_TYPE);
            b.addParameter(PAGE_SIZE_PARAMETER, pageSize);
            b.addParameter(TICKET_PARAMETER, ticket);
            results = Request.Get((URI)b.build()).connectTimeout(3000).socketTimeout(3000).execute().returnContent().asString();
            conceptList = this.processOutput(results);
            return conceptList;
        }
        catch (Exception ex) {
            this.logger.error((Object)"error occurred in servlet", (Throwable)ex);
            return null;
        }
    }

    public List<Concept> processResults(String term) throws Exception {
        return this.getConcepts(term);
    }

    public List<Concept> getConceptsByURIWithSparql(String uri) throws Exception {
        ArrayList<Concept> conceptList = new ArrayList<Concept>();
        return conceptList;
    }

    private List<Concept> processOutput(String results) throws Exception {
        ArrayList<Concept> conceptList = new ArrayList<Concept>();
        ArrayList bestMatchIdList = new ArrayList();
        String bestMatchId = "";
        try {
            ObjectNode json = (ObjectNode)JacksonUtils.parseJson((String)results);
            ArrayNode allArray = (ArrayNode)json.get("result").get("results");
            int len = allArray.size();
            for (int i = 0; i < len; ++i) {
                ObjectNode o = (ObjectNode)allArray.get(i);
                Concept concept = new Concept();
                concept.setDefinedBy(UTS_SERVICE_URL);
                concept.setSchemeURI(UTS_SERVICE_URL);
                concept.setType(RETURN_TYPE);
                concept.setConceptId(this.getJsonValue(o, "ui"));
                concept.setLabel(this.getJsonValue(o, "name"));
                concept.setUri(this.getJsonValue(o, "uri"));
                concept.setBestMatch("false");
                conceptList.add(concept);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error((Object)"Could not get concepts", (Throwable)ex);
            throw ex;
        }
        if (conceptList.size() == 0) {
            throw new ConceptsNotFoundException();
        }
        return conceptList;
    }

    protected String getJsonValue(ObjectNode obj, String key) {
        if (obj.has(key)) {
            return obj.get(key).asText();
        }
        return "";
    }

    protected String stripConceptId(String uri) {
        String conceptId = "";
        int lastslash = uri.lastIndexOf(47);
        conceptId = uri.substring(lastslash + 1, uri.length());
        return conceptId;
    }

    private synchronized void getTicketGrantingTicket() {
        if (StringUtils.isEmpty((Object)username) && StringUtils.isEmpty((Object)apikey)) {
            throw new IllegalStateException("Unable to read umls.properties");
        }
        if (ticketGrantingTicketURL == null || lastUpdate + 28700000L < System.currentTimeMillis()) {
            try {
                ticketGrantingTicketURL = !StringUtils.isEmpty((Object)apikey) ? Request.Post((String)UMLS_AUTH_KEY_URL).useExpectContinue().version(HttpVersion.HTTP_1_1).bodyForm((Iterable)Form.form().add("apikey", apikey).build()).execute().returnResponse().getFirstHeader("location").getValue() : Request.Post((String)UMLS_AUTH_USER_URL).useExpectContinue().version(HttpVersion.HTTP_1_1).bodyForm((Iterable)Form.form().add("username", username).add("password", password).build()).execute().returnResponse().getFirstHeader("location").getValue();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to get ticket granting ticket.");
            }
            lastUpdate = System.currentTimeMillis();
        }
    }

    private String getSingleUseTicket() {
        this.getTicketGrantingTicket();
        String ticket = "";
        try {
            ticket = Request.Post((String)ticketGrantingTicketURL).useExpectContinue().version(HttpVersion.HTTP_1_1).bodyForm((Iterable)Form.form().add("service", UTS_SERVICE_URL).build()).execute().returnContent().asString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get ticket.");
        }
        return ticket;
    }
}

