/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.FirstAndLastNameValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeIntervalValidationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ChildVClassesWithParent;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jena.vocabulary.XSD;

public class OrganizationHasPositionHistoryGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    private static final String NS_VIVO_CORE = "http://vivoweb.org/ontology/core#";
    private static final String URI_PRECISION_NONE = VitroVocabulary.Precision.NONE.uri();
    private static final String URI_PRECISION_YEAR = VitroVocabulary.Precision.YEAR.uri();
    private static final String URI_POSITION_CLASS = "http://vivoweb.org/ontology/core#Position";
    private static final String QUERY_EXISTING_POSITION_TITLE = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT ?existingPositionTitle WHERE { \n  ?position rdfs:label ?existingPositionTitle . }";
    private static final String QUERY_EXISTING_POSITION_TYPE = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?existingPositionType WHERE { \n  ?position vitro:mostSpecificType ?existingPositionType . }";
    private static final String QUERY_EXISTING_PERSON = "PREFIX core: <http://vivoweb.org/ontology/core#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT ?existingPerson WHERE { \n  ?position core:relates ?existingPerson .}";
    private static final String QUERY_EXISTING_PERSON_LABEL = "PREFIX core: <http://vivoweb.org/ontology/core#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT ?existingPersonLabel WHERE { \n  ?position core:relates ?existingPerson . \n  ?existingPerson rdfs:label ?existingPersonLabel . }";
    private static final String QUERY_EXISTING_INTERVAL_NODE = "PREFIX core: <http://vivoweb.org/ontology/core#> \nSELECT ?existingIntervalNode WHERE { \n  ?position core:dateTimeInterval ?existingIntervalNode . \n  ?existingIntervalNode a core:DateTimeInterval . }";
    private static final String QUERY_EXISTING_START_NODE = "PREFIX core: <http://vivoweb.org/ontology/core#> \nSELECT ?existingStartNode WHERE { \n  ?position core:dateTimeInterval ?intervalNode .\n  ?intervalNode a core:DateTimeInterval ;\n      core:start ?existingStartNode . \n  ?existingStartNode a core:DateTimeValue . }";
    private static final String QUERY_EXISTING_START_VALUE = "PREFIX core: <http://vivoweb.org/ontology/core#> \nSELECT ?existingDateStart WHERE { \n  ?position core:dateTimeInterval ?intervalNode .\n  ?intervalNode a core:DateTimeInterval ; \n      core:start ?startNode . \n  ?startNode a core:DateTimeValue ; \n      core:dateTime ?existingDateStart . }";
    private static final String QUERY_EXISTING_START_PRECISION = "PREFIX core: <http://vivoweb.org/ontology/core#> \nSELECT ?existingStartPrecision WHERE { \n  ?position core:dateTimeInterval ?intervalNode .\n  ?intervalNode a core:DateTimeInterval ;\n      core:start ?startNode . \n  ?startNode a core:DateTimeValue ; \n      core:dateTimePrecision ?existingStartPrecision . }";
    private static final String QUERY_EXISTING_END_NODE = "PREFIX core: <http://vivoweb.org/ontology/core#> \nSELECT ?existingEndNode WHERE { \n  ?position core:dateTimeInterval ?intervalNode .\n  ?intervalNode a core:DateTimeInterval ;\n      core:end ?existingEndNode . \n  ?existingEndNode a core:DateTimeValue . }";
    private static final String QUERY_EXISTING_END_VALUE = "PREFIX core: <http://vivoweb.org/ontology/core#> \nSELECT ?existingDateEnd WHERE { \n  ?position core:dateTimeInterval ?intervalNode .\n  ?intervalNode a core:DateTimeInterval ; \n        core:end ?endNode . \n  ?endNode a core:DateTimeValue ; \n        core:dateTime ?existingDateEnd . }";
    private static final String QUERY_EXISTING_END_PRECISION = "PREFIX core: <http://vivoweb.org/ontology/core#> \nSELECT ?existingEndPrecision WHERE { \n  ?position core:dateTimeInterval ?intervalNode .\n  ?intervalNode a core:DateTimeInterval ;\n      core:end ?endNode . \n  ?endNode a core:DateTimeValue ; \n      core:dateTimePrecision ?existingEndPrecision . }";
    private static final String N3_NEW_POSITION = "@prefix core: <http://vivoweb.org/ontology/core#> . \n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> . \n?organization core:relatedBy ?position . \n?position a core:Position . \n?position a  ?positionType . \n?position rdfs:label ?positionTitle . \n?position core:relates ?organization . ";
    private static final String N3_NEW_PERSON = "@prefix core: <http://vivoweb.org/ontology/core#> . \n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> . \n@prefix foaf: <http://xmlns.com/foaf/0.1/> . \n?position core:relates ?person . \n?person core:relatedBy ?position . \n?person a foaf:Person . \n?person rdfs:label ?personLabel . ";
    private static final String N3_NEW_FIRST_NAME = "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?person <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?person . \n?vcardPerson a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardPerson vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:givenName ?firstName .";
    private static final String N3_NEW_LAST_NAME = "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?person <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?person . \n?vcardPerson a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardPerson vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:familyName ?lastName .";
    private static final String N3_EXISTING_PERSON = "@prefix core: <http://vivoweb.org/ontology/core#> . \n?position core:relates ?existingPerson . \n?existingPerson core:relatedBy ?position . \n";
    private static final String N3_NEW_START_NODE = "@prefix core: <http://vivoweb.org/ontology/core#> . \n?position core:dateTimeInterval ?intervalNode . \n?intervalNode a core:DateTimeInterval . \n?intervalNode core:start ?startNode . \n ?startNode a core:DateTimeValue . \n?startNode core:dateTime ?startField-value. \n?startNode core:dateTimePrecision ?startField-precision . ";
    private static final String N3_NEW_END_NODE = "@prefix core: <http://vivoweb.org/ontology/core#> . \n?position core:dateTimeInterval ?intervalNode . \n?intervalNode a core:DateTimeInterval . \n?intervalNode core:end ?endNode . \n ?endNode a core:DateTimeValue . \n?endNode core:dateTime ?endField-value . \n?endNode core:dateTimePrecision ?endField-precision . ";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setVarNameForSubject("organization");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("position");
        conf.setTemplate("organizationHasPositionHistory.ftl");
        conf.setN3Required(Arrays.asList(N3_NEW_POSITION));
        conf.setN3Optional(Arrays.asList(N3_NEW_PERSON, N3_EXISTING_PERSON, N3_NEW_START_NODE, N3_NEW_END_NODE, N3_NEW_FIRST_NAME, N3_NEW_LAST_NAME));
        conf.addNewResource("position", "");
        conf.addNewResource("person", "");
        conf.addNewResource("vcardName", "");
        conf.addNewResource("vcardPerson", "");
        conf.addNewResource("intervalNode", "");
        conf.addNewResource("startNode", "");
        conf.addNewResource("endNode", "");
        conf.setUrisOnform(Arrays.asList("existingPerson", "position", "positionType"));
        conf.addSparqlForExistingUris("positionType", QUERY_EXISTING_POSITION_TYPE);
        conf.addSparqlForExistingUris("intervalNode", QUERY_EXISTING_INTERVAL_NODE);
        conf.addSparqlForExistingUris("startNode", QUERY_EXISTING_START_NODE);
        conf.addSparqlForExistingUris("endNode", QUERY_EXISTING_END_NODE);
        conf.setLiteralsOnForm(Arrays.asList("positionTitle", "personLabelDisplay", "personLabel", "firstName", "lastName"));
        conf.addSparqlForExistingLiteral("positionTitle", QUERY_EXISTING_POSITION_TITLE);
        conf.addSparqlForExistingLiteral("personLabel", QUERY_EXISTING_PERSON_LABEL);
        conf.addSparqlForExistingUris("existingPerson", QUERY_EXISTING_PERSON);
        conf.addSparqlForExistingLiteral("startField-value", QUERY_EXISTING_START_VALUE);
        conf.addSparqlForExistingUris("startField-precision", QUERY_EXISTING_START_PRECISION);
        conf.addSparqlForExistingLiteral("endField-value", QUERY_EXISTING_END_VALUE);
        conf.addSparqlForExistingUris("endField-precision", QUERY_EXISTING_END_PRECISION);
        conf.addField(new FieldVTwo().setName("positionType").setValidators(OrganizationHasPositionHistoryGenerator.list((Object[])new Object[]{"nonempty"})).setOptions((FieldOptions)new ChildVClassesWithParent(URI_POSITION_CLASS)));
        conf.addField(new FieldVTwo().setName("positionTitle").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationHasPositionHistoryGenerator.list((Object[])new Object[]{"nonempty"})));
        conf.addField(new FieldVTwo().setName("existingPerson"));
        conf.addField(new FieldVTwo().setName("personLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationHasPositionHistoryGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("firstName").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationHasPositionHistoryGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("lastName").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationHasPositionHistoryGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("personLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationHasPositionHistoryGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        FieldVTwo startField = new FieldVTwo().setName("startField");
        conf.addField(startField.setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(startField, URI_PRECISION_YEAR, URI_PRECISION_NONE)));
        FieldVTwo endField = new FieldVTwo().setName("endField");
        conf.addField(endField.setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(endField, URI_PRECISION_YEAR, URI_PRECISION_NONE)));
        conf.addValidator((N3ValidatorVTwo)new FirstAndLastNameValidator("existingPerson", I18n.bundle((HttpServletRequest)vreq)));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        conf.addValidator((N3ValidatorVTwo)new DateTimeIntervalValidationVTwo("startField", "endField"));
        this.prepare(vreq, conf);
        return conf;
    }
}

