/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.coprincipalinvestigator;

import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaborator;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.SparklineData;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.YearToEntityCountDataElement;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;

public class CoPIVisCodeGenerator {
    private static final String DEFAULT_VISCONTAINER_DIV_ID = "unique_coinvestigators_vis_container";
    private Map<String, Set<Collaborator>> yearToUniqueCoPIs;
    private Log log;
    private SparklineData sparklineParameterVO;
    private String individualURI;

    public CoPIVisCodeGenerator(String individualURI, String visMode, String visContainer, Map<String, Set<Collaborator>> yearToUniqueCoPIs, Log log) {
        this.individualURI = individualURI;
        this.yearToUniqueCoPIs = yearToUniqueCoPIs;
        this.log = log;
        this.sparklineParameterVO = this.setupSparklineParameters(visMode, visContainer);
    }

    private SparklineData setupSparklineParameters(String visMode, String providedVisContainerID) {
        SparklineData sparklineData = new SparklineData();
        int numOfYearsToBeRendered = 0;
        int currentYear = Calendar.getInstance().get(1) - 1;
        int shortSparkMinYear = currentYear - 10 + 1;
        HashSet<String> investigatedYears = new HashSet<String>(this.yearToUniqueCoPIs.keySet());
        investigatedYears.remove("Unknown");
        int minGrantYear = shortSparkMinYear;
        String visContainerID = null;
        if (this.yearToUniqueCoPIs.size() > 0) {
            try {
                minGrantYear = Integer.parseInt(Collections.min(investigatedYears));
            }
            catch (NumberFormatException | NoSuchElementException e1) {
                this.log.debug((Object)("vis: " + e1.getMessage() + " error occurred for " + this.yearToUniqueCoPIs.toString()));
            }
        }
        int minGrantYearConsidered = 0;
        minGrantYearConsidered = minGrantYear > shortSparkMinYear ? shortSparkMinYear : minGrantYear;
        numOfYearsToBeRendered = currentYear - minGrantYearConsidered + 1;
        sparklineData.setNumOfYearsToBeRendered(numOfYearsToBeRendered);
        int uniqueCoPICounter = 0;
        HashSet<Collaborator> allCoPIsWithKnownGrantShipYears = new HashSet<Collaborator>();
        ArrayList<YearToEntityCountDataElement> yearToUniqueInvestigatorsCountDataTable = new ArrayList<YearToEntityCountDataElement>();
        for (int grantYear = minGrantYearConsidered; grantYear <= currentYear; ++grantYear) {
            String grantYearAsString = String.valueOf(grantYear);
            Set<Collaborator> currentCoPIs = this.yearToUniqueCoPIs.get(grantYearAsString);
            Integer currentUniqueCoPIs = null;
            if (currentCoPIs != null) {
                currentUniqueCoPIs = currentCoPIs.size();
                allCoPIsWithKnownGrantShipYears.addAll(currentCoPIs);
            } else {
                currentUniqueCoPIs = 0;
            }
            yearToUniqueInvestigatorsCountDataTable.add(new YearToEntityCountDataElement(uniqueCoPICounter, grantYearAsString, currentUniqueCoPIs));
            ++uniqueCoPICounter;
        }
        sparklineData.setRenderedSparks(allCoPIsWithKnownGrantShipYears.size());
        sparklineData.setYearToEntityCountDataTable(yearToUniqueInvestigatorsCountDataTable);
        HashSet totalUniqueCoInvestigators = new HashSet(allCoPIsWithKnownGrantShipYears);
        Integer unknownYearGrants = 0;
        if (this.yearToUniqueCoPIs.get("Unknown") != null) {
            unknownYearGrants = this.yearToUniqueCoPIs.get("Unknown").size();
            totalUniqueCoInvestigators.addAll(this.yearToUniqueCoPIs.get("Unknown"));
        }
        sparklineData.setTotalCollaborationshipCount(totalUniqueCoInvestigators.size());
        sparklineData.setUnknownYearGrants(unknownYearGrants);
        visContainerID = providedVisContainerID != null ? providedVisContainerID : DEFAULT_VISCONTAINER_DIV_ID;
        sparklineData.setVisContainerDivID(visContainerID);
        sparklineData.setEarliestYearConsidered(minGrantYearConsidered);
        sparklineData.setEarliestRenderedGrantYear(minGrantYear);
        sparklineData.setLatestRenderedGrantYear(currentYear);
        if ("short".equalsIgnoreCase(visMode)) {
            sparklineData.setEarliestRenderedGrantYear(shortSparkMinYear);
            sparklineData.setShortVisMode(true);
        } else {
            sparklineData.setShortVisMode(false);
        }
        if (this.yearToUniqueCoPIs.size() > 0) {
            sparklineData.setFullTimelineNetworkLink(UtilityFunctions.getCollaboratorshipNetworkLink(this.individualURI, "person_level", "copi"));
            sparklineData.setDownloadDataLink(UtilityFunctions.getCSVDownloadURL(this.individualURI, "coprincipalinvestigator", "copis_count_per_year"));
            HashMap<String, Integer> yearToUniqueCoPIsCount = new HashMap<String, Integer>();
            for (Map.Entry<String, Set<Collaborator>> currentYearToUniqueCoPIsCount : this.yearToUniqueCoPIs.entrySet()) {
                yearToUniqueCoPIsCount.put(currentYearToUniqueCoPIsCount.getKey(), currentYearToUniqueCoPIsCount.getValue().size());
            }
            sparklineData.setYearToActivityCount(yearToUniqueCoPIsCount);
        }
        return sparklineData;
    }

    public SparklineData getValueObjectContainer() {
        return this.sparklineParameterVO;
    }
}

