/*
 * Decompiled with CFR 0.152.
 */
package org.vivoweb.webapp.sitemap;

import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.QueryConstants;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;

@WebServlet(name="SiteMapServlet", urlPatterns={"/robots.txt", "/sitemap.xml"})
public class SiteMapServlet
extends VitroHttpServlet {
    private static final int MAX_URLS = 50000;
    private static final Log log = LogFactory.getLog(SiteMapServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestURI = request.getRequestURI();
        if (requestURI != null) {
            if (requestURI.contains("robots.txt")) {
                String robotsPath = this.getServletContext().getRealPath("/robots.txt");
                String contextPath = request.getContextPath();
                StringBuilder builder = new StringBuilder("Sitemap: ");
                builder.append(this.getSchemeAndServer(request));
                if (!"/".equals(contextPath)) {
                    builder.append(contextPath);
                }
                builder.append("/sitemap.xml");
                response.getOutputStream().println(builder.toString());
                response.getOutputStream().println();
                try (FileInputStream is = null;){
                    is = new FileInputStream(robotsPath);
                    IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
                }
            }
            String schemeAndServer = this.getSchemeAndServer(request);
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?person\nWHERE\n{\n  ?person a foaf:Person .\n} LIMIT " + 50000 + "\n";
            VitroRequest vreq = new VitroRequest(request);
            ServletOutputStream out = response.getOutputStream();
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">");
            final ArrayList personURIs = new ArrayList();
            try {
                vreq.getRDFService().sparqlSelectQuery(query, new ResultSetConsumer(){

                    protected void processQuerySolution(QuerySolution qs) {
                        personURIs.add(qs.getResource("person").getURI());
                    }
                });
            }
            catch (RDFServiceException rse) {
                log.error((Object)rse, (Throwable)rse);
            }
            for (String person : personURIs) {
                String profileUrl = UrlBuilder.getIndividualProfileUrl((String)person, (VitroRequest)vreq);
                if (StringUtils.isEmpty((CharSequence)profileUrl)) continue;
                try {
                    out.println("  <url>");
                    out.println("    <loc>" + schemeAndServer + profileUrl + "</loc>");
                    out.println("    <changefreq>weekly</changefreq>");
                    out.println("  </url>");
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            out.println("</urlset>");
        }
        super.doGet(request, response);
    }

    private String getSchemeAndServer(HttpServletRequest request) {
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String scheme = request.getScheme();
        if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
            StringBuilder builder = new StringBuilder();
            builder.append(scheme).append("://").append(serverName);
            if ("http".equalsIgnoreCase(scheme) && serverPort != 80 || "https".equalsIgnoreCase(scheme) && serverPort != 443) {
                builder.append(":").append(serverPort);
            }
            return builder.toString();
        }
        return "";
    }
}

