/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing;

import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Literal;

public class FirstAndLastNameValidator
implements N3ValidatorVTwo {
    private static String MISSING_FIRST_NAME_ERROR = "first_name_empty_msg";
    private static String MISSING_LAST_NAME_ERROR = "last_name_empty_msg";
    private static String MALFORMED_LAST_NAME_ERROR = "malformed_last_name_msg";
    private I18nBundle i18n;
    private String uriReceiver;

    public FirstAndLastNameValidator(String uriReceiver, I18nBundle i18n) {
        this.i18n = i18n;
        this.uriReceiver = uriReceiver;
    }

    public Map<String, String> validate(EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub) {
        Map urisFromForm = editSub.getUrisFromForm();
        Map literalsFromForm = editSub.getLiteralsFromForm();
        HashMap<String, String> errors = new HashMap<String, String>();
        List personUri = (List)urisFromForm.get(this.uriReceiver);
        if (this.allListElementsEmpty(personUri) || personUri.contains(">SUBMITTED VALUE WAS BLANK<")) {
            personUri = null;
        }
        if (personUri != null) {
            return null;
        }
        Literal firstName = null;
        List firstNameList = (List)literalsFromForm.get("firstName");
        if (firstNameList != null && firstNameList.size() > 0) {
            firstName = (Literal)firstNameList.get(0);
        }
        if (firstName != null && firstName.getLexicalForm() != null && "".equals(firstName.getLexicalForm())) {
            firstName = null;
        }
        List lastNameList = (List)literalsFromForm.get("lastName");
        Literal lastName = null;
        if (lastNameList != null && lastNameList.size() > 0) {
            lastName = (Literal)lastNameList.get(0);
        }
        String lastNameValue = "";
        if (lastName != null && "".equals(lastNameValue = lastName.getLexicalForm())) {
            lastName = null;
        }
        if (lastName == null) {
            errors.put("lastName", this.i18n.text(MISSING_LAST_NAME_ERROR, new Object[0]));
        } else if (lastNameValue.contains(",")) {
            errors.put("lastName", this.i18n.text(MALFORMED_LAST_NAME_ERROR, new Object[0]));
        }
        if (firstName == null) {
            errors.put("firstName", this.i18n.text(MISSING_FIRST_NAME_ERROR, new Object[0]));
        }
        return errors.size() != 0 ? errors : null;
    }

    private boolean allListElementsEmpty(List<String> checkList) {
        if (checkList == null) {
            return true;
        }
        if (checkList.isEmpty()) {
            return true;
        }
        boolean allEmpty = true;
        for (String s : checkList) {
            if (s.length() == 0) continue;
            allEmpty = false;
            break;
        }
        return allEmpty;
    }
}

