/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.vocabulary.XSD;

public class PersonHasEmailGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    private Log log = LogFactory.getLog(PersonHasEmailGenerator.class);
    static final String n3ForNewEmail = "?person <http://purl.obolibrary.org/obo/ARG_2000028>  ?individualVcard . \n?individualVcard a <http://www.w3.org/2006/vcard/ns#Individual> . \n?individualVcard <http://purl.obolibrary.org/obo/ARG_2000029> ?person . \n?individualVcard <http://www.w3.org/2006/vcard/ns#hasEmail> ?email . \n?email a <http://www.w3.org/2006/vcard/ns#Email> . ";
    static final String n3ForNewPrimaryEmail = "?person <http://purl.obolibrary.org/obo/ARG_2000028>  ?individualVcard . \n?individualVcard a <http://www.w3.org/2006/vcard/ns#Individual> . \n?individualVcard <http://purl.obolibrary.org/obo/ARG_2000029> ?person . \n?individualVcard <http://www.w3.org/2006/vcard/ns#hasEmail> ?email . \n?email a <http://www.w3.org/2006/vcard/ns#Email> . \n?email a <http://www.w3.org/2006/vcard/ns#Work> .";
    static final String emailAddressAssertion = "?email <http://www.w3.org/2006/vcard/ns#email> ?emailAddress .";
    static final String individualVcardQuery = "SELECT ?existingIndividualVcard WHERE { \n?person <http://purl.obolibrary.org/obo/ARG_2000028>  ?existingIndividualVcard . \n}";
    static final String emailAddressQuery = "SELECT ?existingEmailAddress WHERE {\n?email <http://www.w3.org/2006/vcard/ns#email> ?existingEmailAddress . }";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        String emailUri = this.getEmailUri(vreq);
        String rangeUri = this.getRangeUri(vreq);
        conf.setTemplate("personHasEmailAddress.ftl");
        conf.setVarNameForSubject("person");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("individualVcard");
        if (rangeUri.equals("http://www.w3.org/2006/vcard/ns#Work")) {
            conf.setN3Required(Arrays.asList(n3ForNewPrimaryEmail));
        } else {
            conf.setN3Required(Arrays.asList(n3ForNewEmail));
        }
        conf.setN3Optional(Arrays.asList(emailAddressAssertion));
        conf.addNewResource("email", "");
        conf.addNewResource("individualVcard", "");
        conf.setLiteralsOnForm(Arrays.asList("emailAddress"));
        conf.addSparqlForExistingLiteral("emailAddress", emailAddressQuery);
        conf.addSparqlForAdditionalUrisInScope("individualVcard", individualVcardQuery);
        if (conf.isUpdate()) {
            HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
            urisInScope.put("email", Arrays.asList(emailUri));
            conf.addUrisInScope(urisInScope);
        }
        conf.addField(new FieldVTwo().setName("emailAddress").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasEmailGenerator.list((Object[])new Object[]{"nonempty"})));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        this.prepare(vreq, conf);
        return conf;
    }

    private String getRangeUri(VitroRequest vreq) {
        String rangeUri = vreq.getParameter("rangeUri");
        return rangeUri;
    }

    private String getEmailUri(VitroRequest vreq) {
        String emailUri = vreq.getParameter("emailUri");
        return emailUri;
    }
}

