/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.extensions;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifier;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinder;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDFS;

public class LabelsAcrossContextNodes
implements IndexingUriFinder,
DocumentModifier,
ContextModelsUser {
    private static final Log log = LogFactory.getLog(LabelsAcrossContextNodes.class);
    private RDFService rdfService;
    private String label;
    private String incomingPropertyUri;
    private String outgoingPropertyUri;
    private Set<String> typeRestrictions = new HashSet<String>();
    private Set<String> contextNodeClasses = new HashSet<String>();
    private static final String LABELS_WITHOUT_RESTRICTION = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT ?label  \nWHERE { \n   ?uri ?incoming ?contextNode . \n   ?contextNode ?outgoing ?partner . \n   ?partner rdfs:label ?label . \n   FILTER( ?uri != ?partner  ) \n} \n";
    private static final String LABELS_FOR_SPECIFIC_CONTEXT_NODE_TYPE = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT ?label  \nWHERE { \n   ?uri ?incoming ?contextNode . \n   ?contextNode a ?nodeType . \n   ?contextNode ?outgoing ?partner . \n   ?partner rdfs:label ?label . \n   FILTER( ?uri != ?partner  ) \n} \n";
    private static final String LOCATE_PARTNERS_WITHOUT_RESTRICTION = "SELECT ?partner  \nWHERE { \n   ?partner ?incoming ?contextNode . \n   ?contextNode ?outgoing ?uri . \n   FILTER( ?uri != ?partner  ) \n} \n";
    private static final String LOCATE_PARTNERS_ON_CONTEXT_NODE_TYPE = "SELECT ?partner  \nWHERE { \n   ?partner ?incoming ?contextNode . \n   ?contextNode ?outgoing ?uri . \n   ?contextNode a ?nodeType . \n   FILTER( ?uri != ?partner  ) \n} \n";
    private static final String LOCATE_OTHER_PARTNERS_ON_THIS_NODE = "SELECT ?partner  \nWHERE { \n   ?contextNode ?outgoing ?partner . \n   FILTER( ?uri != ?partner  ) \n} \n";
    private static final String GET_TYPES = "SELECT ?type  \nWHERE { \n   ?uri a ?type . \n} \n";

    public void setContextModels(ContextModelAccess models) {
        this.rdfService = models.getRDFService();
    }

    @Property(uri="http://www.w3.org/2000/01/rdf-schema#label", maxOccurs=1)
    public void setLabel(String l) {
        this.label = l;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasIncomingProperty", minOccurs=1, maxOccurs=1)
    public void setIncomingProperty(String incomingUri) {
        this.incomingPropertyUri = incomingUri;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasOutgoingProperty", minOccurs=1, maxOccurs=1)
    public void setOutgoingProperty(String outgoingUri) {
        this.outgoingPropertyUri = outgoingUri;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasTypeRestriction")
    public void addTypeRestriction(String typeUri) {
        this.typeRestrictions.add(typeUri);
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#appliesToContextNodeType")
    public void addContextNodeClass(String cnc) {
        this.contextNodeClasses.add(cnc);
    }

    @Validation
    public void validate() {
        if (this.label == null) {
            this.label = String.format("%s[types=%s, contextNodeTypes=%s]", this.getClass().getSimpleName(), this.formatRestrictions(this.typeRestrictions), this.formatRestrictions(this.contextNodeClasses));
        }
    }

    private String formatRestrictions(Set<String> uris) {
        if (uris.isEmpty()) {
            return "ALL";
        }
        return this.localNames(uris).toString();
    }

    private Set<String> localNames(Set<String> uris) {
        HashSet<String> names = new HashSet<String>();
        for (String uri : uris) {
            try {
                names.add(ResourceFactory.createResource((String)uri).getLocalName());
            }
            catch (Exception e) {
                log.warn((Object)("Failed to parse URI: " + uri), (Throwable)e);
                names.add(uri);
            }
        }
        return names;
    }

    public String toString() {
        return this.label == null ? super.toString() : this.label;
    }

    public void modifyDocument(Individual ind, SearchInputDocument doc) {
        if (this.passesTypeRestriction(ind)) {
            if (this.contextNodeClasses.isEmpty()) {
                this.addLabelsFromAllContextNodeClasses(ind, doc);
            } else {
                for (String contextNodeClass : this.contextNodeClasses) {
                    this.addLabelsFromContextNodeClass(ind, doc, contextNodeClass);
                }
            }
        }
    }

    private boolean passesTypeRestriction(Individual ind) {
        if (this.typeRestrictions.isEmpty()) {
            return true;
        }
        for (VClass type : ind.getVClasses()) {
            if (!this.typeRestrictions.contains(type.getURI())) continue;
            return true;
        }
        return false;
    }

    private void addLabelsFromAllContextNodeClasses(Individual ind, SearchInputDocument doc) {
        this.addValuesToTextFields(doc, SparqlQueryRunner.createSelectQueryContext((RDFService)this.rdfService, (String)LABELS_WITHOUT_RESTRICTION).bindVariableToUri("uri", ind.getURI()).bindVariableToUri("incoming", this.incomingPropertyUri).bindVariableToUri("outgoing", this.outgoingPropertyUri).execute().toStringFields(new String[]{"label"}).flatten());
    }

    private void addLabelsFromContextNodeClass(Individual ind, SearchInputDocument doc, String contextNodeClass) {
        this.addValuesToTextFields(doc, SparqlQueryRunner.createSelectQueryContext((RDFService)this.rdfService, (String)LABELS_FOR_SPECIFIC_CONTEXT_NODE_TYPE).bindVariableToUri("uri", ind.getURI()).bindVariableToUri("nodeType", contextNodeClass).bindVariableToUri("incoming", this.incomingPropertyUri).bindVariableToUri("outgoing", this.outgoingPropertyUri).execute().toStringFields(new String[]{"label"}).flatten());
    }

    private void addValuesToTextFields(SearchInputDocument doc, List<String> values) {
        for (String value : values) {
            doc.addField("ALLTEXT", new Object[]{value});
            doc.addField("ALLTEXTUNSTEMMED", new Object[]{value});
        }
    }

    public void shutdown() {
    }

    public void startIndexing() {
    }

    public List<String> findAdditionalURIsToIndex(Statement stmt) {
        if (this.isLabelStatement(stmt)) {
            return this.filterByType(this.locatePartners(stmt));
        }
        if (this.isIncomingStatementOnAcceptableContextNode(stmt)) {
            return this.filterByType(this.locateOtherPartners(stmt));
        }
        return Collections.emptyList();
    }

    private boolean isLabelStatement(Statement stmt) {
        return RDFS.label.getURI().equals(stmt.getPredicate().getURI());
    }

    private Set<String> locatePartners(Statement stmt) {
        String uri = stmt.getSubject().getURI();
        if (this.contextNodeClasses.isEmpty()) {
            return this.locatePartnersWithoutRestriction(uri);
        }
        HashSet<String> uris = new HashSet<String>();
        for (String contextNodeClass : this.contextNodeClasses) {
            uris.addAll(this.locatePartnersAcrossContextNodeClass(uri, contextNodeClass));
        }
        return uris;
    }

    private Set<String> locatePartnersWithoutRestriction(String uri) {
        return SparqlQueryRunner.createSelectQueryContext((RDFService)this.rdfService, (String)LOCATE_PARTNERS_WITHOUT_RESTRICTION).bindVariableToUri("uri", uri).bindVariableToUri("incoming", this.incomingPropertyUri).bindVariableToUri("outgoing", this.outgoingPropertyUri).execute().toStringFields(new String[]{"partner"}).flattenToSet();
    }

    private Collection<? extends String> locatePartnersAcrossContextNodeClass(String uri, String contextNodeClass) {
        return SparqlQueryRunner.createSelectQueryContext((RDFService)this.rdfService, (String)LOCATE_PARTNERS_ON_CONTEXT_NODE_TYPE).bindVariableToUri("uri", uri).bindVariableToUri("nodeType", contextNodeClass).bindVariableToUri("incoming", this.incomingPropertyUri).bindVariableToUri("outgoing", this.outgoingPropertyUri).execute().toStringFields(new String[]{"partner"}).flattenToSet();
    }

    private boolean isIncomingStatementOnAcceptableContextNode(Statement stmt) {
        String subjectUri = stmt.getSubject().getURI();
        String predicateUri = stmt.getPredicate().getURI();
        return this.incomingPropertyUri.equals(predicateUri) && (this.contextNodeClasses.isEmpty() || this.isAnyMatch(this.contextNodeClasses, this.getTypes(subjectUri)));
    }

    private boolean isAnyMatch(Set<String> set1, Set<String> set2) {
        HashSet<String> matches = new HashSet<String>(set1);
        matches.retainAll(set2);
        return !matches.isEmpty();
    }

    private Set<String> getTypes(String uri) {
        return SparqlQueryRunner.createSelectQueryContext((RDFService)this.rdfService, (String)GET_TYPES).bindVariableToUri("uri", uri).execute().toStringFields(new String[]{"type"}).flattenToSet();
    }

    private Set<String> locateOtherPartners(Statement stmt) {
        if (!stmt.getSubject().isURIResource()) {
            return Collections.emptySet();
        }
        String nodeUri = stmt.getSubject().getURI();
        String objectUri = stmt.getObject().isURIResource() ? stmt.getObject().asResource().getURI() : "NO_MATCH";
        return SparqlQueryRunner.createSelectQueryContext((RDFService)this.rdfService, (String)LOCATE_OTHER_PARTNERS_ON_THIS_NODE).bindVariableToUri("contextNode", nodeUri).bindVariableToUri("uri", objectUri).bindVariableToUri("outgoing", this.outgoingPropertyUri).execute().toStringFields(new String[]{"partner"}).flattenToSet();
    }

    private List<String> filterByType(Collection<String> uris) {
        if (this.typeRestrictions.isEmpty()) {
            return new ArrayList<String>(uris);
        }
        ArrayList<String> filtered = new ArrayList<String>();
        for (String uri : uris) {
            if (!this.isAnyMatch(this.typeRestrictions, this.getTypes(uri))) continue;
            filtered.add(uri);
        }
        return filtered;
    }

    public void endIndexing() {
    }
}

