/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasAssociatedIndividual;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ServletPolicyList;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.policy.specialrelationships.AbstractRelationshipPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractPropertyStatementAction;
import edu.cornell.mannlib.vivo.auth.policy.AdvisingRelationshipChecker;
import edu.cornell.mannlib.vivo.auth.policy.CourseChecker;
import edu.cornell.mannlib.vivo.auth.policy.GrantChecker;
import edu.cornell.mannlib.vivo.auth.policy.InfoContentEntityChecker;
import edu.cornell.mannlib.vivo.auth.policy.PresentationChecker;
import edu.cornell.mannlib.vivo.auth.policy.ProjectOrServiceChecker;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfEditorRelationshipPolicy
extends AbstractRelationshipPolicy
implements PolicyIface {
    private static final Log log = LogFactory.getLog(SelfEditorRelationshipPolicy.class);

    public SelfEditorRelationshipPolicy(ServletContext ctx) {
        super(ctx);
    }

    public PolicyDecision isAuthorized(IdentifierBundle whoToAuth, RequestedAction whatToAuth) {
        if (whatToAuth == null) {
            return this.inconclusiveDecision("whatToAuth was null");
        }
        if (!(whatToAuth instanceof AbstractPropertyStatementAction)) {
            return this.inconclusiveDecision("Does not authorize " + whatToAuth.getClass().getSimpleName() + " actions");
        }
        AbstractPropertyStatementAction action = (AbstractPropertyStatementAction)whatToAuth;
        ArrayList<String> userUris = new ArrayList<String>(HasAssociatedIndividual.getIndividualUris((IdentifierBundle)whoToAuth));
        if (userUris.isEmpty()) {
            return this.inconclusiveDecision("Not self-editing.");
        }
        if (!this.canModifyPredicate(action.getPredicate())) {
            return this.cantModifyPredicate(action.getPredicate().getURI());
        }
        for (String resourceUri : action.getResourceUris()) {
            if (this.canModifyResource(resourceUri)) continue;
            return this.cantModifyResource(resourceUri);
        }
        return this.checkRelationships(userUris, action);
    }

    private PolicyDecision checkRelationships(List<String> userUris, AbstractPropertyStatementAction action) {
        PolicyDecision decision = new InfoContentEntityChecker(action).isAuthorized(userUris);
        if (decision == null) {
            decision = new GrantChecker(action).isAuthorized(userUris);
        }
        if (decision == null) {
            decision = new ProjectOrServiceChecker(action).isAuthorized(userUris);
        }
        if (decision == null) {
            decision = new PresentationChecker(action).isAuthorized(userUris);
        }
        if (decision == null) {
            decision = new CourseChecker(action).isAuthorized(userUris);
        }
        if (decision == null) {
            decision = new AdvisingRelationshipChecker(action).isAuthorized(userUris);
        }
        if (decision == null) {
            decision = this.userNotAuthorizedToStatement();
        }
        return decision;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": information resources, grants, projects, etc. - " + ((Object)((Object)this)).hashCode();
    }

    public static class Setup
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            ServletContext ctx = sce.getServletContext();
            ServletPolicyList.addPolicy((ServletContext)ctx, (PolicyIface)new SelfEditorRelationshipPolicy(ctx));
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }
}

