/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.AutocompleteRequiredInputValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeIntervalValidationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ConstantFieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class PersonHasIssuedCredentialGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String issuedCredentialTypeClass = "http://vivoweb.org/ontology/core#IssuedCredential";
    static final String credentialTypeClass = "http://vivoweb.org/ontology/core#Credential";
    static final String yearCredentialedPred = "http://vivoweb.org/ontology/core#dateIssued";
    static final String issuedCredentialToInterval = "http://vivoweb.org/ontology/core#dateTimeInterval";
    static final String intervalType = "http://vivoweb.org/ontology/core#DateTimeInterval";
    static final String intervalToStart = "http://vivoweb.org/ontology/core#start";
    static final String intervalToEnd = "http://vivoweb.org/ontology/core#end";
    static final String dateTimeValueType = "http://vivoweb.org/ontology/core#DateTimeValue";
    static final String dateTimeValue = "http://vivoweb.org/ontology/core#dateTime";
    static final String dateTimePrecision = "http://vivoweb.org/ontology/core#dateTimePrecision";
    static final String n3ForNewIssuedCredential = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n\n?person vivo:relatedBy  ?issuedCredential . \n?issuedCredential a  <http://vivoweb.org/ontology/core#IssuedCredential> . \n?issuedCredential vivo:relates ?person . ";
    static final String n3ForICTypeAssertion = "?issuedCredential a ?issuedCredentialType .";
    static final String n3ForNewCredentialAssertion = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n\n?issuedCredential vivo:relates ?credential . \n?credential a <http://vivoweb.org/ontology/core#Credential>  . \n?credential vivo:relatedBy ?issuedCredential . \n?credential a ?credentialType . \n?credential <http://www.w3.org/2000/01/rdf-schema#label> ?credentialLabel .";
    static final String n3ForExistingCredentialAssertion = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n\n?issuedCredential vivo:relates ?existingCredential . \n?existingCredential vivo:relatedBy ?issuedCredential . ";
    static final String n3ForYearCredentialed = "?issuedCredential <http://vivoweb.org/ontology/core#dateIssued> ?yearCredentialedNode . \n?yearCredentialedNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n?yearCredentialedNode  <http://vivoweb.org/ontology/core#dateTime> ?yearCredentialed-value . \n?yearCredentialedNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?yearCredentialed-precision .";
    static final String n3ForStart = "?issuedCredential <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode . \n?startNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n?startNode  <http://vivoweb.org/ontology/core#dateTime> ?startField-value . \n?startNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?startField-precision . \n";
    static final String n3ForEnd = "?issuedCredential <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode . \n?endNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n?endNode  <http://vivoweb.org/ontology/core#dateTime> ?endField-value . \n?endNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?endField-precision . \n";
    static final String existingCredentialQuery = "PREFIX vivo: <http://vivoweb.org/ontology/core#>  \nSELECT ?existingCredential WHERE { \n ?issuedCredential vivo:relates ?existingCredential . \n ?existingCredential a vivo:Credential . \n}";
    static final String existingCredentialTypeQuery = "PREFIX vivo: <http://vivoweb.org/ontology/core#>  \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?existingCredentialType WHERE { \n ?issuedCredential vivo:relates ?existingCredential . \n ?existingCredential a vivo:Credential . \n ?existingCredential vitro:mostSpecificType ?existingCredentialType . \n}";
    static final String issuedCredentialTypeQuery = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?existingICType WHERE { \n ?issuedCredential vitro:mostSpecificType ?existingICType . \n}";
    static final String credentialLabelQuery = "PREFIX vivo: <http://vivoweb.org/ontology/core#> \nSELECT ?existingCredentialLabel WHERE { \n ?issuedCredential vivo:relates ?existingCredential . \n ?existingCredential a <http://vivoweb.org/ontology/core#Credential> . \n ?existingCredential <http://www.w3.org/2000/01/rdf-schema#label> ?existingCredentialLabel . \n}";
    static final String existingYearCredentialedQuery = "SELECT ?existingYearCredentialedValue WHERE { \n  ?issuedCredential <http://vivoweb.org/ontology/core#dateIssued> ?yearCredentialedNode . \n  ?yearCredentialedNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?yearCredentialedNode <http://vivoweb.org/ontology/core#dateTime> ?existingYearCredentialedValue }";
    static final String existingYearCredentialedNodeQuery = "SELECT ?existingYearCredentialedNode WHERE { \n  ?issuedCredential <http://vivoweb.org/ontology/core#dateIssued> ?existingYearCredentialedNode . }";
    static final String existingStartDateQuery = "SELECT ?existingStartDate WHERE { \n  ?issuedCredential <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode . \n  ?startNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?startNode <http://vivoweb.org/ontology/core#dateTime> ?existingStartDate . }";
    static final String existingEndDateQuery = "SELECT ?existingEndDate WHERE { \n  ?issuedCredential <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n   ?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode . \n  ?endNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?endNode <http://vivoweb.org/ontology/core#dateTime> ?existingEndDate . }";
    static final String existingIntervalNodeQuery = "SELECT ?existingIntervalNode WHERE { \n  ?issuedCredential <http://vivoweb.org/ontology/core#dateTimeInterval> ?existingIntervalNode . \n  ?existingIntervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . }";
    static final String existingStartNodeQuery = "SELECT ?existingStartNode WHERE { \n  ?issuedCredential <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#start> ?existingStartNode . \n  ?existingStartNode a <http://vivoweb.org/ontology/core#DateTimeValue> . }   ";
    static final String existingEndNodeQuery = "SELECT ?existingEndNode WHERE { \n  ?issuedCredential <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#end> ?existingEndNode . \n  ?existingEndNode a <http://vivoweb.org/ontology/core#DateTimeValue> } ";
    static final String existingYearCredentialedPrecisionQuery = "SELECT ?existingYearCredentialedPrecision WHERE { \n  ?issuedCredential <http://vivoweb.org/ontology/core#dateIssued> ?yearCredentialed . \n  ?yearCredentialed a  <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?yearCredentialed <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingYearCredentialedPrecision . }";
    static final String existingStartPrecisionQuery = "SELECT ?existingStartPrecision WHERE { \n  ?issuedCredential <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode . \n  ?startNode a  <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?startNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingStartPrecision . }";
    static final String existingEndPrecisionQuery = "SELECT ?existingEndPrecision WHERE { \n  ?issuedCredential <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode . \n  ?endNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?endNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingEndPrecision . }";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate("personHasIssuedCredential.ftl");
        conf.setVarNameForSubject("person");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("issuedCredential");
        conf.setN3Required(Arrays.asList(n3ForNewIssuedCredential, n3ForICTypeAssertion));
        conf.setN3Optional(Arrays.asList(n3ForNewCredentialAssertion, n3ForExistingCredentialAssertion, n3ForYearCredentialed, n3ForStart, n3ForEnd));
        conf.addNewResource("credential", "");
        conf.addNewResource("issuedCredential", "");
        conf.addNewResource("yearCredentialedNode", "");
        conf.addNewResource("intervalNode", "");
        conf.addNewResource("startNode", "");
        conf.addNewResource("endNode", "");
        conf.setUrisOnform(Arrays.asList("existingCredential", "issuedCredentialType", "credentialType"));
        conf.setLiteralsOnForm(Arrays.asList("yearCredentialedDisplay", "credentialLabel", "credentialLabelDisplay"));
        conf.addSparqlForExistingLiteral("credentialLabel", credentialLabelQuery);
        conf.addSparqlForExistingLiteral("yearCredentialed-value", existingYearCredentialedQuery);
        conf.addSparqlForExistingLiteral("startField-value", existingStartDateQuery);
        conf.addSparqlForExistingLiteral("endField-value", existingEndDateQuery);
        conf.addSparqlForExistingUris("existingCredential", existingCredentialQuery);
        conf.addSparqlForExistingUris("credentialType", existingCredentialTypeQuery);
        conf.addSparqlForExistingUris("issuedCredentialType", issuedCredentialTypeQuery);
        conf.addSparqlForExistingUris("yearCredentialedNode", existingYearCredentialedNodeQuery);
        conf.addSparqlForExistingUris("intervalNode", existingIntervalNodeQuery);
        conf.addSparqlForExistingUris("startNode", existingStartNodeQuery);
        conf.addSparqlForExistingUris("endNode", existingEndNodeQuery);
        conf.addSparqlForExistingUris("yearCredentialed-precision", existingYearCredentialedPrecisionQuery);
        conf.addSparqlForExistingUris("startField-precision", existingStartPrecisionQuery);
        conf.addSparqlForExistingUris("endField-precision", existingEndPrecisionQuery);
        conf.addField(new FieldVTwo().setName("issuedCredentialType").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasIssuedCredentialGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("credentialType").setOptions(this.getCredentialTypeFieldOptions(vreq)));
        conf.addField(new FieldVTwo().setName("existingCredential"));
        conf.addField(new FieldVTwo().setName("credentialLabel").setRangeDatatypeUri(RDF.dtLangString.getURI()).setValidators(PersonHasIssuedCredentialGenerator.list((Object[])new Object[]{"datatype:" + RDF.dtLangString.getURI()})));
        conf.addField(new FieldVTwo().setName("yearCredentialedDisplay").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasIssuedCredentialGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("credentialLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasIssuedCredentialGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("yearCredentialed").setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(null, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        conf.addField(new FieldVTwo().setName("startField").setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(null, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        conf.addField(new FieldVTwo().setName("endField").setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(null, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        conf.addValidator((N3ValidatorVTwo)new DateTimeIntervalValidationVTwo("startField", "endField"));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        conf.addValidator((N3ValidatorVTwo)new AutocompleteRequiredInputValidator("existingCredential", "credentialLabel"));
        this.addFormSpecificData(conf, vreq);
        this.prepare(vreq, conf);
        return conf;
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, HashMap<String, String>> formSpecificData = new HashMap<String, HashMap<String, String>>();
        formSpecificData.put("credentialTypeMap", this.getCredentialTypeMap());
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    private HashMap<String, String> getCredentialTypeMap() {
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("Credential", issuedCredentialTypeClass);
        credentials.put("Certificate", "http://vivoweb.org/ontology/core#Certification");
        credentials.put("License", "http://vivoweb.org/ontology/core#Licensure");
        return credentials;
    }

    private FieldOptions getCredentialTypeFieldOptions(VitroRequest vreq) throws Exception {
        return new ConstantFieldOptions(new String[]{"http://vivoweb.org/ontology/core#Certificate", "Certificate", credentialTypeClass, "Credential", "http://vivoweb.org/ontology/core#License", "License"});
    }
}

