/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;

class TotalInd
implements Runnable {
    private Dataset dataset;
    private String totalCountQuery;
    private static Log log = LogFactory.getLog(TotalInd.class);

    public TotalInd(Dataset dataset, String totalCountQuery) {
        this.dataset = dataset;
        this.totalCountQuery = totalCountQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int totalInd = 0;
        QuerySolution soln = null;
        this.dataset.getLock().enterCriticalSection(true);
        QueryExecution qexec = null;
        try {
            Query query = QueryFactory.create((String)this.totalCountQuery, (Syntax)Syntax.syntaxARQ);
            qexec = QueryExecutionFactory.create((Query)query, (Dataset)this.dataset);
            ResultSet results = qexec.execSelect();
            List resultVars = results.getResultVars();
            if (resultVars != null && resultVars.size() != 0) {
                soln = results.next();
                totalInd = Integer.parseInt(soln.getLiteral((String)resultVars.get(0)).getLexicalForm());
            }
        }
        catch (Throwable t) {
            log.error((Object)t, t);
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
            this.dataset.getLock().leaveCriticalSection();
        }
    }
}

