/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.PublicationHasAuthorValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public class AddAuthorsToInformationResourceGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    public static Log log = LogFactory.getLog(AddAuthorsToInformationResourceGenerator.class);
    private static String AUTHORSHIPS_MODEL = " \nPREFIX core: <http://vivoweb.org/ontology/core#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX vcard:  <http://www.w3.org/2006/vcard/ns#>\nCONSTRUCT\n{\n    ?subject core:relatedBy ?authorshipURI .\n    ?authorshipURI a core:Authorship .\n    ?authorshipURI core:relates ?authorURI .\n    ?authorshipURI core:rank ?rank .\n    ?authorURI a ?type .\n    ?authorURI rdfs:label ?authorName .\n    ?authorURI vcard:hasName ?vName .\n    ?vName vcard:givenName ?firstName .\n    ?vName vcard:familyName ?lastName .\n    ?vName core:middleName ?middleName .\n}\nWHERE\n{\n    {\n        ?subject core:relatedBy ?authorshipURI .\n        ?authorshipURI a core:Authorship .\n        ?authorshipURI core:relates ?authorURI .\n        ?authorURI a foaf:Agent .\n        ?authorURI a ?type .\n    }\n    UNION\n    {\n        ?subject core:relatedBy ?authorshipURI .\n        ?authorshipURI a core:Authorship .\n        ?authorshipURI core:relates ?authorURI .\n        ?authorURI a foaf:Agent .\n        ?authorURI rdfs:label ?authorName\n    }\n    UNION\n    {\n        ?subject core:relatedBy ?authorshipURI .\n        ?authorshipURI a core:Authorship .\n        ?authorshipURI core:rank ?rank\n    }\n    UNION\n    {\n        ?subject core:relatedBy ?authorshipURI .\n        ?authorshipURI a core:Authorship .\n        ?authorshipURI core:relates ?authorURI .\n        ?authorURI a vcard:Individual .\n        ?authorURI a ?type .\n        ?authorURI vcard:hasName ?vName .\n        ?vName vcard:givenName ?firstName .\n        ?vName vcard:familyName ?lastName .\n    }\n    UNION\n    {\n         ?subject core:relatedBy ?authorshipURI .\n         ?authorshipURI a core:Authorship .\n         ?authorshipURI core:relates ?authorURI .\n         ?authorURI a vcard:Individual .\n         ?authorURI a ?type .\n         ?authorURI vcard:hasName ?vName .\n         ?vName core:middleName ?middleName .\n    }\n}\n";
    private static String AUTHORSHIPS_QUERY = " \nPREFIX core: <http://vivoweb.org/ontology/core#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nPREFIX vcard:  <http://www.w3.org/2006/vcard/ns#> \nSELECT ?authorshipURI (REPLACE(STR(?authorshipURI),\"^.*(#)(.*)$\", \"$2\") AS ?authorshipName) ?authorURI ?authorName ?rank \nWHERE { { \n  ?subject core:relatedBy ?authorshipURI . \n  ?authorshipURI a core:Authorship . \n  ?authorshipURI core:relates ?authorURI . \n  ?authorURI a foaf:Agent . \n  OPTIONAL { ?authorURI rdfs:label ?authorName } \n  OPTIONAL { ?authorshipURI core:rank ?rank } \n} UNION {  \n\t ?subject core:relatedBy ?authorshipURI .  \n\t ?authorshipURI a core:Authorship .  \n\t ?authorshipURI core:relates ?authorURI .  \n\t ?authorURI a vcard:Individual .  \n\t ?authorURI vcard:hasName ?vName . \n\t ?vName vcard:givenName ?firstName . \n\t ?vName vcard:familyName ?lastName . \n\t OPTIONAL { ?vName core:middleName ?middleName . } \n\t OPTIONAL { ?authorshipURI core:rank ?rank }  \n\t bind ( COALESCE(?firstName, \"\") As ?firstName1) . \n\t bind ( COALESCE(?middleName, \"\") As ?middleName1) . \n\t bind ( COALESCE(?lastName, \"\") As ?lastName1) . \n\t bind (concat(str(?lastName1 + \", \"),str(?middleName1 + \" \"),str(?firstName1)) as ?authorName) . \n} } ORDER BY ?rank";
    private static String MAX_RANK_QUERY = "PREFIX core: <http://vivoweb.org/ontology/core#> \nSELECT DISTINCT ?rank WHERE { \n    ?subject core:relatedBy ?authorship . \n    ?authorship a core:Authorship . \n    ?authorship core:rank ?rank .\n} ORDER BY DESC(?rank) LIMIT 1";
    static final String DEFAULT_NS_TOKEN = null;

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initBasics(editConfiguration, vreq);
        this.initPropertyParameters(vreq, session, editConfiguration);
        this.setUrlToReturnTo(editConfiguration, vreq);
        editConfiguration.setVarNameForSubject("infoResource");
        editConfiguration.setVarNameForPredicate("predicate");
        editConfiguration.setVarNameForObject("authorshipUri");
        editConfiguration.setN3Required(AddAuthorsToInformationResourceGenerator.list((Object[])new Object[]{this.getN3NewAuthorship()}));
        editConfiguration.setN3Optional(this.generateN3Optional());
        editConfiguration.addNewResource("authorshipUri", DEFAULT_NS_TOKEN);
        editConfiguration.addNewResource("newPerson", DEFAULT_NS_TOKEN);
        editConfiguration.addNewResource("newOrg", DEFAULT_NS_TOKEN);
        editConfiguration.addNewResource("vcardPerson", DEFAULT_NS_TOKEN);
        editConfiguration.addNewResource("vcardName", DEFAULT_NS_TOKEN);
        this.setUrisAndLiteralsInScope(editConfiguration, vreq);
        this.setUrisAndLiteralsOnForm(editConfiguration, vreq);
        this.setSparqlQueries(editConfiguration, vreq);
        this.setFields(editConfiguration, vreq, EditConfigurationUtils.getPredicateUri((VitroRequest)vreq));
        editConfiguration.setTemplate("addAuthorsToInformationResource.ftl");
        editConfiguration.addValidator((N3ValidatorVTwo)new PublicationHasAuthorValidator());
        this.addFormSpecificData(editConfiguration, vreq);
        editConfiguration.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        return editConfiguration;
    }

    private void setUrlToReturnTo(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setUrlPatternToReturnTo(EditConfigurationUtils.getFormUrlWithoutContext((VitroRequest)vreq));
    }

    public String getN3PrefixString() {
        return "@prefix core: <http://vivoweb.org/ontology/core#> .\n@prefix foaf: <http://xmlns.com/foaf/0.1/> .  \n";
    }

    private String getN3NewAuthorship() {
        return this.getN3PrefixString() + "?authorshipUri a core:Authorship ;\n  core:relates ?infoResource .\n?infoResource core:relatedBy ?authorshipUri .";
    }

    private String getN3AuthorshipRank() {
        return this.getN3PrefixString() + "?authorshipUri core:rank ?rank .";
    }

    public List<String> generateN3Optional() {
        return AddAuthorsToInformationResourceGenerator.list((Object[])new Object[]{this.getN3NewPersonFirstName(), this.getN3NewPersonMiddleName(), this.getN3NewPersonLastName(), this.getN3NewPerson(), this.getN3AuthorshipRank(), this.getN3ForExistingPerson(), this.getN3NewOrg(), this.getN3ForExistingOrg()});
    }

    private String getN3NewPersonFirstName() {
        return this.getN3PrefixString() + "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newPerson <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?newPerson . \n?vcardPerson a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardPerson vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:givenName ?firstName .";
    }

    private String getN3NewPersonMiddleName() {
        return this.getN3PrefixString() + "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newPerson <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?newPerson . \n?vcardPerson a vcard:Individual . \n?vcardPerson vcard:hasName  ?vcardName . \n?vcardName a vcard:Name . \n?vcardName <http://vivoweb.org/ontology/core#middleName> ?middleName .";
    }

    private String getN3NewPersonLastName() {
        return this.getN3PrefixString() + "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newPerson <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?newPerson . \n?vcardPerson a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardPerson vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:familyName ?lastName .";
    }

    private String getN3NewPerson() {
        return this.getN3PrefixString() + "?newPerson a foaf:Person ;\n<" + RDFS.label.getURI() + "> ?label .\n?authorshipUri core:relates ?newPerson .\n?newPerson core:relatedBy ?authorshipUri . ";
    }

    private String getN3ForExistingPerson() {
        return this.getN3PrefixString() + "?authorshipUri core:relates ?personUri .\n?personUri core:relatedBy ?authorshipUri .";
    }

    private String getN3NewOrg() {
        return this.getN3PrefixString() + "?newOrg a foaf:Organization ;\n<" + RDFS.label.getURI() + "> ?orgName .\n?authorshipUri core:relates ?newOrg .\n?newOrg core:relatedBy ?authorshipUri . ";
    }

    private String getN3ForExistingOrg() {
        return this.getN3PrefixString() + "?authorshipUri core:relates ?orgUri .\n?orgUri core:relatedBy ?authorshipUri .";
    }

    private Map<String, String> generateNewResources(VitroRequest vreq) {
        HashMap<String, String> newResources = new HashMap<String, String>();
        newResources.put("authorshipUri", DEFAULT_NS_TOKEN);
        newResources.put("newPerson", DEFAULT_NS_TOKEN);
        newResources.put("vcardPerson", DEFAULT_NS_TOKEN);
        newResources.put("vcardName", DEFAULT_NS_TOKEN);
        newResources.put("newOrg", DEFAULT_NS_TOKEN);
        return newResources;
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
        urisInScope.put(editConfiguration.getVarNameForSubject(), Arrays.asList(editConfiguration.getSubjectUri()));
        urisInScope.put(editConfiguration.getVarNameForPredicate(), Arrays.asList(editConfiguration.getPredicateUri()));
        editConfiguration.setUrisInScope(urisInScope);
    }

    public void setUrisAndLiteralsOnForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        urisOnForm.add("personUri");
        urisOnForm.add("orgUri");
        editConfiguration.setUrisOnform(urisOnForm);
        List literalsOnForm = AddAuthorsToInformationResourceGenerator.list((Object[])new Object[]{"firstName", "middleName", "lastName", "rank", "orgName", "label"});
        editConfiguration.setLiteralsOnForm(literalsOnForm);
    }

    private void setSparqlQueries(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap map = new HashMap();
        editConfiguration.setSparqlForExistingUris(new HashMap());
        editConfiguration.setSparqlForExistingLiterals(new HashMap());
        editConfiguration.setSparqlForAdditionalUrisInScope(new HashMap());
        editConfiguration.setSparqlForAdditionalLiteralsInScope(new HashMap());
    }

    public void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri) {
        this.setLabelField(editConfiguration);
        this.setFirstNameField(editConfiguration);
        this.setMiddleNameField(editConfiguration);
        this.setLastNameField(editConfiguration);
        this.setRankField(editConfiguration);
        this.setPersonUriField(editConfiguration);
        this.setOrgUriField(editConfiguration);
        this.setOrgNameField(editConfiguration);
    }

    private void setLabelField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("label").setValidators(AddAuthorsToInformationResourceGenerator.list((Object[])new Object[]{"datatype:" + RDF.dtLangString.getURI()})).setRangeDatatypeUri(RDF.dtLangString.getURI()));
    }

    private void setFirstNameField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("firstName").setValidators(AddAuthorsToInformationResourceGenerator.list((Object[])new Object[]{"datatype:" + RDF.dtLangString.getURI()})).setRangeDatatypeUri(RDF.dtLangString.getURI()));
    }

    private void setMiddleNameField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("middleName").setValidators(AddAuthorsToInformationResourceGenerator.list((Object[])new Object[]{"datatype:" + RDF.dtLangString.getURI()})).setRangeDatatypeUri(RDF.dtLangString.getURI()));
    }

    private void setLastNameField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("lastName").setValidators(AddAuthorsToInformationResourceGenerator.list((Object[])new Object[]{"datatype:" + RDF.dtLangString.getURI()})).setRangeDatatypeUri(RDF.dtLangString.getURI()));
    }

    private void setRankField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("rank").setValidators(AddAuthorsToInformationResourceGenerator.list((Object[])new Object[]{"nonempty"})).setRangeDatatypeUri(XSD.xint.toString()));
    }

    private void setPersonUriField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("personUri"));
    }

    private void setOrgUriField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("orgUri"));
    }

    private void setOrgNameField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("orgName").setValidators(AddAuthorsToInformationResourceGenerator.list((Object[])new Object[]{"datatype:" + RDF.dtLangString.getURI()})).setRangeDatatypeUri(RDF.dtLangString.getURI()));
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, Object> formSpecificData = new HashMap<String, Object>();
        formSpecificData.put("existingAuthorInfo", this.getExistingAuthorships(editConfiguration.getSubjectUri(), vreq));
        formSpecificData.put("newRank", this.getMaxRank(editConfiguration.getSubjectUri(), vreq) + 1);
        formSpecificData.put("rankPredicate", "http://vivoweb.org/ontology/core#rank");
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AuthorshipInfo> getExistingAuthorships(String subjectUri, VitroRequest vreq) {
        RDFService rdfService = vreq.getRDFService();
        ArrayList<Map<String, String>> authorships = new ArrayList();
        try {
            String constructStr = QueryUtils.subUriForQueryVar((String)AUTHORSHIPS_MODEL, (String)"subject", (String)subjectUri);
            Model constructedModel = ModelFactory.createDefaultModel();
            rdfService.sparqlConstructQuery(constructStr, constructedModel);
            String queryStr = QueryUtils.subUriForQueryVar((String)this.getAuthorshipsQuery(), (String)"subject", (String)subjectUri);
            log.debug((Object)("Query string is: " + queryStr));
            try (QueryExecution qe = QueryExecutionFactory.create((String)queryStr, (Model)constructedModel);){
                ResultSet results = qe.execSelect();
                while (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    RDFNode node = soln.get("authorshipURI");
                    if (!node.isURIResource()) continue;
                    authorships.add(QueryUtils.querySolutionToStringValueMap((QuerySolution)soln));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        authorships = QueryUtils.removeDuplicatesMapsFromList(authorships, (String[])new String[]{"authorShipURI", "authorURI"});
        log.debug((Object)("authorships = " + authorships));
        return this.getAuthorshipInfo(authorships);
    }

    private int getMaxRank(String subjectUri, VitroRequest vreq) {
        int maxRank = 0;
        String queryStr = QueryUtils.subUriForQueryVar((String)this.getMaxRankQueryStr(), (String)"subject", (String)subjectUri);
        log.debug((Object)("maxRank query string is: " + queryStr));
        try {
            int rank;
            QuerySolution soln;
            RDFNode node;
            ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)vreq);
            if (results != null && results.hasNext() && (node = (soln = results.next()).get("rank")) != null && node.isLiteral() && (rank = Integer.parseInt(node.asLiteral().getLexicalForm())) > maxRank) {
                log.debug((Object)("setting maxRank to " + rank));
                maxRank = rank;
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)"Invalid rank returned from query: not an integer value.");
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        log.debug((Object)("maxRank is: " + maxRank));
        return maxRank;
    }

    private List<AuthorshipInfo> getAuthorshipInfo(List<Map<String, String>> authorships) {
        ArrayList<AuthorshipInfo> info = new ArrayList<AuthorshipInfo>();
        String authorshipUri = "";
        String authorshipName = "";
        String authorUri = "";
        String authorName = "";
        for (Map<String, String> authorship : authorships) {
            for (Map.Entry<String, String> entry : authorship.entrySet()) {
                if (entry.getKey().equals("authorshipURI")) {
                    authorshipUri = entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("authorshipName")) {
                    authorshipName = entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("authorURI")) {
                    authorUri = entry.getValue();
                    continue;
                }
                if (!entry.getKey().equals("authorName")) continue;
                authorName = entry.getValue();
            }
            AuthorshipInfo aaInfo = new AuthorshipInfo(authorshipUri, authorshipName, authorUri, authorName);
            info.add(aaInfo);
        }
        log.debug((Object)("info = " + info));
        return info;
    }

    protected String getMaxRankQueryStr() {
        return MAX_RANK_QUERY;
    }

    protected String getAuthorshipsQuery() {
        return AUTHORSHIPS_QUERY;
    }

    public class AuthorshipInfo {
        private String authorshipUri;
        private String authorshipName;
        private String authorUri;
        private String authorName;

        public AuthorshipInfo(String inputAuthorshipUri, String inputAuthorshipName, String inputAuthorUri, String inputAuthorName) {
            this.authorshipUri = inputAuthorshipUri;
            this.authorshipName = inputAuthorshipName;
            this.authorUri = inputAuthorUri;
            this.authorName = inputAuthorName;
        }

        public String getAuthorshipUri() {
            return this.authorshipUri;
        }

        public String getAuthorshipName() {
            return this.authorshipName;
        }

        public String getAuthorUri() {
            return this.authorUri;
        }

        public String getAuthorName() {
            return this.authorName;
        }
    }
}

