/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.IndividualsViaSearchQueryOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultObjectPropertyFormGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VIVODefaultAddMissingIndividualFormGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddConceptThroughObjectPropertyGenerator
extends DefaultObjectPropertyFormGenerator
implements EditConfigurationGenerator {
    private Log log = LogFactory.getLog(AddConceptThroughObjectPropertyGenerator.class);

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo editConfig = super.getEditConfiguration(vreq, session);
        if (!VIVODefaultAddMissingIndividualFormGenerator.isCreateNewIndividual((VitroRequest)vreq, (HttpSession)session)) {
            editConfig.addFormSpecificData("createNewTypes", this.getCreateNewTypesOptions(vreq));
            editConfig.setTemplate(this.getTemplate(vreq));
        }
        return editConfig;
    }

    private HashMap<String, String> getCreateNewTypesOptions(VitroRequest vreq) {
        HashMap<String, String> options = new HashMap<String, String>();
        List<VClass> rangeTypes = this.getRangeTypes(vreq);
        for (VClass v : rangeTypes) {
            options.put(v.getURI(), v.getName());
        }
        return options;
    }

    protected List<VClass> getRangeTypes(VitroRequest vreq) {
        WebappDaoFactory ctxDaoFact = vreq.getLanguageNeutralWebappDaoFactory();
        ArrayList<VClass> types = new ArrayList<VClass>();
        Individual subject = EditConfigurationUtils.getSubjectIndividual((VitroRequest)vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri((VitroRequest)vreq);
        String rangeUri = EditConfigurationUtils.getRangeUri((VitroRequest)vreq);
        if (rangeUri != null) {
            VClass rangeVClass = ctxDaoFact.getVClassDao().getVClassByURI(rangeUri);
            if (!rangeVClass.isUnion()) {
                types.add(rangeVClass);
            } else {
                types.addAll(rangeVClass.getUnionComponents());
            }
            return types;
        }
        this.log.warn((Object)"Range not found for this property so employing SKOS concept class");
        String vclassURI = "http://www.w3.org/2004/02/skos/core#Concept";
        VClass rangeVClass = ctxDaoFact.getVClassDao().getVClassByURI(vclassURI);
        types.add(rangeVClass);
        return types;
    }

    private String getTemplate(VitroRequest vreq) {
        String objectPropertyTemplate;
        String acObjectPropertyTemplate = "addConceptThroughObjectPropertyAutoComplete.ftl";
        String template = objectPropertyTemplate = "addConceptThroughObjectPropertyForm.ftl";
        if (this.doAutoComplete) {
            template = acObjectPropertyTemplate;
        }
        return template;
    }

    protected void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri, List<VClass> rangeTypes) throws Exception {
        FieldVTwo field = new FieldVTwo();
        field.setName("objectVar");
        ArrayList<String> validators = new ArrayList<String>();
        validators.add("nonempty");
        field.setValidators(validators);
        if (!this.doAutoComplete) {
            ArrayList<String> types = new ArrayList<String>();
            for (VClass v : rangeTypes) {
                types.add(v.getURI());
            }
            String[] typesArray = types.toArray(new String[types.size()]);
            field.setOptions((FieldOptions)new IndividualsViaSearchQueryOptions(this.getSubjectUri(), predicateUri, this.getObjectUri(), typesArray));
        } else {
            field.setOptions(null);
        }
        HashMap<String, FieldVTwo> fields = new HashMap<String, FieldVTwo>();
        fields.put(field.getName(), field);
        editConfiguration.setFields(fields);
    }
}

