/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.GeneratorUtil;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import edu.cornell.mannlib.vitro.webapp.utils.generators.EditModeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.resultset.ResultSetMem;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class AddEditorshipToPersonGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String n3ForNewEditorship = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?person ?predicate ?editorship . \n?editorship a  vivo:Editorship . \n?editorship vivo:relates ?person . ";
    static final String n3ForNewDocumentAssertion = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?editorship vivo:relates ?newDocument . \n?newDocument vivo:editedBy ?editorship . \n?newDocument a ?documentType . \n?newDocument <http://www.w3.org/2000/01/rdf-schema#label> ?documentLabel. ";
    static final String n3ForExistingDocumentAssertion = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?editorship vivo:relates ?existingDocument . \n?existingDocument vivo:editedBy ?editorship . \n?existingDocument a ?documentType . ";
    static final String documentTypeQuery = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nPREFIX vivo: <http://vivoweb.org/ontology/core#> . \nPREFIX bibo: <http://purl.org/ontology/bibo/> . \nSELECT ?documentType WHERE { \n  ?editorship vivo:relates ?existingDocument . \n  ?existingDocument a <http://purl.obolibrary.org/obo/IAO_0000030> . \n  ?existingDocument vitro:mostSpecificType ?documentType . \n}";
    static final String documentLabelQuery = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nPREFIX vivo: <http://vivoweb.org/ontology/core#> . \nPREFIX bibo: <http://purl.org/ontology/bibo/> . \nSELECT ?documentLabel WHERE { \n  ?editorship vivo:relates ?existingDocument . \n  ?existingDocument a <http://purl.obolibrary.org/obo/IAO_0000030> . \n  ?existingDocument <http://www.w3.org/2000/01/rdf-schema#label> ?documentLabel . \n}";
    static final String existingDocumentQuery = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nPREFIX vivo: <http://vivoweb.org/ontology/core#> . \nPREFIX bibo: <http://purl.org/ontology/bibo/> . \nSELECT existingDocument WHERE { \n  ?editorship vivo:relates ?existingDocument . \n  ?existingDocument a <http://purl.obolibrary.org/obo/IAO_0000030> . \n}";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        if (EditConfigurationUtils.getObjectUri((VitroRequest)vreq) == null) {
            return this.doAddNew(vreq, session);
        }
        return this.doSkipToDocument(vreq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditConfigurationVTwo doSkipToDocument(VitroRequest vreq) {
        Individual editorshipNode = EditConfigurationUtils.getObjectIndividual((VitroRequest)vreq);
        String documentQueryStr = "SELECT ?obj \nWHERE { <" + editorshipNode.getURI() + "> <http://vivoweb.org/ontology/core#relates> ?obj . \n    ?obj a <http://purl.obolibrary.org/obo/IAO_0000030> . } \n";
        Query documentQuery = QueryFactory.create((String)documentQueryStr);
        try (QueryExecution qe = QueryExecutionFactory.create((Query)documentQuery, (Model)ModelAccess.on((HttpServletRequest)vreq).getOntModel(new ModelAccess.LanguageOption[0]));){
            ResultSetMem rs = new ResultSetMem(qe.execSelect());
            if (!rs.hasNext()) {
                EditConfigurationVTwo editConfigurationVTwo = this.doBadEditorshipNoPub(vreq);
                return editConfigurationVTwo;
            }
            if (rs.size() > 1) {
                EditConfigurationVTwo editConfigurationVTwo = this.doBadEditorshipMultiplePubs(vreq);
                return editConfigurationVTwo;
            }
            RDFNode objNode = rs.next().get("obj");
            if (!objNode.isResource() || objNode.isAnon()) {
                EditConfigurationVTwo editConfigurationVTwo = this.doBadEditorshipNoPub(vreq);
                return editConfigurationVTwo;
            }
            EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
            editConfiguration.setSkipToUrl(UrlBuilder.getIndividualProfileUrl((String)((Resource)objNode).getURI(), (VitroRequest)vreq));
            EditConfigurationVTwo editConfigurationVTwo = editConfiguration;
            return editConfigurationVTwo;
        }
    }

    protected EditConfigurationVTwo doAddNew(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate("addEditorshipToPerson.ftl");
        conf.setVarNameForSubject("person");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("editorship");
        conf.setN3Required(Arrays.asList(n3ForNewEditorship));
        conf.setN3Optional(Arrays.asList(n3ForNewDocumentAssertion, n3ForExistingDocumentAssertion));
        conf.addNewResource("editorship", "");
        conf.addNewResource("newDocument", "");
        conf.setUrisOnform(Arrays.asList("existingDocument", "documentType"));
        conf.setLiteralsOnForm(Arrays.asList("documentLabel", "documentLabelDisplay"));
        conf.addSparqlForExistingLiteral("documentLabel", documentLabelQuery);
        conf.addSparqlForExistingUris("documentType", documentTypeQuery);
        conf.addSparqlForExistingUris("existingDocument", existingDocumentQuery);
        conf.addField(new FieldVTwo().setName("documentType").setValidators(AddEditorshipToPersonGenerator.list((Object[])new Object[]{"nonempty"})).setOptions(this.getDocumentTypeLiteralOptions(vreq)));
        conf.addField(new FieldVTwo().setName("documentLabel").setRangeDatatypeUri(RDF.dtLangString.getURI()).setValidators(AddEditorshipToPersonGenerator.list((Object[])new Object[]{"datatype:" + RDF.dtLangString.getURI()})));
        conf.addField(new FieldVTwo().setName("documentLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        this.addFormSpecificData(conf, vreq);
        this.prepare(vreq, conf);
        return conf;
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, String> formSpecificData = new HashMap<String, String>();
        formSpecificData.put("editMode", this.getEditMode(vreq).name().toLowerCase());
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq) {
        ArrayList<String> predicates = new ArrayList<String>();
        predicates.add("http://vivoweb.org/ontology/core#relates");
        return EditModeUtils.getEditMode((VitroRequest)vreq, predicates);
    }

    private EditConfigurationVTwo doBadEditorshipMultiplePubs(VitroRequest vreq) {
        return null;
    }

    private EditConfigurationVTwo doBadEditorshipNoPub(VitroRequest vreq) {
        return null;
    }

    private FieldOptions getDocumentTypeLiteralOptions(VitroRequest vreq) throws Exception {
        return GeneratorUtil.buildResourceAndLabelFieldOptions(vreq.getRDFService(), vreq.getWebappDaoFactory(), "", I18n.bundle((HttpServletRequest)vreq).text("select_type", new Object[0]), "http://purl.org/ontology/bibo/Book", "http://purl.org/ontology/bibo/Chapter", "http://purl.org/ontology/bibo/EditedBook", "http://purl.org/ontology/bibo/Film", "http://purl.org/ontology/bibo/Magazine", "http://vivoweb.org/ontology/core#Newsletter", "http://purl.org/ontology/bibo/Newspaper", "http://vivoweb.org/ontology/core#NewsRelease", "http://purl.org/ontology/bibo/Report", "http://vivoweb.org/ontology/core#Video", "http://purl.org/ontology/bibo/Webpage", "http://purl.org/ontology/bibo/Website");
    }
}

