/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.AutocompleteRequiredInputValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.PersonHasPublicationValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.GeneratorUtil;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import edu.cornell.mannlib.vitro.webapp.utils.generators.EditModeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.resultset.ResultSetMem;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class AddPublicationToPersonGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String collectionClass = "http://purl.org/ontology/bibo/Journal";
    static final String bookClass = "http://purl.org/ontology/bibo/Book";
    static final String documentClass = "http://purl.obolibrary.org/obo/IAO_0000030";
    static final String conferenceClass = "http://purl.org/ontology/bibo/Conference";
    static final String editorClass = "http://xmlns.com/foaf/0.1/Person";
    static final String publisherClass = "http://vivoweb.org/ontology/core#Publisher";
    static final String presentedAtPred = "http://purl.org/ontology/bibo/presentedAt";
    static final String localePred = "http://vivoweb.org/ontology/core#placeOfPublication";
    static final String volumePred = "http://purl.org/ontology/bibo/volume";
    static final String numberPred = "http://purl.org/ontology/bibo/number";
    static final String issuePred = "http://purl.org/ontology/bibo/issue";
    static final String chapterNbrPred = "http://purl.org/ontology/bibo/chapter";
    static final String startPagePred = "http://purl.org/ontology/bibo/pageStart";
    static final String endPagePred = "http://purl.org/ontology/bibo/pageEnd";
    static final String dateTimePred = "http://vivoweb.org/ontology/core#dateTimeValue";
    static final String dateTimeValueType = "http://vivoweb.org/ontology/core#DateTimeValue";
    static final String dateTimeValue = "http://vivoweb.org/ontology/core#dateTime";
    static final String dateTimePrecision = "http://vivoweb.org/ontology/core#dateTimePrecision";
    static final String relatesPred = "http://vivoweb.org/ontology/core#relates";
    private final String langStringDatatypeUri = RDF.dtLangString.getURI();

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        if (EditConfigurationUtils.getObjectUri((VitroRequest)vreq) == null) {
            return this.doAddNew(vreq, session);
        }
        return this.doSkipToPublication(vreq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditConfigurationVTwo doSkipToPublication(VitroRequest vreq) {
        Individual authorshipNode = EditConfigurationUtils.getObjectIndividual((VitroRequest)vreq);
        String pubQueryStr = "SELECT ?obj \nWHERE { <" + authorshipNode.getURI() + "> <" + relatesPred + "> ?obj . \n    ?obj a <" + documentClass + "> . } \n";
        Query pubQuery = QueryFactory.create((String)pubQueryStr);
        try (QueryExecution qe = QueryExecutionFactory.create((Query)pubQuery, (Model)ModelAccess.on((HttpServletRequest)vreq).getOntModel(new ModelAccess.LanguageOption[0]));){
            ResultSetMem rs = new ResultSetMem(qe.execSelect());
            if (!rs.hasNext()) {
                EditConfigurationVTwo editConfigurationVTwo = this.doBadAuthorshipNoPub(vreq);
                return editConfigurationVTwo;
            }
            if (rs.size() > 1) {
                EditConfigurationVTwo editConfigurationVTwo = this.doBadAuthorshipMultiplePubs(vreq);
                return editConfigurationVTwo;
            }
            RDFNode objNode = rs.next().get("obj");
            if (!objNode.isResource() || objNode.isAnon()) {
                EditConfigurationVTwo editConfigurationVTwo = this.doBadAuthorshipNoPub(vreq);
                return editConfigurationVTwo;
            }
            EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
            editConfiguration.setSkipToUrl(UrlBuilder.getIndividualProfileUrl((String)((Resource)objNode).getURI(), (VitroRequest)vreq));
            EditConfigurationVTwo editConfigurationVTwo = editConfiguration;
            return editConfigurationVTwo;
        }
    }

    protected EditConfigurationVTwo doAddNew(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initBasics(editConfiguration, vreq);
        this.initPropertyParameters(vreq, session, editConfiguration);
        this.initObjectPropForm(editConfiguration, vreq);
        this.setVarNames(editConfiguration);
        editConfiguration.setN3Required(this.generateN3Required());
        editConfiguration.setN3Optional(this.generateN3Optional());
        editConfiguration.setNewResources(this.generateNewResources(vreq));
        this.setUrisAndLiteralsInScope(editConfiguration, vreq);
        this.setUrisAndLiteralsOnForm(editConfiguration, vreq);
        this.setSparqlQueries(editConfiguration, vreq);
        this.setFields(editConfiguration, vreq);
        editConfiguration.setTemplate("addPublicationToPerson.ftl");
        editConfiguration.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        editConfiguration.addValidator((N3ValidatorVTwo)new AutocompleteRequiredInputValidator("pubUri", "title"));
        editConfiguration.addValidator((N3ValidatorVTwo)new PersonHasPublicationValidator());
        this.addFormSpecificData(editConfiguration, vreq);
        this.prepare(vreq, editConfiguration);
        return editConfiguration;
    }

    private EditConfigurationVTwo doBadAuthorshipMultiplePubs(VitroRequest vreq) {
        return null;
    }

    private EditConfigurationVTwo doBadAuthorshipNoPub(VitroRequest vreq) {
        return null;
    }

    private void setVarNames(EditConfigurationVTwo editConfiguration) {
        editConfiguration.setVarNameForSubject("person");
        editConfiguration.setVarNameForPredicate("predicate");
        editConfiguration.setVarNameForObject("authorshipUri");
    }

    private List<String> generateN3Optional() {
        return AddPublicationToPersonGenerator.list((Object[])new Object[]{this.getN3ForNewPub(), this.getN3ForExistingPub(), this.getN3ForNewCollection(), this.getN3ForNewBook(), this.getN3ForNewConference(), this.getN3ForNewEvent(), this.getN3ForNewEditor(), this.getN3ForNewPublisher(), this.getN3ForNewCollectionNewPub(), this.getN3ForNewBookNewPub(), this.getN3ForNewConferenceNewPub(), this.getN3ForNewEventNewPub(), this.getN3ForNewEditorNewPub(), this.getN3ForNewPublisherNewPub(), this.getN3ForCollection(), this.getN3ForBook(), this.getN3ForConference(), this.getN3ForEvent(), this.getN3ForEditor(), this.getN3ForPublisher(), this.getN3ForCollectionNewPub(), this.getN3ForBookNewPub(), this.getN3ForConferenceNewPub(), this.getN3ForEventNewPub(), this.getN3ForEditorNewPub(), this.getN3ForPublisherNewPub(), this.getN3FirstNameAssertion(), this.getN3LastNameAssertion(), this.getN3ForLocaleAssertion(), this.getN3ForVolumeAssertion(), this.getN3ForNumberAssertion(), this.getN3ForIssueAssertion(), this.getN3ForChapterNbrAssertion(), this.getN3ForStartPageAssertion(), this.getN3ForEndPageAssertion(), this.getN3ForDateTimeAssertion(), this.getN3ForNewBookNewEditor(), this.getN3ForNewBookEditor(), this.getN3ForNewBookNewPublisher(), this.getN3ForNewBookPublisher(), this.getN3ForNewBookVolume(), this.getN3ForNewBookLocale(), this.getN3ForNewBookPubDate()});
    }

    private List<String> generateN3Required() {
        return AddPublicationToPersonGenerator.list((Object[])new Object[]{this.getAuthorshipN3()});
    }

    private String getAuthorshipN3() {
        return "@prefix core: <http://vivoweb.org/ontology/core#> . ?authorshipUri a core:Authorship ;core:relates ?person .?person core:relatedBy ?authorshipUri .";
    }

    private String getN3ForNewPub() {
        return "@prefix core: <http://vivoweb.org/ontology/core#> .?newPublication a ?pubType .?newPublication <http://www.w3.org/2000/01/rdf-schema#label> ?title .?authorshipUri core:relates ?newPublication .?newPublication core:relatedBy ?authorshipUri .";
    }

    private String getN3ForExistingPub() {
        return "@prefix core: <http://vivoweb.org/ontology/core#> .?authorshipUri core:relates ?pubUri .?pubUri core:relatedBy ?authorshipUri .";
    }

    private String getN3ForNewCollectionNewPub() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication vivo:hasPublicationVenue ?newCollection . \n?newCollection a <http://purl.org/ontology/bibo/Journal> . \n?newCollection vivo:publicationVenueFor ?newPublication . \n?newCollection <http://www.w3.org/2000/01/rdf-schema#label> ?collection .";
    }

    private String getN3ForNewCollection() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?pubUri vivo:hasPublicationVenue ?newCollection . \n?newCollection a <http://purl.org/ontology/bibo/Journal>  . \n?newCollection vivo:publicationVenueFor ?pubUri . \n?newCollection <http://www.w3.org/2000/01/rdf-schema#label> ?collection .";
    }

    private String getN3ForCollectionNewPub() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication vivo:hasPublicationVenue ?collectionUri . \n?collectionUri vivo:publicationVenueFor ?newPublication . ";
    }

    private String getN3ForCollection() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?pubUri vivo:hasPublicationVenue ?collectionUri . \n?collectionUri vivo:publicationVenueFor ?pubUri . ";
    }

    private String getN3ForNewBook() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?pubUri vivo:hasPublicationVenue ?newBook . \n?newBook a <http://purl.org/ontology/bibo/Book>  . \n?newBook vivo:publicationVenueFor ?pubUri . \n ?newBook <http://www.w3.org/2000/01/rdf-schema#label> ?book .";
    }

    private String getN3ForBook() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?pubUri vivo:hasPublicationVenue ?bookUri . \n?bookUri vivo:publicationVenueFor ?pubUri . ";
    }

    private String getN3ForNewBookNewPub() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication vivo:hasPublicationVenue ?newBook . \n?newBook a <http://purl.org/ontology/bibo/Book>  . \n?newBook vivo:publicationVenueFor ?newPublication . \n ?newBook <http://www.w3.org/2000/01/rdf-schema#label> ?book . ";
    }

    private String getN3ForNewBookVolume() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newBook <http://purl.org/ontology/bibo/volume> ?volume . ";
    }

    private String getN3ForNewBookLocale() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newBook <http://vivoweb.org/ontology/core#placeOfPublication> ?locale . ";
    }

    private String getN3ForNewBookPubDate() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newBook <http://vivoweb.org/ontology/core#dateTimeValue> ?dateTimeNode . \n?dateTimeNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n?dateTimeNode <http://vivoweb.org/ontology/core#dateTime> ?dateTime-value . \n?dateTimeNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?dateTime-precision .";
    }

    private String getN3ForNewBookNewEditor() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newBook vivo:relatedBy ?editorship . \n?editorship vivo:relates ?newBook . \n?newBook <http://www.w3.org/2000/01/rdf-schema#label> ?book . \n ?editorship a vivo:Editorship . \n?editorship vivo:relates ?newEditor . \n?newEditor a <http://xmlns.com/foaf/0.1/Person>  . \n?newEditor vivo:relatedBy ?editorship . \n?newEditor <http://www.w3.org/2000/01/rdf-schema#label> ?editor .";
    }

    private String getN3ForNewBookEditor() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newBook vivo:relatedBy ?editorship . \n?editorship vivo:relates ?newBook . \n?newBook <http://www.w3.org/2000/01/rdf-schema#label> ?book . \n ?editorship a vivo:Editorship . \n?editorship vivo:relates ?editorUri . \n?editorUri vivo:relatedBy ?editorship . ";
    }

    private String getN3ForNewBookNewPublisher() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newBook vivo:publisher ?newPublisher . \n ?newPublisher vivo:publisherOf ?newBook . \n?newPublisher <http://www.w3.org/2000/01/rdf-schema#label> ?publisher .";
    }

    private String getN3ForNewBookPublisher() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newBook vivo:publisher ?publisherUri . \n?publisherUri vivo:publisherOf ?newBook . ";
    }

    private String getN3ForBookNewPub() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication vivo:hasPublicationVenue ?bookUri . \n?bookUri vivo:publicationVenueFor ?newPublication . ";
    }

    private String getN3ForNewConference() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?pubUri <http://purl.org/ontology/bibo/presentedAt> ?newConference . \n?newConference a <http://purl.org/ontology/bibo/Conference>  . \n?newConference <http://purl.obolibrary.org/obo/BFO_0000051> ?pubUri . \n?newConference <http://www.w3.org/2000/01/rdf-schema#label> ?conference .";
    }

    private String getN3ForConference() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?pubUri <http://purl.org/ontology/bibo/presentedAt> ?conferenceUri . \n?conferenceUri <http://purl.obolibrary.org/obo/BFO_0000051> ?pubUri . ";
    }

    private String getN3ForNewConferenceNewPub() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication <http://purl.org/ontology/bibo/presentedAt> ?newConference . \n?newConference a <http://purl.org/ontology/bibo/Conference>  . \n?newConference <http://purl.obolibrary.org/obo/BFO_0000051> ?newPublication . \n?newConference <http://www.w3.org/2000/01/rdf-schema#label> ?conference .";
    }

    private String getN3ForConferenceNewPub() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication <http://purl.org/ontology/bibo/presentedAt> ?conferenceUri . \n?conferenceUri <http://purl.obolibrary.org/obo/BFO_0000051> ?newPublication . ";
    }

    private String getN3ForNewEvent() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?pubUri vivo:proceedingsOf ?newEvent . \n?newEvent a <http://purl.org/ontology/bibo/Conference>  . \n?newEvent vivo:hasProceedings ?pubUri . \n?newEvent <http://www.w3.org/2000/01/rdf-schema#label> ?event .";
    }

    private String getN3ForEvent() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?pubUri vivo:proceedingsOf ?eventUri . \n?eventUri vivo:hasProceedings ?pubUri . ";
    }

    private String getN3ForNewEventNewPub() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication vivo:proceedingsOf ?newEvent . \n?newEvent a <http://purl.org/ontology/bibo/Conference>  . \n?newEvent vivo:hasProceedings ?newPublication . \n?newEvent <http://www.w3.org/2000/01/rdf-schema#label> ?event .";
    }

    private String getN3ForEventNewPub() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication vivo:proceedingsOf ?eventUri . \n?eventUri vivo:hasProceedings ?newPublication . ";
    }

    private String getN3ForNewEditor() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?pubUri vivo:relatedBy ?editorship . \n?editorship vivo:relates ?pubUri . \n?editorship a vivo:Editorship . \n?editorship vivo:relates ?newEditor . \n?newEditor a <http://xmlns.com/foaf/0.1/Person>  . \n?newEditor vivo:relatedBy ?editorship . \n?newEditor <http://www.w3.org/2000/01/rdf-schema#label> ?editor .";
    }

    private String getN3ForEditor() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?pubUri vivo:relatedBy ?editorship . \n?editorship vivo:relates ?pubUri . \n?editorship a vivo:Editorship . \n?editorship vivo:relates ?editorUri . \n?editorUri vivo:relatedBy ?editorship . ";
    }

    private String getN3ForNewEditorNewPub() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication vivo:relatedBy ?editorship . \n?editorship vivo:relates ?newPublication . \n?newPublication <http://www.w3.org/2000/01/rdf-schema#label> ?title .?editorship a vivo:Editorship . \n?editorship vivo:relates ?newEditor . \n?newEditor a <http://xmlns.com/foaf/0.1/Person>  . \n?newEditor vivo:relatedBy ?editorship . \n?newEditor <http://www.w3.org/2000/01/rdf-schema#label> ?editor .";
    }

    private String getN3ForEditorNewPub() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication vivo:relatedBy ?editorship . \n?editorship vivo:relates ?newPublication . \n?newPublication <http://www.w3.org/2000/01/rdf-schema#label> ?title .?editorship vivo:relates ?editorUri . \n?editorship a vivo:Editorship . \n?editorUri vivo:relatedBy ?editorship . ";
    }

    private String getN3ForNewPublisher() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?pubUri vivo:publisher ?newPublisher . \n?newPublisher a <http://vivoweb.org/ontology/core#Publisher>  . \n?newPublisher vivo:publisherOf ?pubUri . \n?newPublisher <http://www.w3.org/2000/01/rdf-schema#label> ?publisher .";
    }

    private String getN3ForPublisher() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?pubUri vivo:publisher ?publisherUri . \n?publisherUri vivo:publisherOf ?pubUri . ";
    }

    private String getN3ForNewPublisherNewPub() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication vivo:publisher ?newPublisher . \n?newPublisher a <http://vivoweb.org/ontology/core#Publisher>  . \n?newPublisher vivo:publisherOf ?newPublication . \n?newPublisher <http://www.w3.org/2000/01/rdf-schema#label> ?publisher .";
    }

    private String getN3ForPublisherNewPub() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication vivo:publisher ?publisherUri . \n?publisherUri vivo:publisherOf ?newPublication . ";
    }

    private String getN3FirstNameAssertion() {
        return "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newEditor <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardEditor . \n?vcardEditor <http://purl.obolibrary.org/obo/ARG_2000029>  ?newEditor . \n?vcardEditor a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardEditor vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:givenName ?firstName .";
    }

    private String getN3LastNameAssertion() {
        return "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newEditor <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardEditor . \n?vcardEditor <http://purl.obolibrary.org/obo/ARG_2000029>  ?newEditor . \n?vcardEditor a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardEditor vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:familyName ?lastName .";
    }

    private String getN3ForLocaleAssertion() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication <http://vivoweb.org/ontology/core#placeOfPublication> ?locale .  ";
    }

    private String getN3ForVolumeAssertion() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication <http://purl.org/ontology/bibo/volume> ?volume .  ";
    }

    private String getN3ForNumberAssertion() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication <http://purl.org/ontology/bibo/number> ?number .  ";
    }

    private String getN3ForIssueAssertion() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication <http://purl.org/ontology/bibo/issue> ?issue .  ";
    }

    private String getN3ForChapterNbrAssertion() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication <http://purl.org/ontology/bibo/chapter> ?chapterNbr .  ";
    }

    private String getN3ForStartPageAssertion() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication <http://purl.org/ontology/bibo/pageStart> ?startPage . ";
    }

    private String getN3ForEndPageAssertion() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication <http://purl.org/ontology/bibo/pageEnd>?endPage . ";
    }

    private String getN3ForDateTimeAssertion() {
        return "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?newPublication <http://vivoweb.org/ontology/core#dateTimeValue> ?dateTimeNode . \n?dateTimeNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n?dateTimeNode <http://vivoweb.org/ontology/core#dateTime> ?dateTime-value . \n?dateTimeNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?dateTime-precision . ";
    }

    private Map<String, String> generateNewResources(VitroRequest vreq) {
        Object DEFAULT_NS_TOKEN = null;
        HashMap<String, String> newResources = new HashMap<String, String>();
        newResources.put("authorshipUri", (String)DEFAULT_NS_TOKEN);
        newResources.put("newPublication", (String)DEFAULT_NS_TOKEN);
        newResources.put("newCollection", (String)DEFAULT_NS_TOKEN);
        newResources.put("newBook", (String)DEFAULT_NS_TOKEN);
        newResources.put("newConference", (String)DEFAULT_NS_TOKEN);
        newResources.put("newEvent", (String)DEFAULT_NS_TOKEN);
        newResources.put("newEditor", (String)DEFAULT_NS_TOKEN);
        newResources.put("editorship", (String)DEFAULT_NS_TOKEN);
        newResources.put("vcardEditor", (String)DEFAULT_NS_TOKEN);
        newResources.put("vcardName", (String)DEFAULT_NS_TOKEN);
        newResources.put("newPublisher", (String)DEFAULT_NS_TOKEN);
        newResources.put("dateTimeNode", (String)DEFAULT_NS_TOKEN);
        return newResources;
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
        urisInScope.put(editConfiguration.getVarNameForSubject(), Arrays.asList(editConfiguration.getSubjectUri()));
        urisInScope.put(editConfiguration.getVarNameForPredicate(), Arrays.asList(editConfiguration.getPredicateUri()));
        editConfiguration.setUrisInScope(urisInScope);
        HashMap literalsInScope = new HashMap();
        editConfiguration.setLiteralsInScope(literalsInScope);
    }

    private void setUrisAndLiteralsOnForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        urisOnForm.add("pubType");
        urisOnForm.add("pubUri");
        urisOnForm.add("collectionUri");
        urisOnForm.add("bookUri");
        urisOnForm.add("conferenceUri");
        urisOnForm.add("eventUri");
        urisOnForm.add("editorUri");
        urisOnForm.add("publisherUri");
        editConfiguration.setUrisOnform(urisOnForm);
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        literalsOnForm.add("title");
        literalsOnForm.add("collection");
        literalsOnForm.add("book");
        literalsOnForm.add("conference");
        literalsOnForm.add("event");
        literalsOnForm.add("editor");
        literalsOnForm.add("publisher");
        literalsOnForm.add("collectionDisplay");
        literalsOnForm.add("bookDisplay");
        literalsOnForm.add("conferenceDisplay");
        literalsOnForm.add("eventDisplay");
        literalsOnForm.add("editorDisplay");
        literalsOnForm.add("publisherDisplay");
        literalsOnForm.add("locale");
        literalsOnForm.add("volume");
        literalsOnForm.add("number");
        literalsOnForm.add("issue");
        literalsOnForm.add("chapterNbr");
        literalsOnForm.add("startPage");
        literalsOnForm.add("endPage");
        literalsOnForm.add("firstName");
        literalsOnForm.add("lastName");
        editConfiguration.setLiteralsOnForm(literalsOnForm);
    }

    private void setSparqlQueries(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setSparqlForExistingUris(new HashMap());
        editConfiguration.setSparqlForAdditionalLiteralsInScope(new HashMap());
        editConfiguration.setSparqlForAdditionalUrisInScope(new HashMap());
        editConfiguration.setSparqlForExistingLiterals(new HashMap());
    }

    private void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq) throws Exception {
        this.setTitleField(editConfiguration);
        this.setPubTypeField(editConfiguration, vreq);
        this.setPubUriField(editConfiguration);
        this.setCollectionLabelField(editConfiguration);
        this.setCollectionDisplayField(editConfiguration);
        this.setCollectionUriField(editConfiguration);
        this.setBookLabelField(editConfiguration);
        this.setBookDisplayField(editConfiguration);
        this.setBookUriField(editConfiguration);
        this.setConferenceLabelField(editConfiguration);
        this.setConferenceDisplayField(editConfiguration);
        this.setConferenceUriField(editConfiguration);
        this.setEventLabelField(editConfiguration);
        this.setEventDisplayField(editConfiguration);
        this.setEventUriField(editConfiguration);
        this.setEditorLabelField(editConfiguration);
        this.setEditorDisplayField(editConfiguration);
        this.setFirstNameField(editConfiguration);
        this.setLastNameField(editConfiguration);
        this.setEditorUriField(editConfiguration);
        this.setPublisherLabelField(editConfiguration);
        this.setPublisherDisplayField(editConfiguration);
        this.setPublisherUriField(editConfiguration);
        this.setLocaleField(editConfiguration);
        this.setVolumeField(editConfiguration);
        this.setNumberField(editConfiguration);
        this.setIssueField(editConfiguration);
        this.setChapterNbrField(editConfiguration);
        this.setStartPageField(editConfiguration);
        this.setEndPageField(editConfiguration);
        this.setDateTimeField(editConfiguration);
    }

    private void setTitleField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("title").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setPubTypeField(EditConfigurationVTwo editConfiguration, VitroRequest vreq) throws Exception {
        editConfiguration.addField(new FieldVTwo().setName("pubType").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"nonempty"})).setOptions(this.getPublicationTypeLiteralOptions(vreq)));
    }

    private void setPubUriField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("pubUri"));
    }

    private void setCollectionLabelField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("collection").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setCollectionDisplayField(EditConfigurationVTwo editConfiguration) {
        String stringDatatypeUri = XSD.xstring.toString();
        editConfiguration.addField(new FieldVTwo().setName("collectionDisplay").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + stringDatatypeUri})).setRangeDatatypeUri(stringDatatypeUri));
    }

    private void setCollectionUriField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("collectionUri"));
    }

    private void setBookLabelField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("book").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setBookDisplayField(EditConfigurationVTwo editConfiguration) {
        String stringDatatypeUri = XSD.xstring.toString();
        editConfiguration.addField(new FieldVTwo().setName("bookDisplay").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + stringDatatypeUri})).setRangeDatatypeUri(stringDatatypeUri));
    }

    private void setBookUriField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("bookUri"));
    }

    private void setConferenceLabelField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("conference").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setConferenceDisplayField(EditConfigurationVTwo editConfiguration) {
        String stringDatatypeUri = XSD.xstring.toString();
        editConfiguration.addField(new FieldVTwo().setName("conferenceDisplay").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + stringDatatypeUri})).setRangeDatatypeUri(stringDatatypeUri));
    }

    private void setConferenceUriField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("conferenceUri"));
    }

    private void setEventLabelField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("event").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setEventDisplayField(EditConfigurationVTwo editConfiguration) {
        String stringDatatypeUri = XSD.xstring.toString();
        editConfiguration.addField(new FieldVTwo().setName("eventDisplay").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + stringDatatypeUri})).setRangeDatatypeUri(stringDatatypeUri));
    }

    private void setFirstNameField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("firstName").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setLastNameField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("lastName").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setEventUriField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("eventUri"));
    }

    private void setEditorLabelField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("editor").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setEditorDisplayField(EditConfigurationVTwo editConfiguration) {
        String stringDatatypeUri = XSD.xstring.toString();
        editConfiguration.addField(new FieldVTwo().setName("editorDisplay").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + stringDatatypeUri})).setRangeDatatypeUri(stringDatatypeUri));
    }

    private void setEditorUriField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("editorUri"));
    }

    private void setPublisherLabelField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("publisher").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setPublisherDisplayField(EditConfigurationVTwo editConfiguration) {
        String stringDatatypeUri = XSD.xstring.toString();
        editConfiguration.addField(new FieldVTwo().setName("publisherDisplay").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + stringDatatypeUri})).setRangeDatatypeUri(stringDatatypeUri));
    }

    private void setPublisherUriField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("publisherUri"));
    }

    private void setLocaleField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("locale").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setVolumeField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("volume").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setNumberField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("number").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setIssueField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("issue").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setChapterNbrField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("chapterNbr").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setStartPageField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("startPage").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setEndPageField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("endPage").setValidators(AddPublicationToPersonGenerator.list((Object[])new Object[]{"datatype:" + this.langStringDatatypeUri})).setRangeDatatypeUri(this.langStringDatatypeUri));
    }

    private void setDateTimeField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("dateTime").setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(null, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
    }

    private FieldOptions getPublicationTypeLiteralOptions(VitroRequest vreq) throws Exception {
        return GeneratorUtil.buildResourceAndLabelFieldOptions(vreq.getRDFService(), vreq.getWebappDaoFactory(), "", I18n.bundle((HttpServletRequest)vreq).text("select_type", new Object[0]), "http://vivoweb.org/ontology/core#Abstract", "http://purl.org/ontology/bibo/AcademicArticle", "http://purl.org/ontology/bibo/Article", "http://purl.org/ontology/bibo/AudioDocument", "http://vivoweb.org/ontology/core#BlogPosting", bookClass, "http://vivoweb.org/ontology/core#CaseStudy", "http://vivoweb.org/ontology/core#Catalog", "http://purl.org/ontology/bibo/Chapter", "http://vivoweb.org/ontology/core#ConferencePaper", "http://vivoweb.org/ontology/core#ConferencePoster", "http://vivoweb.org/ontology/core#Database", "http://vivoweb.org/ontology/core#Dataset", "http://purl.org/ontology/bibo/EditedBook", "http://vivoweb.org/ontology/core#EditorialArticle", "http://purl.org/ontology/bibo/Film", "http://vivoweb.org/ontology/core#Newsletter", "http://vivoweb.org/ontology/core#NewsRelease", "http://purl.org/ontology/bibo/Patent", "http://purl.obolibrary.org/obo/OBI_0000272", "http://purl.org/ontology/bibo/Report", "http://vivoweb.org/ontology/core#ResearchProposal", "http://vivoweb.org/ontology/core#Review", "http://purl.obolibrary.org/obo/ERO_0000071 ", "http://vivoweb.org/ontology/core#Speech", "http://purl.org/ontology/bibo/Thesis", "http://vivoweb.org/ontology/core#Video", "http://purl.org/ontology/bibo/Webpage", "http://purl.org/ontology/bibo/Website", "http://vivoweb.org/ontology/core#WorkingPaper");
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, String> formSpecificData = new HashMap<String, String>();
        formSpecificData.put("editMode", this.getEditMode(vreq).name().toLowerCase());
        formSpecificData.put("sparqlForAcFilter", this.getSparqlForAcFilter(vreq));
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public String getSparqlForAcFilter(VitroRequest vreq) {
        String subject = EditConfigurationUtils.getSubjectUri((VitroRequest)vreq);
        String query = "PREFIX core:<http://vivoweb.org/ontology/core#> SELECT ?pubUri WHERE { <" + subject + "> core:relatedBy ?authorshipUri . ?authorshipUri a core:Authorship . ?authorshipUri core:relates ?pubUri . }";
        return query;
    }

    public FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq) {
        return EditModeUtils.getEditMode((VitroRequest)vreq, (List)AddPublicationToPersonGenerator.list((Object[])new Object[]{relatesPred}));
    }
}

