/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.AutocompleteRequiredInputValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import java.util.Arrays;
import javax.servlet.http.HttpSession;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class OrganizationAdministersGrantGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String n3ForNewAdminRole = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n\n?organization <http://purl.obolibrary.org/obo/RO_0000053>  ?adminRole . \n?adminRole a  vivo:AdministratorRole . \n?adminRole <http://purl.obolibrary.org/obo/RO_0000052> ?organization . ";
    static final String n3ForNewAdminGrant = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?adminRole vivo:relatedBy ?newGrant . \n?newGrant a vivo:Grant  . \n?newGrant vivo:relates ?adminRole . \n?organization vivo:relatedBy  ?newGrant . \n?newGrant vivo:relates ?organization  . \n?newGrant <http://www.w3.org/2000/01/rdf-schema#label> ?grantLabel .";
    static final String n3ForExistingAdminGrant = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n\n?adminRole vivo:relatedBy ?existingGrant . \n?existingGrant a <http://xmlns.com/foaf/0.1/Grant>  . \n?existingGrant vivo:relates ?adminRole . \n?organization vivo:relatedBy  ?newGrant . \n?newGrant vivo:relates ?organization  . ";
    static final String existingGrantQuery = "PREFIX vivo: <http://vivoweb.org/ontology/core#>  \nSELECT ?existingGrant WHERE { \n ?adminRole vivo:relatedBy ?existingGrant . \n ?existingGrant a vivo:Grant . \n}";
    static final String grantLabelQuery = "PREFIX vivo: <http://vivoweb.org/ontology/core#> \nSELECT ?existingGrantLabel WHERE { \n ?adminRole vivo:relatedBy ?existingGrant . \n ?existingGrant a vivo:Grant . \n ?existingGrant <http://www.w3.org/2000/01/rdf-schema#label> ?existingGrantLabel . \n}";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate("organizationAdministersGrant.ftl");
        conf.setVarNameForSubject("organization");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("adminRole");
        conf.setN3Required(Arrays.asList(n3ForNewAdminRole));
        conf.setN3Optional(Arrays.asList(n3ForNewAdminGrant, n3ForExistingAdminGrant));
        conf.addNewResource("newGrant", "");
        conf.addNewResource("adminRole", "");
        conf.setUrisOnform(Arrays.asList("existingGrant"));
        conf.setLiteralsOnForm(Arrays.asList("grantLabel", "grantLabelDisplay"));
        conf.addSparqlForExistingLiteral("grantLabel", grantLabelQuery);
        conf.addSparqlForExistingUris("existingGrant", existingGrantQuery);
        conf.addField(new FieldVTwo().setName("existingGrant"));
        conf.addField(new FieldVTwo().setName("grantLabel").setRangeDatatypeUri(RDF.dtLangString.getURI()).setValidators(OrganizationAdministersGrantGenerator.list((Object[])new Object[]{"datatype:" + RDF.dtLangString.getURI()})));
        conf.addField(new FieldVTwo().setName("grantLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(OrganizationAdministersGrantGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        conf.addValidator((N3ValidatorVTwo)new AutocompleteRequiredInputValidator("existingGrant", "grantLabel"));
        this.prepare(vreq, conf);
        return conf;
    }
}

