/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;

public class SubjectHasMailingAddressGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String n3ForNewAddress = "?subject <http://purl.obolibrary.org/obo/ARG_2000028>  ?individualVcard . \n?individualVcard a <http://www.w3.org/2006/vcard/ns#Individual> . \n?individualVcard <http://purl.obolibrary.org/obo/ARG_2000029> ?subject . \n?individualVcard <http://www.w3.org/2006/vcard/ns#hasAddress> ?address . \n?address a <http://www.w3.org/2006/vcard/ns#Address> . ";
    static final String streetAddressAssertion = "?address <http://www.w3.org/2006/vcard/ns#streetAddress> ?streetAddress .";
    static final String localityAssertion = "?address <http://www.w3.org/2006/vcard/ns#locality> ?locality .";
    static final String postalCodeAssertion = "?address <http://www.w3.org/2006/vcard/ns#postalCode> ?postalCode .";
    static final String regionAssertion = "?address <http://www.w3.org/2006/vcard/ns#region> ?region .";
    static final String countryAssertion = "?address <http://www.w3.org/2006/vcard/ns#country> ?country .";
    static final String individualVcardQuery = "SELECT ?individualVcard WHERE { \n?subject <http://purl.obolibrary.org/obo/ARG_2000028>  ?individualVcard . \n}";
    static final String streetAddressQuery = "SELECT ?existingStreetAddress WHERE {\n?address <http://www.w3.org/2006/vcard/ns#streetAddress> ?existingStreetAddress . }";
    static final String localityQuery = "SELECT ?existingLocality WHERE {\n?address <http://www.w3.org/2006/vcard/ns#locality> ?existingLocality . }";
    static final String regionQuery = "SELECT ?existingRegion WHERE {\n?address <http://www.w3.org/2006/vcard/ns#region> ?existingRegion . }";
    static final String postalCodeQuery = "SELECT ?existingPostalCode WHERE {\n?address <http://www.w3.org/2006/vcard/ns#postalCode> ?existingPostalCode . }";
    static final String countryQuery = "SELECT ?existingCountry WHERE {\n?address <http://www.w3.org/2006/vcard/ns#country> ?existingCountry . }";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        String addressUri = vreq.getParameter("addressUri");
        conf.setTemplate("subjectHasMailingAddress.ftl");
        conf.setVarNameForSubject("subject");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("individualVcard");
        conf.setN3Required(Arrays.asList(n3ForNewAddress));
        conf.setN3Optional(Arrays.asList(streetAddressAssertion, localityAssertion, regionAssertion, countryAssertion, postalCodeAssertion));
        conf.addNewResource("address", "");
        conf.addNewResource("individualVcard", "");
        conf.setLiteralsOnForm(Arrays.asList("streetAddress", "locality", "postalCode", "country", "region"));
        conf.addSparqlForExistingLiteral("streetAddress", streetAddressQuery);
        conf.addSparqlForExistingLiteral("locality", localityQuery);
        conf.addSparqlForExistingLiteral("postalCode", postalCodeQuery);
        conf.addSparqlForExistingLiteral("region", regionQuery);
        conf.addSparqlForExistingLiteral("country", countryQuery);
        if (conf.isUpdate()) {
            HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
            urisInScope.put("address", Arrays.asList(addressUri));
            conf.addUrisInScope(urisInScope);
        } else {
            conf.addSparqlForAdditionalUrisInScope("individualVcard", individualVcardQuery);
        }
        conf.addField(new FieldVTwo().setName("streetAddress").setRangeDatatypeUri(RDF.dtLangString.getURI()).setValidators(SubjectHasMailingAddressGenerator.list((Object[])new Object[]{"nonempty"})));
        conf.addField(new FieldVTwo().setName("country").setRangeDatatypeUri(RDF.dtLangString.getURI()).setValidators(SubjectHasMailingAddressGenerator.list((Object[])new Object[]{"nonempty"})));
        conf.addField(new FieldVTwo().setName("postalCode").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(SubjectHasMailingAddressGenerator.list((Object[])new Object[]{"nonempty"})));
        conf.addField(new FieldVTwo().setName("locality").setRangeDatatypeUri(RDF.dtLangString.getURI()).setValidators(SubjectHasMailingAddressGenerator.list((Object[])new Object[]{"nonempty"})));
        conf.addField(new FieldVTwo().setName("region").setRangeDatatypeUri(RDF.dtLangString.getURI()).setValidators(SubjectHasMailingAddressGenerator.list((Object[])new Object[]{"datatype:" + RDF.dtLangString.getURI()})));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        this.prepare(vreq, conf);
        return conf;
    }
}

