/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.ApplicationDao;
import edu.cornell.mannlib.vitro.webapp.search.controller.PagedSearchController;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="FedSearchController", urlPatterns={"/FS.xml", "/ctsasearch"})
public class FedSearchController
extends PagedSearchController {
    private static final Log log = LogFactory.getLog(FedSearchController.class);
    private String classgroup;
    private String populationType;

    private String getClassgroup(HttpServletRequest req) {
        if (this.classgroup == null) {
            ConfigurationProperties configuration = ConfigurationProperties.getBean((ServletContext)req.getSession().getServletContext());
            this.classgroup = configuration.getProperty("ctsa.classgroup", "http://vivoweb.org/ontology#vitroClassGrouppeople");
        }
        return this.classgroup;
    }

    private String getPopulationType(HttpServletRequest req) {
        if (this.populationType == null) {
            ConfigurationProperties configuration = ConfigurationProperties.getBean((ServletContext)req.getSession().getServletContext());
            this.populationType = configuration.getProperty("ctsa.classgroup.type", "faculty,staff,students");
        }
        return this.populationType;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringBuffer url = request.getRequestURL();
        String uri = request.getRequestURI();
        String serverBase = url.substring(0, url.indexOf(uri));
        if (request.getRequestURI().contains("FS.xml")) {
            try {
                VitroRequest vreq = new VitroRequest(request);
                HashMap<String, String> body = new HashMap<String, String>();
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/xml;charset=UTF-8");
                response.setHeader("Content-Disposition", "attachment; filename=FS.xml");
                ApplicationDao aDao = vreq.getUnfilteredWebappDaoFactory().getApplicationDao();
                ApplicationBean applicationForEditing = aDao.getApplicationBean();
                body.put("ApplicationName", applicationForEditing.getApplicationName());
                body.put("serverBase", serverBase);
                this.writeTemplate("search-fs.ftl", body, request, response);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        } else {
            try {
                TreeMap<String, String[]> additionalParams = new TreeMap<String, String[]>();
                String classgroup = this.getClassgroup(request);
                additionalParams.put("classgroup", new String[]{classgroup});
                VitroRequest vreq = new VitroRequest((HttpServletRequest)new RequestWrapper(request, additionalParams));
                ResponseValues rvalues = this.processRequest(vreq);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/xml;charset=UTF-8");
                response.setHeader("Content-Disposition", "attachment; filename=search.xml");
                HashMap<String, String> body = new HashMap<String, String>();
                body.putAll(rvalues.getMap());
                body.put("populationType", this.getPopulationType(request));
                body.put("classgroup", classgroup);
                body.put("serverBase", serverBase);
                this.writeTemplate("search-fsresult.ftl", body, request, response);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    private class RequestWrapper
    extends HttpServletRequestWrapper {
        private Map<String, String[]> allParameters;

        public RequestWrapper(HttpServletRequest request, Map<String, String[]> additionalParams) {
            super(request);
            this.allParameters = null;
            this.allParameters = new TreeMap<String, String[]>();
            this.allParameters.putAll(super.getParameterMap());
            this.allParameters.putAll(additionalParams);
            this.allParameters = Collections.unmodifiableMap(this.allParameters);
        }

        public Map<String, String[]> getParameterMap() {
            return this.allParameters;
        }

        public String getParameter(String name) {
            String[] strings = this.getParameterMap().get(name);
            if (strings != null) {
                return strings[0];
            }
            return super.getParameter(name);
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.getParameterMap().keySet());
        }

        public String[] getParameterValues(String name) {
            return this.getParameterMap().get(name);
        }
    }
}

