/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifier;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

public class CalculateParameters
implements DocumentModifier,
ContextModelsUser {
    private boolean shutdown = false;
    private volatile Dataset dataset;
    private static final String prefix = "prefix owl: <http://www.w3.org/2002/07/owl#>  prefix vitroDisplay: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#>   prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>   prefix core: <http://vivoweb.org/ontology/core#>   prefix foaf: <http://xmlns.com/foaf/0.1/>  prefix rdfs:  <http://www.w3.org/2000/01/rdf-schema#>  prefix localNav: <http://vitro.mannlib.cornell.edu/ns/localnav#>   prefix obo: <http://purl.obolibrary.org/obo/>   prefix bibo: <http://purl.org/ontology/bibo/>  ";
    private static final String betaQuery = "prefix owl: <http://www.w3.org/2002/07/owl#>  prefix vitroDisplay: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#>   prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>   prefix core: <http://vivoweb.org/ontology/core#>   prefix foaf: <http://xmlns.com/foaf/0.1/>  prefix rdfs:  <http://www.w3.org/2000/01/rdf-schema#>  prefix localNav: <http://vitro.mannlib.cornell.edu/ns/localnav#>   prefix obo: <http://purl.obolibrary.org/obo/>   prefix bibo: <http://purl.org/ontology/bibo/>   SELECT count(distinct ?inLinks)  WHERE {  ?uri rdf:type owl:Thing .  ?inLinks ?prop ?uri .  } ";
    private static final String totalCountQuery = "prefix owl: <http://www.w3.org/2002/07/owl#>  prefix vitroDisplay: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#>   prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>   prefix core: <http://vivoweb.org/ontology/core#>   prefix foaf: <http://xmlns.com/foaf/0.1/>  prefix rdfs:  <http://www.w3.org/2000/01/rdf-schema#>  prefix localNav: <http://vitro.mannlib.cornell.edu/ns/localnav#>   prefix obo: <http://purl.obolibrary.org/obo/>   prefix bibo: <http://purl.org/ontology/bibo/>   SELECT count(distinct ?ind)  WHERE {  ?ind rdf:type owl:Thing .  } ";
    private static Log log = LogFactory.getLog(CalculateParameters.class);

    public void setContextModels(ContextModelAccess models) {
        this.dataset = DatasetFactory.create((Model)models.getOntModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float calculateBeta(String uri) {
        float beta = 0.0f;
        int Conn = 0;
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        QuerySolution soln = null;
        Resource uriResource = ResourceFactory.createResource((String)uri);
        initialBinding.add("uri", (RDFNode)uriResource);
        this.dataset.getLock().enterCriticalSection(true);
        QueryExecution qexec = null;
        try {
            Query query = QueryFactory.create((String)betaQuery, (Syntax)Syntax.syntaxARQ);
            qexec = QueryExecutionFactory.create((Query)query, (Dataset)this.dataset, (QuerySolution)initialBinding);
            ResultSet results = qexec.execSelect();
            List resultVars = results.getResultVars();
            if (resultVars != null && resultVars.size() != 0) {
                soln = results.next();
                Conn = Integer.parseInt(soln.getLiteral((String)resultVars.get(0)).getLexicalForm());
            }
        }
        catch (Throwable t) {
            if (!this.shutdown) {
                log.error((Object)t, t);
            }
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
            this.dataset.getLock().leaveCriticalSection();
        }
        beta = Conn;
        beta += 1.0f;
        if ((beta = (float)(1.0 / (1.0 + Math.pow(Math.E, -beta)))) > 1.0f) {
            log.info((Object)("Beta higher than 1 : " + beta));
        } else if (beta <= 0.0f) {
            log.info((Object)("Beta lower < = 0 : " + beta));
        }
        return beta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAdjacentNodes(String uri) {
        ArrayList<String> queryList = new ArrayList<String>();
        HashSet<String> adjacentNodes = new HashSet<String>();
        HashSet<String> coauthorNames = new HashSet<String>();
        String[] info = new String[]{"", ""};
        StringBuffer adjacentNodesConcat = new StringBuffer();
        StringBuffer coauthorBuff = new StringBuffer();
        adjacentNodesConcat.append("");
        coauthorBuff.append("");
        queryList.add("prefix owl: <http://www.w3.org/2002/07/owl#>  prefix vitroDisplay: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#>   prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>   prefix core: <http://vivoweb.org/ontology/core#>   prefix foaf: <http://xmlns.com/foaf/0.1/>  prefix rdfs:  <http://www.w3.org/2000/01/rdf-schema#>  prefix localNav: <http://vitro.mannlib.cornell.edu/ns/localnav#>   prefix obo: <http://purl.obolibrary.org/obo/>   prefix bibo: <http://purl.org/ontology/bibo/>   SELECT ?adjobj (str(?adjobjLabel) as ?coauthor)  WHERE {  ?uri rdf:type <http://xmlns.com/foaf/0.1/Person> .  ?uri ?prop ?obj .  ?obj rdf:type <http://vivoweb.org/ontology/core#Relationship> .  ?obj ?prop2 ?obj2 .  ?obj2 rdf:type obo:IAO_0000030 .  ?obj2 ?prop3 ?obj3 .  ?obj3 rdf:type <http://vivoweb.org/ontology/core#Relationship> .  ?obj3 ?prop4 ?adjobj .  ?adjobj rdfs:label ?adjobjLabel .  ?adjobj rdf:type <http://xmlns.com/foaf/0.1/Person> .  FILTER (?prop !=rdf:type) .  FILTER (?prop2!=rdf:type) .  FILTER (?prop3!=rdf:type) .  FILTER (?prop4!=rdf:type) .  FILTER (?adjobj != ?uri) . }");
        queryList.add("prefix owl: <http://www.w3.org/2002/07/owl#>  prefix vitroDisplay: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#>   prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>   prefix core: <http://vivoweb.org/ontology/core#>   prefix foaf: <http://xmlns.com/foaf/0.1/>  prefix rdfs:  <http://www.w3.org/2000/01/rdf-schema#>  prefix localNav: <http://vitro.mannlib.cornell.edu/ns/localnav#>   prefix obo: <http://purl.obolibrary.org/obo/>   prefix bibo: <http://purl.org/ontology/bibo/>   SELECT ?adjobj  WHERE{  ?uri rdf:type foaf:Agent .  ?uri ?prop ?obj .  ?obj ?prop2 ?adjobj .  FILTER (?prop !=rdf:type) .  FILTER isURI(?obj) .  FILTER (?prop2!=rdf:type) .  FILTER (?adjobj != ?uri) .  FILTER isURI(?adjobj) .  { ?adjobj rdf:type <http://xmlns.com/foaf/0.1/Organization> . }  UNION  { ?adjobj rdf:type <http://xmlns.com/foaf/0.1/Person> . }  UNION  { ?adjobj rdf:type obo:IAO_0000030 . }  UNION  { ?adjobj rdf:type <http://vivoweb.org/ontology/core#Location> . } .}");
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        Resource uriResource = ResourceFactory.createResource((String)uri);
        initialBinding.add("uri", (RDFNode)uriResource);
        Iterator queryItr = queryList.iterator();
        this.dataset.getLock().enterCriticalSection(true);
        Resource adjacentIndividual = null;
        RDFNode coauthor = null;
        try {
            while (queryItr.hasNext()) {
                Query query = QueryFactory.create((String)((String)queryItr.next()), (Syntax)Syntax.syntaxARQ);
                try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)this.dataset, (QuerySolution)initialBinding);){
                    ResultSet results = qexec.execSelect();
                    while (results.hasNext()) {
                        QuerySolution soln = results.nextSolution();
                        adjacentIndividual = (Resource)soln.get("adjobj");
                        if (adjacentIndividual != null) {
                            adjacentNodes.add(adjacentIndividual.getURI());
                        }
                        if ((coauthor = soln.get("coauthor")) == null) continue;
                        coauthorNames.add(" co-authors " + coauthor.toString() + " co-authors ");
                    }
                }
            }
            queryList = null;
            Iterator itr = adjacentNodes.iterator();
            while (itr.hasNext()) {
                adjacentNodesConcat.append((String)itr.next()).append(" ");
            }
            info[0] = adjacentNodesConcat.toString();
            itr = coauthorNames.iterator();
            while (itr.hasNext()) {
                coauthorBuff.append((String)itr.next());
            }
            info[1] = coauthorBuff.toString();
        }
        catch (Throwable t) {
            if (!this.shutdown) {
                log.error((Object)t, t);
            }
        }
        finally {
            this.dataset.getLock().leaveCriticalSection();
            adjacentNodes = null;
            adjacentNodesConcat = null;
            coauthorBuff = null;
        }
        return info;
    }

    public void modifyDocument(Individual individual, SearchInputDocument doc) {
        log.debug((Object)"Parameter calculation starts..");
        float beta = this.calculateBeta(individual.getURI());
        doc.addField("BETA", new Object[]{Float.valueOf(beta)});
        doc.setDocumentBoost(beta + doc.getDocumentBoost());
        log.debug((Object)"Parameter calculation is done");
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

