/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.collaborationutils;

import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaboration;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaborator;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public abstract class CollaborationData {
    private Set<Collaborator> collaborators;
    private Set<Collaboration> collaborations;
    private Collaborator egoCollaborator;
    private Set<Map<String, String>> NODE_SCHEMA;
    private Set<Map<String, String>> EDGE_SCHEMA;
    private Date builtFromCacheTime = null;

    public CollaborationData(Collaborator egoCollaborator, Set<Collaborator> collaborators, Set<Collaboration> collaborations) {
        this.egoCollaborator = egoCollaborator;
        this.collaborators = collaborators;
        this.collaborations = collaborations;
    }

    public Date getBuiltFromCacheTime() {
        return this.builtFromCacheTime;
    }

    public Set<Collaborator> getCollaborators() {
        return this.collaborators;
    }

    public Set<Collaboration> getCollaborations() {
        return this.collaborations;
    }

    public Collaborator getEgoCollaborator() {
        return this.egoCollaborator;
    }

    public Set<Map<String, String>> getNodeSchema() {
        if (this.NODE_SCHEMA == null) {
            this.NODE_SCHEMA = this.initializeNodeSchema();
        }
        return this.NODE_SCHEMA;
    }

    public Set<Map<String, String>> getEdgeSchema() {
        if (this.EDGE_SCHEMA == null) {
            this.EDGE_SCHEMA = this.initializeEdgeSchema();
        }
        return this.EDGE_SCHEMA;
    }

    public void setBuiltFromCacheTime(Date time) {
        this.builtFromCacheTime = time;
    }

    abstract Set<Map<String, String>> initializeEdgeSchema();

    abstract Set<Map<String, String>> initializeNodeSchema();
}

