/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.persongrantcount;

import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.SparklineData;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.YearToEntityCountDataElement;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;

public class PersonGrantCountVisCodeGenerator {
    private static final String DEFAULT_VIS_CONTAINER_DIV_ID = "grant_count_vis_container";
    private Map<String, Integer> yearToGrantCount;
    private Log log;
    private SparklineData sparklineParameterVO;
    private String individualURI;

    public PersonGrantCountVisCodeGenerator(String individualURIParam, String visMode, String visContainer, Map<String, Integer> yearToGrantCount, Log log) {
        this.individualURI = individualURIParam;
        this.yearToGrantCount = yearToGrantCount;
        this.log = log;
        this.sparklineParameterVO = this.setupSparklineParameters(visMode, visContainer);
    }

    private SparklineData setupSparklineParameters(String visMode, String providedVisContainerID) {
        SparklineData sparklineData = new SparklineData();
        sparklineData.setYearToActivityCount(this.yearToGrantCount);
        int numOfYearsToBeRendered = 0;
        int currentYear = Calendar.getInstance().get(1) - 1;
        int shortSparkMinYear = currentYear - 10 + 1;
        HashSet<String> grantYears = new HashSet<String>(this.yearToGrantCount.keySet());
        grantYears.remove("Unknown");
        int minGrantYear = shortSparkMinYear;
        String visContainerID = null;
        if (this.yearToGrantCount.size() > 0) {
            try {
                minGrantYear = Integer.parseInt(Collections.min(grantYears));
            }
            catch (NumberFormatException | NoSuchElementException e1) {
                this.log.debug((Object)("vis: " + e1.getMessage() + " error occurred for " + this.yearToGrantCount.toString()));
            }
        }
        int minGrantYearConsidered = 0;
        minGrantYearConsidered = minGrantYear > shortSparkMinYear ? shortSparkMinYear : minGrantYear;
        numOfYearsToBeRendered = currentYear - minGrantYearConsidered + 1;
        sparklineData.setNumOfYearsToBeRendered(numOfYearsToBeRendered);
        int grantCounter = 0;
        int renderedFullSparks = 0;
        ArrayList<YearToEntityCountDataElement> yearToGrantCountDataTable = new ArrayList<YearToEntityCountDataElement>();
        for (int grantYear = minGrantYearConsidered; grantYear <= currentYear; ++grantYear) {
            String stringInvestigatedYear = String.valueOf(grantYear);
            Integer currentGrants = this.yearToGrantCount.get(stringInvestigatedYear);
            if (currentGrants == null) {
                currentGrants = 0;
            }
            yearToGrantCountDataTable.add(new YearToEntityCountDataElement(grantCounter, stringInvestigatedYear, currentGrants));
            renderedFullSparks += currentGrants.intValue();
            ++grantCounter;
        }
        sparklineData.setYearToEntityCountDataTable(yearToGrantCountDataTable);
        sparklineData.setRenderedSparks(renderedFullSparks);
        Integer unknownYearGrants = 0;
        if (this.yearToGrantCount.get("Unknown") != null) {
            unknownYearGrants = this.yearToGrantCount.get("Unknown");
        }
        sparklineData.setUnknownYearGrants(unknownYearGrants);
        visContainerID = providedVisContainerID != null ? providedVisContainerID : DEFAULT_VIS_CONTAINER_DIV_ID;
        sparklineData.setVisContainerDivID(visContainerID);
        sparklineData.setEarliestYearConsidered(minGrantYearConsidered);
        sparklineData.setEarliestRenderedGrantYear(minGrantYear);
        sparklineData.setLatestRenderedGrantYear(currentYear);
        if ("short".equalsIgnoreCase(visMode)) {
            sparklineData.setEarliestRenderedGrantYear(shortSparkMinYear);
            sparklineData.setShortVisMode(true);
        } else {
            sparklineData.setShortVisMode(false);
        }
        if (this.yearToGrantCount.size() > 0) {
            sparklineData.setFullTimelineNetworkLink(UtilityFunctions.getCollaboratorshipNetworkLink(this.individualURI, "person_level", "copi"));
            sparklineData.setDownloadDataLink(UtilityFunctions.getCSVDownloadURL(this.individualURI, "person_grant_count", ""));
        }
        return sparklineData;
    }

    public SparklineData getValueObjectContainer() {
        return this.sparklineParameterVO;
    }
}

