/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.utilities;

import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CachingRDFServiceExecutor<T> {
    private T cachedResults;
    private long lastCacheTime;
    private final RDFServiceCallable<T> resultBuilder;
    private FutureTask<T> backgroundTask = null;
    private Thread backgroundCompletion = null;
    private long backgroundTaskStartTime = -1L;
    private static RDFService backgroundRDFService = null;

    public CachingRDFServiceExecutor(RDFServiceCallable<T> resultBuilder) {
        this.resultBuilder = resultBuilder;
    }

    public boolean isCached() {
        return this.cachedResults != null;
    }

    public Date cachedWhen() {
        return new Date(this.lastCacheTime);
    }

    public synchronized T get(RDFService rdfService) {
        return this.get(rdfService, false);
    }

    public synchronized T getNoWait(RDFService rdfService) {
        return this.get(rdfService, true);
    }

    public synchronized T get(RDFService rdfService, boolean allowWaits) {
        if (this.backgroundTask != null && this.backgroundTask.isDone()) {
            this.completeBackgroundTask();
        }
        if (this.cachedResults != null) {
            if (backgroundRDFService != null && this.resultBuilder.invalidateCache(System.currentTimeMillis() - this.lastCacheTime)) {
                long waitFor = 500L;
                if (this.backgroundTask == null) {
                    this.startBackgroundTask(backgroundRDFService);
                    waitFor = 1000L;
                }
                if (allowWaits && this.isExpectedToCompleteIn(waitFor)) {
                    this.completeBackgroundTask(waitFor);
                }
            }
        } else {
            if (rdfService != null) {
                this.startBackgroundTask(rdfService);
            } else if (backgroundRDFService != null) {
                this.startBackgroundTask(backgroundRDFService);
            } else {
                throw new RuntimeException("Can't execute without an RDF Service");
            }
            this.completeBackgroundTask();
        }
        return this.cachedResults;
    }

    public synchronized T get(RDFService rdfService, boolean allowWaits, boolean force) {
        if (force) {
            try {
                String backLang = backgroundRDFService.getVitroRequest().getLocale().getLanguage();
                String srvLang = rdfService.getVitroRequest().getLocale().getLanguage();
                if (!backLang.equals(srvLang)) {
                    backgroundRDFService.setVitroRequest(rdfService.getVitroRequest());
                    this.startBackgroundTask(rdfService);
                    this.completeBackgroundTask();
                }
            }
            catch (Exception e) {
                backgroundRDFService.setVitroRequest(rdfService.getVitroRequest());
                this.startBackgroundTask(rdfService);
                this.completeBackgroundTask();
            }
            return this.cachedResults;
        }
        if (this.backgroundTask != null && this.backgroundTask.isDone()) {
            this.completeBackgroundTask();
        }
        if (this.cachedResults != null) {
            if (backgroundRDFService != null && this.resultBuilder.invalidateCache(System.currentTimeMillis() - this.lastCacheTime)) {
                long waitFor = 500L;
                if (this.backgroundTask == null) {
                    this.startBackgroundTask(backgroundRDFService);
                    waitFor = 1000L;
                }
                if (allowWaits && this.isExpectedToCompleteIn(waitFor)) {
                    this.completeBackgroundTask(waitFor);
                }
            }
        } else {
            if (rdfService != null) {
                this.startBackgroundTask(rdfService);
            } else if (backgroundRDFService != null) {
                this.startBackgroundTask(backgroundRDFService);
            } else {
                throw new RuntimeException("Can't execute without an RDF Service");
            }
            this.completeBackgroundTask();
        }
        return this.cachedResults;
    }

    public void build(RDFService rdfService) {
        if (this.backgroundTask != null && this.backgroundTask.isDone()) {
            this.buildComplete();
        } else if (this.backgroundTask == null) {
            this.buildStart(rdfService);
        }
    }

    private synchronized void buildComplete() {
        if (this.backgroundTask != null && this.backgroundTask.isDone()) {
            this.completeBackgroundTask();
        }
    }

    private synchronized void buildStart(RDFService rdfService) {
        if (this.backgroundTask == null) {
            if (backgroundRDFService != null) {
                this.startBackgroundTask(backgroundRDFService);
                this.completeBackgroundTaskAsync();
            } else if (rdfService != null) {
                this.startBackgroundTask(rdfService);
                this.completeBackgroundTask();
            }
        }
    }

    private boolean isExpectedToCompleteIn(long interval) {
        long expectedFinish;
        if (this.backgroundTask == null) {
            return false;
        }
        if (this.backgroundTask.isDone()) {
            return true;
        }
        long now = System.currentTimeMillis();
        return ((RDFServiceCallable)this.resultBuilder).startedAt > -1L && ((RDFServiceCallable)this.resultBuilder).executionTime > -1L && (expectedFinish = ((RDFServiceCallable)this.resultBuilder).startedAt + ((RDFServiceCallable)this.resultBuilder).executionTime) < now + interval;
    }

    private void startBackgroundTask(RDFService rdfService) {
        if (this.backgroundTask == null && rdfService != null) {
            this.resultBuilder.setRDFService(backgroundRDFService != null ? backgroundRDFService : rdfService);
            this.backgroundTask = new FutureTask<T>(this.resultBuilder);
            this.backgroundTaskStartTime = System.currentTimeMillis();
            VitroBackgroundThread thread = new VitroBackgroundThread(this.backgroundTask, this.resultBuilder.getClass().getName());
            thread.setDaemon(true);
            thread.start();
        }
    }

    private void abortBackgroundTask() {
        if (this.backgroundTask != null) {
            this.backgroundTask.cancel(true);
            this.backgroundTask = null;
            this.backgroundTaskStartTime = -1L;
        }
    }

    private synchronized void completeBackgroundTaskAsync() {
        if (this.backgroundCompletion == null) {
            this.backgroundCompletion = new Thread(new Runnable(){

                @Override
                public void run() {
                    CachingRDFServiceExecutor.this.completeBackgroundTask(-1L);
                }
            });
            this.backgroundCompletion.setDaemon(true);
            this.backgroundCompletion.start();
        }
    }

    private void completeBackgroundTask() {
        this.completeBackgroundTask(-1L);
    }

    private void completeBackgroundTask(long waitFor) {
        try {
            if (this.backgroundTask != null) {
                this.cachedResults = waitFor < 0L ? this.backgroundTask.get() : this.backgroundTask.get(waitFor, TimeUnit.MILLISECONDS);
                this.lastCacheTime = this.backgroundTaskStartTime;
                this.backgroundTask = null;
                this.backgroundTaskStartTime = -1L;
                this.backgroundCompletion = null;
            }
        }
        catch (InterruptedException e) {
            this.abortBackgroundTask();
        }
        catch (ExecutionException e) {
            this.abortBackgroundTask();
            throw new RuntimeException("Background RDF thread through an exception", e.getCause());
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public static void setBackgroundRDFService(RDFService rdfService) {
        backgroundRDFService = rdfService;
    }

    public static class Affinity {
        private final int maxThreads = 1;
        private final Map<Thread, ThreadControl> threadToExecutionTime = new HashMap<Thread, ThreadControl>();
        private final Set<Thread> executingThreads = new HashSet<Thread>();

        private void requestStart(long expectedExecutionTime) {
            Thread executingThread = Thread.currentThread();
            CountDownLatch latch = this.queueThis(executingThread, expectedExecutionTime);
            if (latch != null) {
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private synchronized CountDownLatch queueThis(Thread thread, Long time) {
            if (this.executingThreads.size() < 1) {
                this.executingThreads.add(thread);
                return null;
            }
            ThreadControl control = new ThreadControl(System.currentTimeMillis(), time);
            this.threadToExecutionTime.put(thread, control);
            return control.latch;
        }

        private synchronized void complete() {
            if (this.executingThreads.contains(Thread.currentThread())) {
                this.executingThreads.remove(Thread.currentThread());
                while (this.threadToExecutionTime.size() > 0 && this.executingThreads.size() < 1) {
                    Thread nextToRelease = null;
                    ThreadControl nextToReleaseControl = null;
                    long current = System.currentTimeMillis();
                    boolean favourStartTime = false;
                    for (Thread thread : this.threadToExecutionTime.keySet()) {
                        ThreadControl threadControl = this.threadToExecutionTime.get(thread);
                        if (threadControl.started + 2000L < current) {
                            favourStartTime = true;
                        }
                        if (nextToRelease == null) {
                            nextToRelease = thread;
                            nextToReleaseControl = threadControl;
                            continue;
                        }
                        if (favourStartTime) {
                            if (threadControl.started >= nextToReleaseControl.started) continue;
                            nextToRelease = thread;
                            nextToReleaseControl = threadControl;
                            continue;
                        }
                        if (threadControl.expectedDuration >= nextToReleaseControl.expectedDuration) continue;
                        nextToRelease = thread;
                        nextToReleaseControl = threadControl;
                    }
                    if (nextToRelease == null) continue;
                    this.threadToExecutionTime.remove(nextToRelease);
                    this.executingThreads.add(nextToRelease);
                    nextToReleaseControl.latch.countDown();
                }
            }
        }

        static class ThreadControl {
            final long started;
            final long expectedDuration;
            final CountDownLatch latch = new CountDownLatch(1);

            ThreadControl(long started, long expectedDuration) {
                this.started = started;
                this.expectedDuration = expectedDuration;
            }
        }
    }

    public static abstract class RDFServiceCallable<T>
    implements Callable<T> {
        private RDFService rdfService;
        private long startedAt = -1L;
        private long executionTime = -1L;
        private Affinity affinity = null;

        public RDFServiceCallable() {
        }

        public RDFServiceCallable(Affinity affinity) {
            this.affinity = affinity;
        }

        final void setRDFService(RDFService rdfService) {
            this.rdfService = rdfService;
        }

        @Override
        public final T call() throws Exception {
            try {
                if (this.affinity != null) {
                    this.affinity.requestStart(this.executionTime);
                }
                this.startedAt = System.currentTimeMillis();
                T val = this.callWithService(this.rdfService);
                this.executionTime = System.currentTimeMillis() - this.startedAt;
                T t = val;
                return t;
            }
            finally {
                this.startedAt = -1L;
                if (this.affinity != null) {
                    this.affinity.complete();
                }
            }
        }

        protected abstract T callWithService(RDFService var1) throws Exception;

        boolean invalidateCache(long timeCached) {
            if (this.executionTime > -1L) {
                return timeCached > Math.min(this.executionTime * 120L, 86400000L);
            }
            return false;
        }
    }
}

