/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.utilities;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.QueryConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.model.ConceptLabelMap;
import edu.cornell.mannlib.vitro.webapp.visualization.model.ConceptPeopleMap;
import edu.cornell.mannlib.vitro.webapp.visualization.model.OrganizationPeopleMap;
import edu.cornell.mannlib.vitro.webapp.visualization.model.Person;
import edu.cornell.mannlib.vitro.webapp.visualization.utilities.CachingRDFServiceExecutor;
import edu.cornell.mannlib.vitro.webapp.visualization.utilities.PersonPublicationMaps;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.joda.time.DateTime;

public final class VisualizationCaches {
    private static final CachingRDFServiceExecutor.Affinity visualizationAffinity = new CachingRDFServiceExecutor.Affinity();
    public static final CachingRDFServiceExecutor<Map<String, Person>> people = new CachingRDFServiceExecutor<Map<String, Person>>(new CachingRDFServiceExecutor.RDFServiceCallable<Map<String, Person>>(visualizationAffinity){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Map<String, Person> callWithService(RDFService rdfService) throws Exception {
            final HashMap<String, Person> map = new HashMap<String, Person>();
            String construct = QueryConstants.getSparqlPrefixQuery() + "CONSTRUCT {\n  ?person a foaf:Person .\n  ?person foaf:lastName ?lastName .\n  ?person foaf:firstName ?firstName .\n  ?person obo:ARG_2000028 ?contactInfo .\n  ?contactInfo vcard:hasName ?contactName .\n  ?contactName vcard:familyName ?familyName .\n  ?contactName vcard:givenName ?givenName .\n  ?contactInfo vcard:hasTitle ?contactTitle .\n  ?contactTitle vcard:title ?contactTitleLabel  .\n  ?person public:thumbnailImage ?directDownloadUrl .\n} WHERE {\n  { \n    ?person a foaf:Person .\n  } UNION { \n    ?person a foaf:Person .\n    ?person foaf:lastName ?lastName .\n  } UNION { \n    ?person a foaf:Person .\n    ?person foaf:firstName ?firstName .\n  } UNION { \n    ?person a foaf:Person .\n    ?person obo:ARG_2000028 ?contactInfo .\n    ?contactInfo vcard:hasName ?contactName .\n    ?contactName vcard:familyName ?familyName .\n  } UNION { \n    ?person a foaf:Person .\n    ?person obo:ARG_2000028 ?contactInfo .\n    ?contactInfo vcard:hasName ?contactName .\n    ?contactName vcard:givenName ?givenName .\n  } UNION { \n    ?person a foaf:Person .\n    ?person obo:ARG_2000028 ?contactInfo .\n    ?contactInfo vcard:hasTitle ?contactTitle .\n    ?contactTitle vcard:title ?contactTitleLabel .\n  } UNION { \n    ?person a foaf:Person .\n    ?person public:mainImage ?mainImage .\n    ?mainImage public:thumbnailImage ?thumbnailImage .\n    ?thumbnailImage public:downloadLocation ?downloadLocation .\n    ?downloadLocation public:directDownloadUrl ?directDownloadUrl .\n  } \n}\n";
            Model constructedModel = ModelFactory.createDefaultModel();
            rdfService.sparqlConstructQuery(construct, constructedModel);
            String nameQuery = QueryConstants.getSparqlPrefixQuery() + "SELECT ?person ?familyName ?givenName ?lastName ?firstName ?title ?thumbnailUrl\nWHERE\n{\n  ?person a foaf:Person .\n  OPTIONAL {\n    ?person obo:ARG_2000028 ?contactInfo .\n    ?contactInfo vcard:hasName ?contactName .\n    OPTIONAL { ?contactName vcard:familyName ?familyName . }\n    OPTIONAL { ?contactName vcard:givenName  ?givenName . }\n  }\n  OPTIONAL {\n    ?person obo:ARG_2000028 ?contactInfo .\n    ?contactInfo vcard:hasTitle ?contactTitle .\n    ?contactTitle vcard:title ?title .\n  }\n  OPTIONAL { ?person foaf:lastName ?lastName . }\n  OPTIONAL { ?person foaf:firstName  ?firstName . }\n  OPTIONAL { ?person public:thumbnailImage ?thumbnailUrl . }\n}\n";
            try (QueryExecution qe = QueryExecutionFactory.create((String)nameQuery, (Model)constructedModel);){
                new ResultSetConsumer(){

                    protected void processQuerySolution(QuerySolution qs) {
                        Literal firstNameNode;
                        Literal lastNameNode;
                        String personUri = qs.getResource("person").getURI();
                        String familyName = null;
                        String givenName = null;
                        String thumbnailUrl = null;
                        String title = null;
                        Literal familyNameNode = qs.getLiteral("familyName");
                        familyName = familyNameNode != null ? familyNameNode.getString() : ((lastNameNode = qs.getLiteral("lastName")) == null ? null : lastNameNode.getString());
                        Literal givenNameNode = qs.getLiteral("givenName");
                        givenName = givenNameNode != null ? givenNameNode.getString() : ((firstNameNode = qs.getLiteral("firstName")) == null ? null : firstNameNode.getString());
                        Literal thumbnailUrlNode = qs.getLiteral("thumbnailUrl");
                        thumbnailUrl = thumbnailUrlNode == null ? null : thumbnailUrlNode.getString();
                        Literal titleNode = qs.getLiteral("title");
                        title = titleNode == null ? null : titleNode.getString();
                        Person person = (Person)map.get(personUri);
                        if (person == null) {
                            person = new Person();
                            map.put(personUri.intern(), person);
                        }
                        person.firstName = givenName == null ? null : givenName.intern();
                        person.lastName = familyName == null ? null : familyName.intern();
                        person.preferredTitle = title == null ? null : title.intern();
                        person.thumbnailUrl = thumbnailUrl;
                    }
                }.processResultSet(qe.execSelect());
            }
            return map;
        }
    });
    public static final CachingRDFServiceExecutor<Map<String, String>> organizationLabels = new CachingRDFServiceExecutor<Map<String, String>>(new CachingRDFServiceExecutor.RDFServiceCallable<Map<String, String>>(visualizationAffinity){

        @Override
        protected Map<String, String> callWithService(RDFService rdfService) throws Exception {
            VitroRequest vreq = rdfService.getVitroRequest();
            String langCtx = "en-US";
            String language = "en";
            try {
                langCtx = language = vreq.getLocale().getLanguage();
                if (!vreq.getLocale().getCountry().isEmpty()) {
                    langCtx = langCtx + "-" + vreq.getLocale().getCountry();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?org (Min(?orgLabel_) AS ?orgLabel) \nWHERE\n{\n  ?org a foaf:Organization \n  OPTIONAL { ?org rdfs:label ?orgLabelPrimary . \n       FILTER (langMatches(LANG(?orgLabelPrimary), '" + langCtx + "')) \n} \n  OPTIONAL { ?org rdfs:label ?orgLabelSecondary . \n       FILTER (langMatches(LANG(?orgLabelSecondary), '" + language + "')) \n} \n  OPTIONAL { ?org rdfs:label ?orgLabelTertiary .\n       FILTER (STRBEFORE(lcase(STR(LANG(?orgLabelTertiary))), '-') = '" + language.toLowerCase() + "') \n} \n  OPTIONAL { ?org rdfs:label ?orgLabelFallback .\n       FILTER (lcase(STR(LANG(?orgLabelFallback))) != '" + langCtx.toLowerCase() + "' \n           && lcase(STR(LANG(?orgLabelFallback))) != '" + language.toLowerCase() + "') \n} \nBIND(COALESCE(?orgLabelPrimary, ?orgLabelSecondary, ?orgLabelTertiary, ?orgLabelFallback) AS ?orgLabel_) \n} GROUP BY ?org \n";
            final HashMap<String, String> map = new HashMap<String, String>();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    String org = qs.getResource("org").getURI();
                    Literal labelLiteral = qs.getLiteral("orgLabel");
                    if (labelLiteral == null) {
                        return;
                    }
                    String orgLabel = labelLiteral.getString();
                    map.put(org.intern(), orgLabel.intern());
                }
            });
            return map;
        }
    });
    public static final CachingRDFServiceExecutor<Map<String, Set<String>>> organizationSubOrgs = new CachingRDFServiceExecutor<Map<String, Set<String>>>(new CachingRDFServiceExecutor.RDFServiceCallable<Map<String, Set<String>>>(visualizationAffinity){

        @Override
        protected Map<String, Set<String>> callWithService(RDFService rdfService) throws Exception {
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?org ?subOrg\nWHERE\n{\n  ?org a foaf:Organization .\n  ?org <http://purl.obolibrary.org/obo/BFO_0000051> ?subOrg .\n}\n";
            final HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    String org = qs.getResource("org").getURI();
                    String subOrg = qs.getResource("subOrg").getURI();
                    HashSet<String> subOrgs = (HashSet<String>)map.get(org);
                    if (subOrgs == null) {
                        subOrgs = new HashSet<String>();
                        subOrgs.add(subOrg.intern());
                        map.put(org.intern(), subOrgs);
                    } else {
                        subOrgs.add(subOrg.intern());
                    }
                }
            });
            return map;
        }
    });
    public static final CachingRDFServiceExecutor<Map<String, String>> organizationToMostSpecificLabel = new CachingRDFServiceExecutor<Map<String, String>>(new CachingRDFServiceExecutor.RDFServiceCallable<Map<String, String>>(){

        @Override
        protected Map<String, String> callWithService(RDFService rdfService) throws Exception {
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?org ?typeLabel\nWHERE\n{\n    ?org a foaf:Organization .\n    ?org vitro:mostSpecificType ?type .\n    ?type rdfs:label ?typeLabel .\n}\n";
            final HashMap<String, String> map = new HashMap<String, String>();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    String org = qs.getResource("org").getURI();
                    Literal labelLiteral = qs.getLiteral("typeLabel");
                    if (labelLiteral == null) {
                        return;
                    }
                    String typeLabel = labelLiteral.getString();
                    map.put(org.intern(), typeLabel.intern());
                }
            });
            return map;
        }
    });
    public static final CachingRDFServiceExecutor<OrganizationPeopleMap> organisationToPeopleMap = new CachingRDFServiceExecutor<OrganizationPeopleMap>(new CachingRDFServiceExecutor.RDFServiceCallable<OrganizationPeopleMap>(visualizationAffinity){

        @Override
        protected OrganizationPeopleMap callWithService(RDFService rdfService) throws Exception {
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?organisation ?person\nWHERE\n{\n  ?organisation a foaf:Organization .\n  ?organisation core:relatedBy ?position .\n  ?position a core:Position .\n  ?position core:relates ?person .\n  ?person a foaf:Person .\n}\n";
            final OrganizationPeopleMap orgToPeopleMap = new OrganizationPeopleMap();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    String org = qs.getResource("organisation").getURI().intern();
                    String person = qs.getResource("person").getURI().intern();
                    Set<String> people = orgToPeopleMap.organizationToPeople.get(org);
                    if (people == null) {
                        people = new HashSet<String>();
                        people.add(person);
                        orgToPeopleMap.organizationToPeople.put(org, people);
                    } else {
                        people.add(person);
                    }
                    Set<String> organizations = orgToPeopleMap.personToOrganizations.get(org);
                    if (organizations == null) {
                        organizations = new HashSet<String>();
                        organizations.add(org);
                        orgToPeopleMap.organizationToPeople.put(person, organizations);
                    } else {
                        organizations.add(org);
                    }
                }
            });
            return orgToPeopleMap;
        }
    });
    public static final CachingRDFServiceExecutor<ConceptLabelMap> conceptToLabel = new CachingRDFServiceExecutor<ConceptLabelMap>(new CachingRDFServiceExecutor.RDFServiceCallable<ConceptLabelMap>(){

        @Override
        protected ConceptLabelMap callWithService(RDFService rdfService) throws Exception {
            VitroRequest vreq = rdfService.getVitroRequest();
            String langCtx = "en-US";
            try {
                langCtx = vreq.getLocale().getLanguage();
                if (!vreq.getLocale().getCountry().isEmpty()) {
                    langCtx = langCtx + "-" + vreq.getLocale().getCountry();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?concept ?label\nWHERE\n{\n    ?person a foaf:Person .\n    ?person core:hasResearchArea ?concept .\n    ?concept a skos:Concept .\n  OPTIONAL {         ?concept rdfs:label ?labelPrimary . \n       FILTER (langMatches(LANG(?labelPrimary), '" + langCtx + "')) \n  } \n  OPTIONAL {         ?concept rdfs:label ?labelFallback1 . \n       FILTER (langMatches(LANG(?labelFallback1), 'en-US')) \n  } \n  OPTIONAL {         ?concept rdfs:label ?labelFallback2 . \n       FILTER (langMatches(LANG(?labelFallback2), 'en')) \n  } \n  OPTIONAL {         ?concept rdfs:label ?labelFallback3 . \n       FILTER (langMatches(LANG(?labelFallback3), '')) \n  } \nBIND(COALESCE(?labelPrimary, ?labelFallback1, ?labelFallback2, ?labelFallback3) AS ?label) \n}\n";
            final ConceptLabelMap map = new ConceptLabelMap();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    String conceptURI = qs.getResource("concept").getURI().intern();
                    Literal labelLiteral = qs.getLiteral("label");
                    if (labelLiteral == null) {
                        return;
                    }
                    String label = labelLiteral.getString().intern();
                    String labelLower = label.toLowerCase().intern();
                    map.conceptToLabel.put(conceptURI, label);
                    Set<String> conceptSet = map.lowerLabelToConcepts.get(labelLower);
                    if (conceptSet == null) {
                        conceptSet = new HashSet<String>();
                        conceptSet.add(conceptURI);
                        map.lowerLabelToConcepts.put(labelLower, conceptSet);
                    } else {
                        conceptSet.add(conceptURI);
                    }
                }
            });
            return map;
        }
    });
    public static final CachingRDFServiceExecutor<ConceptPeopleMap> conceptToPeopleMap = new CachingRDFServiceExecutor<ConceptPeopleMap>(new CachingRDFServiceExecutor.RDFServiceCallable<ConceptPeopleMap>(visualizationAffinity){

        @Override
        protected ConceptPeopleMap callWithService(RDFService rdfService) throws Exception {
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?person ?concept\nWHERE\n{\n  ?person a foaf:Person .\n  ?person core:hasResearchArea ?concept .\n  ?concept a skos:Concept .\n}\n";
            final ConceptPeopleMap conceptPeopleMap = new ConceptPeopleMap();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    String concept = qs.getResource("concept").getURI().intern();
                    String person = qs.getResource("person").getURI().intern();
                    Set<String> people = conceptPeopleMap.conceptToPeople.get(concept);
                    if (people == null) {
                        people = new HashSet<String>();
                        people.add(person);
                        conceptPeopleMap.conceptToPeople.put(concept, people);
                    } else {
                        people.add(person);
                    }
                    Set<String> concepts = conceptPeopleMap.personToConcepts.get(person);
                    if (concepts == null) {
                        concepts = new HashSet<String>();
                        concepts.add(concept);
                        conceptPeopleMap.personToConcepts.put(person, concepts);
                    } else {
                        concepts.add(concept);
                    }
                }
            });
            return conceptPeopleMap;
        }
    });
    public static final CachingRDFServiceExecutor<Map<String, String>> personLabels = new CachingRDFServiceExecutor<Map<String, String>>(new CachingRDFServiceExecutor.RDFServiceCallable<Map<String, String>>(visualizationAffinity){

        @Override
        protected Map<String, String> callWithService(RDFService rdfService) throws Exception {
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?person ?personLabel\nWHERE\n{\n  ?person a foaf:Person .\n  ?person rdfs:label ?personLabel .\n}\n";
            final HashMap<String, String> map = new HashMap<String, String>();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    String person = qs.getResource("person").getURI();
                    Literal labelLiteral = qs.getLiteral("personLabel");
                    if (labelLiteral == null) {
                        return;
                    }
                    String personLabel = labelLiteral.getString();
                    map.put(person.intern(), personLabel.intern());
                }
            });
            return map;
        }
    });
    public static final CachingRDFServiceExecutor<Map<String, String>> personToMostSpecificLabel = new CachingRDFServiceExecutor<Map<String, String>>(new CachingRDFServiceExecutor.RDFServiceCallable<Map<String, String>>(visualizationAffinity){

        @Override
        protected Map<String, String> callWithService(RDFService rdfService) throws Exception {
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?person ?typeLabel\nWHERE\n{\n    ?person a foaf:Person .\n    ?person vitro:mostSpecificType ?type .\n    ?type rdfs:label ?typeLabel .\n}\n";
            final HashMap<String, String> map = new HashMap<String, String>();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    String person = qs.getResource("person").getURI();
                    Literal labelLiteral = qs.getLiteral("typeLabel");
                    if (labelLiteral == null) {
                        return;
                    }
                    String typeLabel = labelLiteral.getString();
                    map.put(person.intern(), String.valueOf(typeLabel).intern());
                }
            });
            return map;
        }
    });
    public static final CachingRDFServiceExecutor<PersonPublicationMaps> personToPublication = new CachingRDFServiceExecutor<PersonPublicationMaps>(new CachingRDFServiceExecutor.RDFServiceCallable<PersonPublicationMaps>(visualizationAffinity){

        @Override
        protected PersonPublicationMaps callWithService(RDFService rdfService) throws Exception {
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?person ?document\nWHERE\n{\n  ?person a foaf:Person .\n  ?person core:relatedBy ?authorship .\n  ?authorship a core:Authorship .\n  ?authorship core:relates ?document .\n  ?document a <http://purl.obolibrary.org/obo/IAO_0000030> .\n}\n";
            final PersonPublicationMaps map = new PersonPublicationMaps();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    Resource person = qs.getResource("person");
                    Resource document = qs.getResource("document");
                    if (person != null && document != null) {
                        String personURI = person.getURI();
                        String documentURI = document.getURI();
                        map.put(personURI.intern(), documentURI.intern());
                    }
                }
            });
            return map;
        }
    });
    public static final CachingRDFServiceExecutor<Map<String, String>> publicationToJournal = new CachingRDFServiceExecutor<Map<String, String>>(new CachingRDFServiceExecutor.RDFServiceCallable<Map<String, String>>(visualizationAffinity){

        @Override
        protected Map<String, String> callWithService(RDFService rdfService) throws Exception {
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?document ?journalLabel\nWHERE\n{\n  ?document a <http://purl.obolibrary.org/obo/IAO_0000030> .\n  ?document core:hasPublicationVenue ?journal . \n  ?journal rdfs:label ?journalLabel . \n}\n";
            final HashMap<String, String> map = new HashMap<String, String>();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    String document = qs.getResource("document").getURI();
                    Literal labelLiteral = qs.getLiteral("journalLabel");
                    if (labelLiteral == null) {
                        return;
                    }
                    String journalLabel = labelLiteral.getString();
                    map.put(document.intern(), journalLabel.intern());
                }
            });
            return map;
        }
    });
    public static final CachingRDFServiceExecutor<Map<String, String>> publicationToYear = new CachingRDFServiceExecutor<Map<String, String>>(new CachingRDFServiceExecutor.RDFServiceCallable<Map<String, String>>(visualizationAffinity){

        @Override
        protected Map<String, String> callWithService(RDFService rdfService) throws Exception {
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?document ?publicationDate\nWHERE\n{\n  ?document a <http://purl.obolibrary.org/obo/IAO_0000030> .\n  ?document core:dateTimeValue ?dateTimeValue . \n  ?dateTimeValue core:dateTime ?publicationDate . \n}\n";
            final HashMap<String, String> map = new HashMap<String, String>();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    String document = qs.getResource("document").getURI();
                    Literal dateLiteral = qs.getLiteral("publicationDate");
                    if (dateLiteral == null) {
                        return;
                    }
                    String pubDate = dateLiteral.getString();
                    if (pubDate == null) {
                        return;
                    }
                    DateTime validParsedDateTimeObject = UtilityFunctions.getValidParsedDateTimeObject(pubDate);
                    if (validParsedDateTimeObject == null) {
                        return;
                    }
                    map.put(document.intern(), String.valueOf(validParsedDateTimeObject.getYear()).intern());
                }
            });
            return map;
        }
    });
    public static final CachingRDFServiceExecutor<Map<String, Set<String>>> personToGrant = new CachingRDFServiceExecutor<Map<String, Set<String>>>(new CachingRDFServiceExecutor.RDFServiceCallable<Map<String, Set<String>>>(visualizationAffinity){

        @Override
        protected Map<String, Set<String>> callWithService(RDFService rdfService) throws Exception {
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?person ?grant\nWHERE\n{\n  ?person a foaf:Person .\n  ?person <http://purl.obolibrary.org/obo/RO_0000053> ?role .\n  { ?role a core:PrincipalInvestigatorRole . } UNION { ?role a core:CoPrincipalInvestigatorRole . } \n  ?role core:relatedBy ?grant .\n  ?grant a core:Grant .\n}\n";
            final HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    Resource person = qs.getResource("person");
                    Resource grant = qs.getResource("grant");
                    if (person != null && grant != null) {
                        String personURI = person.getURI();
                        HashSet<String> documents = (HashSet<String>)map.get(personURI);
                        if (documents == null) {
                            documents = new HashSet<String>();
                            documents.add(grant.getURI().intern());
                            map.put(personURI.intern(), documents);
                        } else {
                            documents.add(grant.getURI().intern());
                        }
                    }
                }
            });
            return map;
        }
    });
    public static final CachingRDFServiceExecutor<Map<String, String>> grantToYear = new CachingRDFServiceExecutor<Map<String, String>>(new CachingRDFServiceExecutor.RDFServiceCallable<Map<String, String>>(visualizationAffinity){

        @Override
        protected Map<String, String> callWithService(RDFService rdfService) throws Exception {
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?grant ?startDateTimeValue\nWHERE\n{\n  ?grant a core:Grant .\n  ?grant core:dateTimeInterval ?dateTimeIntervalValue . \n  ?dateTimeIntervalValue core:start ?startDate . \n  ?startDate core:dateTime ?startDateTimeValue . \n}\n";
            final HashMap<String, String> map = new HashMap<String, String>();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    String grant = qs.getResource("grant").getURI();
                    Literal dateLiteral = qs.getLiteral("startDateTimeValue");
                    if (dateLiteral == null) {
                        return;
                    }
                    String startDate = dateLiteral.getString();
                    if (startDate == null) {
                        return;
                    }
                    DateTime validParsedDateTimeObject = UtilityFunctions.getValidParsedDateTimeObject(startDate);
                    if (validParsedDateTimeObject == null) {
                        return;
                    }
                    map.put(grant.intern(), String.valueOf(validParsedDateTimeObject.getYear()).intern());
                }
            });
            return map;
        }
    });
    public static final CachingRDFServiceExecutor<Map<String, String>> grantToRoleYear = new CachingRDFServiceExecutor<Map<String, String>>(new CachingRDFServiceExecutor.RDFServiceCallable<Map<String, String>>(visualizationAffinity){

        @Override
        protected Map<String, String> callWithService(RDFService rdfService) throws Exception {
            String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?grant ?startDateTimeValue\nWHERE\n{\n  ?grant a core:Grant .\n  ?grant core:relates ?role .\n  ?role core:dateTimeInterval ?dateTimeIntervalValue . \n  ?dateTimeIntervalValue core:start ?startDate . \n  ?startDate core:dateTime ?startDateTimeValue . \n}\n";
            final HashMap<String, String> map = new HashMap<String, String>();
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    String grant = qs.getResource("grant").getURI();
                    Literal dateLiteral = qs.getLiteral("startDateTimeValue");
                    if (dateLiteral == null) {
                        return;
                    }
                    String startDate = dateLiteral.getString();
                    if (startDate == null) {
                        return;
                    }
                    DateTime validParsedDateTimeObject = UtilityFunctions.getValidParsedDateTimeObject(startDate);
                    if (validParsedDateTimeObject == null) {
                        return;
                    }
                    map.put(grant.intern(), String.valueOf(validParsedDateTimeObject.getYear()).intern());
                }
            });
            return map;
        }
    });

    public static void rebuildAll() {
        VisualizationCaches.rebuildAll(null);
    }

    public static void rebuildAll(RDFService rdfService) {
        conceptToLabel.build(rdfService);
        conceptToPeopleMap.build(rdfService);
        organizationLabels.build(rdfService);
        organizationSubOrgs.build(rdfService);
        organizationToMostSpecificLabel.build(rdfService);
        organisationToPeopleMap.build(rdfService);
        personLabels.build(rdfService);
        personToMostSpecificLabel.build(rdfService);
        personToPublication.build(rdfService);
        publicationToJournal.build(rdfService);
        publicationToYear.build(rdfService);
        personToGrant.build(rdfService);
        grantToYear.build(rdfService);
    }

    public static void buildMissing() {
        if (!conceptToLabel.isCached()) {
            conceptToLabel.build(null);
        }
        if (!conceptToPeopleMap.isCached()) {
            conceptToPeopleMap.build(null);
        }
        if (!organizationLabels.isCached()) {
            organizationLabels.build(null);
        }
        if (!organizationSubOrgs.isCached()) {
            organizationSubOrgs.build(null);
        }
        if (!organizationToMostSpecificLabel.isCached()) {
            organizationToMostSpecificLabel.build(null);
        }
        if (!organisationToPeopleMap.isCached()) {
            organisationToPeopleMap.build(null);
        }
        if (!personLabels.isCached()) {
            personLabels.build(null);
        }
        if (!personToMostSpecificLabel.isCached()) {
            personToMostSpecificLabel.build(null);
        }
        if (!personToPublication.isCached()) {
            personToPublication.build(null);
        }
        if (!publicationToJournal.isCached()) {
            publicationToJournal.build(null);
        }
        if (!publicationToYear.isCached()) {
            publicationToYear.build(null);
        }
        if (!personToGrant.isCached()) {
            personToGrant.build(null);
        }
        if (!grantToYear.isCached()) {
            grantToYear.build(null);
        }
    }

    public static void rebuild(CachingRDFServiceExecutor ... executors) {
        if (executors != null) {
            for (CachingRDFServiceExecutor e : executors) {
                e.build(null);
            }
        }
    }
}

