/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.specialrelationships.RelationshipChecker;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractPropertyStatementAction;
import java.util.List;

public class AdvisingRelationshipChecker
extends RelationshipChecker {
    private static final String URI_ADVISING_RELATIONSHIP_TYPE = "http://vivoweb.org/ontology/core#AdvisingRelationship";
    private static final String URI_ADVISOR_ROLE = "http://vivoweb.org/ontology/core#AdvisorRole";
    private final String[] resourceUris;

    public AdvisingRelationshipChecker(AbstractPropertyStatementAction action) {
        super(action.getOntModel());
        this.resourceUris = action.getResourceUris();
    }

    public PolicyDecision isAuthorized(List<String> userUris) {
        for (String resourceUri : this.resourceUris) {
            if (!this.isAdvisingRelationship(resourceUri) || !this.anyUrisInCommon(userUris, this.getUrisOfAdvisors(resourceUri))) continue;
            return this.authorizedAdvisor(resourceUri);
        }
        return null;
    }

    private boolean isAdvisingRelationship(String resourceUri) {
        return this.isResourceOfType(resourceUri, URI_ADVISING_RELATIONSHIP_TYPE);
    }

    private List<String> getUrisOfAdvisors(String resourceUri) {
        return this.getObjectsThroughLinkingNode(resourceUri, "http://vivoweb.org/ontology/core#relates", URI_ADVISOR_ROLE, "http://purl.obolibrary.org/obo/RO_0000052");
    }

    private PolicyDecision authorizedAdvisor(String resourceUri) {
        return this.authorizedDecision("User is an Advisor of " + resourceUri);
    }
}

