/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.specialrelationships.RelationshipChecker;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractPropertyStatementAction;
import java.util.List;

public class ProjectOrServiceChecker
extends RelationshipChecker {
    private static final String URI_PROJECT_TYPE = "http://vivoweb.org/ontology/core#Project";
    private static final String URI_SERVICE_TYPE = "http://vivoweb.org/ontology/core#Service";
    private static final String URI_CLINICAL_ROLE_TYPE = "http://vivoweb.org/ontology/core#ClinicalRole";
    private static final String URI_CONTRIBUTING_ROLE_PROPERTY = "http://vivoweb.org/ontology/core#contributingRole";
    private final String[] resourceUris;

    public ProjectOrServiceChecker(AbstractPropertyStatementAction action) {
        super(action.getOntModel());
        this.resourceUris = action.getResourceUris();
    }

    public PolicyDecision isAuthorized(List<String> userUris) {
        for (String resourceUri : this.resourceUris) {
            if (this.isProject(resourceUri) && this.anyUrisInCommon(userUris, this.getClinicalAgentsOfProject(resourceUri))) {
                return this.authorizedClinicalAgent(resourceUri);
            }
            if (!this.isService(resourceUri) || !this.anyUrisInCommon(userUris, this.getClinicalAgentsOfService(resourceUri))) continue;
            return this.authorizedClinicalAgent(resourceUri);
        }
        return null;
    }

    private boolean isProject(String resourceUri) {
        return this.isResourceOfType(resourceUri, URI_PROJECT_TYPE);
    }

    private boolean isService(String resourceUri) {
        return this.isResourceOfType(resourceUri, URI_SERVICE_TYPE);
    }

    private List<String> getClinicalAgentsOfProject(String resourceUri) {
        return this.getObjectsThroughLinkingNode(resourceUri, "http://purl.obolibrary.org/obo/BFO_0000055", URI_CLINICAL_ROLE_TYPE, "http://purl.obolibrary.org/obo/RO_0000052");
    }

    private List<String> getClinicalAgentsOfService(String resourceUri) {
        return this.getObjectsThroughLinkingNode(resourceUri, URI_CONTRIBUTING_ROLE_PROPERTY, URI_CLINICAL_ROLE_TYPE, "http://purl.obolibrary.org/obo/RO_0000052");
    }

    private PolicyDecision authorizedClinicalAgent(String resourceUri) {
        return this.authorizedDecision("User has a Clinical Role on " + resourceUri);
    }
}

