/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.orcid;

import edu.cornell.mannlib.orcidclient.OrcidClientException;
import edu.cornell.mannlib.orcidclient.context.OrcidClientContext;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidAbstractHandler;
import java.util.EnumMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrcidContextSetup
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(OrcidContextSetup.class);

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        ConfigurationProperties props = ConfigurationProperties.getBean((ServletContext)ctx);
        StartupStatus ss = StartupStatus.getBean((ServletContext)ctx);
        if (props.getProperty("orcid.clientId", "").isEmpty()) {
            ss.info((ServletContextListener)this, "ORCID Integration is not configured.");
            return;
        }
        this.initializeOrcidClientContext(props, ss);
        this.checkForCommonNameProperty(props, ss);
    }

    private void initializeOrcidClientContext(ConfigurationProperties props, StartupStatus ss) {
        try {
            if (!"member".equalsIgnoreCase(props.getProperty("orcid.apiLevel", "member"))) {
                OrcidAbstractHandler.setAPiLevelPublic();
            }
            EnumMap<OrcidClientContext.Setting, String> settings = new EnumMap<OrcidClientContext.Setting, String>(OrcidClientContext.Setting.class);
            settings.put(OrcidClientContext.Setting.CLIENT_ID, props.getProperty("orcid.clientId"));
            settings.put(OrcidClientContext.Setting.CLIENT_SECRET, props.getProperty("orcid.clientPassword"));
            settings.put(OrcidClientContext.Setting.API_VERSION, props.getProperty("orcid.apiVersion"));
            settings.put(OrcidClientContext.Setting.API_ENVIRONMENT, props.getProperty("orcid.api"));
            settings.put(OrcidClientContext.Setting.WEBAPP_BASE_URL, props.getProperty("orcid.webappBaseUrl"));
            settings.put(OrcidClientContext.Setting.CALLBACK_PATH, "orcid/callback");
            OrcidClientContext.initialize(settings);
            ss.info((ServletContextListener)this, "Context is: " + OrcidClientContext.getInstance());
        }
        catch (OrcidClientException e) {
            ss.warning((ServletContextListener)this, "Failed to initialize OrcidClientContent", (Throwable)e);
        }
    }

    private void checkForCommonNameProperty(ConfigurationProperties props, StartupStatus ss) {
        if (StringUtils.isBlank((CharSequence)props.getProperty("orcid.externalIdCommonName"))) {
            ss.warning((ServletContextListener)this, "'orcid.externalIdCommonName' is not set. Using default value of 'VIVO Identifier'");
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

