/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.orcid.controller;

import edu.cornell.mannlib.orcidclient.OrcidClientException;
import edu.cornell.mannlib.orcidclient.actions.ApiAction;
import edu.cornell.mannlib.orcidclient.auth.AuthorizationStatus;
import edu.cornell.mannlib.orcidclient.model.OrcidProfile;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidAbstractHandler;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidConfirmationState;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidIntegrationController;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrcidAuthExternalIdsHandler
extends OrcidAbstractHandler {
    private static final Log log = LogFactory.getLog(OrcidAuthExternalIdsHandler.class);
    private AuthorizationStatus status;

    public OrcidAuthExternalIdsHandler(VitroRequest vreq) {
        super(vreq);
    }

    public ResponseValues exec() throws URISyntaxException, OrcidClientException {
        this.status = this.auth.getAuthorizationStatus(ApiAction.ADD_EXTERNAL_ID);
        if (this.status.isNone()) {
            return this.seekAuthorizationForExternalId();
        }
        if (this.status.isSuccess()) {
            return this.redirectToAddExternalId();
        }
        if (this.status.isDenied()) {
            return this.showConfirmationPage(OrcidConfirmationState.Progress.DENIED_ID, new OrcidProfile[0]);
        }
        return this.showConfirmationPage(OrcidConfirmationState.Progress.FAILED_ID, new OrcidProfile[0]);
    }

    private ResponseValues seekAuthorizationForExternalId() throws OrcidClientException, URISyntaxException {
        log.debug((Object)"Seeking authorization to add external ID");
        String returnUrl = this.occ.resolvePathWithWebapp(OrcidIntegrationController.PATH_ADD_EXTERNAL_ID);
        String seekUrl = this.auth.seekAuthorization(ApiAction.ADD_EXTERNAL_ID, returnUrl);
        return new RedirectResponseValues(seekUrl);
    }

    private ResponseValues redirectToAddExternalId() throws URISyntaxException {
        log.debug((Object)"Already authorized to add external ID.");
        return new RedirectResponseValues(this.occ.resolvePathWithWebapp(OrcidIntegrationController.PATH_ADD_EXTERNAL_ID));
    }
}

