/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.orcid.controller;

import edu.cornell.mannlib.orcidclient.context.OrcidClientContext;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.LogoutRedirector;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ExceptionResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidAddExternalIdHandler;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidAuthAuthenticateHandler;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidAuthExternalIdsHandler;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidCallbackHandler;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidDefaultHandler;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidReadProfileHandler;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="OrcidIntegrationController", urlPatterns={"/orcid/*"})
public class OrcidIntegrationController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(OrcidIntegrationController.class);
    private static final String PATHINFO_CALLBACK = "/callback";
    private static final String PATHINFO_AUTH_AUTHENTICATE = "/getAuthticateAuth";
    private static final String PATHINFO_READ_PROFILE = "/readProfile";
    private static final String PATHINFO_AUTH_EXTERNAL_ID = "/authExternalId";
    private static final String PATHINFO_ADD_EXTERNAL_ID = "/addExternalId";
    public static final String PATH_DEFAULT = "orcid";
    static final String PATH_AUTH_AUTHENTICATE = OrcidIntegrationController.path("/getAuthticateAuth");
    static final String PATH_READ_PROFILE = OrcidIntegrationController.path("/readProfile");
    static final String PATH_AUTH_EXTERNAL_ID = OrcidIntegrationController.path("/authExternalId");
    static final String PATH_ADD_EXTERNAL_ID = OrcidIntegrationController.path("/addExternalId");
    static final String TEMPLATE_CONFIRM = "orcidConfirm.ftl";
    public static final String PROPERTY_EXTERNAL_ID_COMMON_NAME = "orcid.externalIdCommonName";
    public static final String DEFAULT_EXTERNAL_ID_COMMON_NAME = "VIVO Identifier";

    static String path(String pathInfo) {
        return PATH_DEFAULT + pathInfo;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (!this.isOrcidConfigured()) {
            this.show404NotFound(resp);
        }
        if (PATHINFO_CALLBACK.equals(req.getPathInfo())) {
            new OrcidCallbackHandler(req, resp).exec();
        } else {
            super.doGet(req, resp);
        }
    }

    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        LogoutRedirector.recordRestrictedPageUri((HttpServletRequest)vreq);
        return AuthorizationRequest.AUTHORIZED;
    }

    protected ResponseValues processRequest(VitroRequest vreq) throws Exception {
        try {
            String pathInfo = vreq.getPathInfo();
            log.debug((Object)("Path info: " + pathInfo));
            if (PATHINFO_AUTH_AUTHENTICATE.equals(pathInfo)) {
                return new OrcidAuthAuthenticateHandler(vreq).exec();
            }
            if (PATHINFO_READ_PROFILE.equals(pathInfo)) {
                return new OrcidReadProfileHandler(vreq).exec();
            }
            if (PATHINFO_AUTH_EXTERNAL_ID.equals(pathInfo)) {
                return new OrcidAuthExternalIdsHandler(vreq).exec();
            }
            if (PATHINFO_ADD_EXTERNAL_ID.equals(pathInfo)) {
                return new OrcidAddExternalIdHandler(vreq).exec();
            }
            return new OrcidDefaultHandler(vreq).exec();
        }
        catch (Exception e) {
            return new ExceptionResponseValues((Throwable)e, 500);
        }
    }

    private boolean isOrcidConfigured() {
        try {
            OrcidClientContext.getInstance().getSetting(OrcidClientContext.Setting.CLIENT_ID);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void show404NotFound(HttpServletResponse resp) throws IOException {
        resp.sendError(404);
    }
}

