/*
 * Decompiled with CFR 0.152.
 */
package org.vivoweb.webapp.createandlink.crossref;

import org.vivoweb.webapp.createandlink.Citation;
import org.vivoweb.webapp.createandlink.CreateAndLinkResourceProvider;
import org.vivoweb.webapp.createandlink.ExternalIdentifiers;
import org.vivoweb.webapp.createandlink.ResourceModel;
import org.vivoweb.webapp.createandlink.crossref.CrossrefNativeAPI;
import org.vivoweb.webapp.createandlink.crossref.CrossrefResolverAPI;

public class CrossrefCreateAndLinkResourceProvider
implements CreateAndLinkResourceProvider {
    @Override
    public String normalize(String id) {
        if (id != null) {
            String doiTrimmed = id.trim().toLowerCase();
            if (doiTrimmed.startsWith("https://dx.doi.org/")) {
                return doiTrimmed.substring(19);
            }
            if (doiTrimmed.startsWith("http://dx.doi.org/")) {
                return doiTrimmed.substring(18);
            }
            if (doiTrimmed.startsWith("https://doi.org/")) {
                return doiTrimmed.substring(16);
            }
            if (doiTrimmed.startsWith("http://doi.org/")) {
                return doiTrimmed.substring(15);
            }
            return doiTrimmed;
        }
        return null;
    }

    @Override
    public String getLabel() {
        return "DOI";
    }

    @Override
    public ExternalIdentifiers allExternalIDsForFind(String externalId) {
        ExternalIdentifiers ids = new ExternalIdentifiers();
        ids.DOI = externalId;
        return ids;
    }

    @Override
    public String findInExternal(String id, Citation citation) {
        CrossrefResolverAPI resolverAPI = new CrossrefResolverAPI();
        String json = resolverAPI.findInExternal(id, citation);
        if (json == null) {
            CrossrefNativeAPI nativeAPI = new CrossrefNativeAPI();
            json = nativeAPI.findInExternal(id, citation);
        }
        return json;
    }

    @Override
    public ResourceModel makeResourceModel(String externalId, String externalResource) {
        CrossrefResolverAPI resolverAPI = new CrossrefResolverAPI();
        ResourceModel resourceModel = resolverAPI.makeResourceModel(externalResource);
        if (resourceModel == null) {
            CrossrefNativeAPI nativeAPI = new CrossrefNativeAPI();
            resourceModel = nativeAPI.makeResourceModel(externalResource);
        }
        return resourceModel;
    }
}

