/*
 * Decompiled with CFR 0.152.
 */
package org.vivoweb.webapp.createandlink.crossref;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.cornell.mannlib.vitro.webapp.utils.http.HttpClientFactory;
import edu.cornell.mannlib.vitro.webapp.web.URLEncoder;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.vivoweb.webapp.createandlink.Citation;
import org.vivoweb.webapp.createandlink.CreateAndLinkUtils;
import org.vivoweb.webapp.createandlink.ResourceModel;
import org.vivoweb.webapp.createandlink.crossref.CrossrefCiteprocJSONModel;
import org.vivoweb.webapp.createandlink.utils.HttpReader;

public class CrossrefResolverAPI {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String CROSSREF_RESOLVER = "https://doi.org/";

    public String findInExternal(String id, Citation citation) {
        try {
            String json = this.readJSON(CROSSREF_RESOLVER + URLEncoder.encode((String)id));
            if (StringUtils.isEmpty((CharSequence)json)) {
                return null;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            CrossrefCiteprocJSONModel jsonModel = (CrossrefCiteprocJSONModel)objectMapper.readValue(json, CrossrefCiteprocJSONModel.class);
            if (jsonModel == null) {
                return null;
            }
            if (!id.equalsIgnoreCase(jsonModel.DOI)) {
                return null;
            }
            citation.DOI = id;
            citation.type = this.normalizeType(jsonModel.type);
            citation.title = jsonModel.title;
            citation.journal = jsonModel.containerTitle;
            if (jsonModel.author != null) {
                ArrayList<Citation.Name> authors = new ArrayList<Citation.Name>();
                for (CrossrefCiteprocJSONModel.NameField author : jsonModel.author) {
                    this.splitNameLiteral(author);
                    Citation.Name citationAuthor = new Citation.Name();
                    citationAuthor.name = CreateAndLinkUtils.formatAuthorString(author.family, author.given);
                    authors.add(citationAuthor);
                }
                citation.authors = authors.toArray(new Citation.Name[authors.size()]);
            }
            citation.volume = jsonModel.volume;
            citation.issue = jsonModel.issue;
            citation.pagination = jsonModel.page;
            if (citation.pagination == null) {
                citation.pagination = jsonModel.articleNumber;
            }
            citation.publicationYear = this.extractYearFromDateField(jsonModel.publishedPrint);
            if (citation.publicationYear == null) {
                citation.publicationYear = this.extractYearFromDateField(jsonModel.publishedOnline);
            }
            return json;
        }
        catch (Exception e) {
            this.logger.error((Object)("[CREF] Error resolving DOI " + id + ", cause " + e.getMessage()));
            return null;
        }
    }

    private Integer extractYearFromDateField(CrossrefCiteprocJSONModel.DateField date) {
        if (date == null) {
            return null;
        }
        if (ArrayUtils.isEmpty((Object[])date.dateParts)) {
            return null;
        }
        return Integer.parseInt(date.dateParts[0][0]);
    }

    public ResourceModel makeResourceModel(String externalResource) {
        if (StringUtils.isEmpty((CharSequence)externalResource)) {
            return null;
        }
        CrossrefCiteprocJSONModel jsonModel = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            jsonModel = (CrossrefCiteprocJSONModel)objectMapper.readValue(externalResource, CrossrefCiteprocJSONModel.class);
        }
        catch (IOException e) {
            this.logger.error((Object)"Unable to read JSON", (Throwable)e);
        }
        if (jsonModel == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)jsonModel.DOI)) {
            return null;
        }
        ResourceModel model = new ResourceModel();
        model.DOI = jsonModel.DOI;
        model.PubMedID = jsonModel.PMID;
        model.PubMedCentralID = jsonModel.PMCID;
        model.ISSN = jsonModel.ISSN;
        model.ISBN = jsonModel.ISBN;
        model.URL = jsonModel.URL;
        if (jsonModel.ISBN != null) {
            int isbnIdx = 0;
            model.ISBN = new String[jsonModel.ISBN.length];
            for (String isbn : jsonModel.ISBN) {
                if (isbn.lastIndexOf(47) > -1) {
                    isbn = isbn.substring(isbn.lastIndexOf(47) + 1);
                }
                model.ISBN[isbnIdx] = isbn;
                ++isbnIdx;
            }
        }
        model.author = this.convertNameFields(jsonModel.author);
        model.editor = this.convertNameFields(jsonModel.editor);
        model.translator = this.convertNameFields(jsonModel.translator);
        model.containerTitle = jsonModel.containerTitle;
        model.issue = jsonModel.issue;
        if (!StringUtils.isEmpty((CharSequence)jsonModel.page)) {
            if (jsonModel.page.contains("-")) {
                int hyphen = jsonModel.page.indexOf(45);
                model.pageStart = jsonModel.page.substring(0, hyphen);
                model.pageEnd = jsonModel.page.substring(hyphen + 1);
            } else {
                model.pageStart = jsonModel.page;
            }
        } else if (!StringUtils.isEmpty((CharSequence)jsonModel.articleNumber)) {
            model.pageStart = jsonModel.articleNumber;
        }
        model.publicationDate = this.convertDateField(jsonModel.publishedPrint);
        if (model.publicationDate == null) {
            model.publicationDate = this.convertDateField(jsonModel.publishedOnline);
        }
        model.publisher = jsonModel.publisher;
        model.subject = jsonModel.subject;
        model.title = jsonModel.title;
        model.type = this.normalizeType(jsonModel.type);
        model.volume = jsonModel.volume;
        model.status = jsonModel.status;
        model.presentedAt = jsonModel.event;
        model.abstractText = jsonModel.abstractText;
        return model;
    }

    private ResourceModel.NameField[] convertNameFields(CrossrefCiteprocJSONModel.NameField[] nameFields) {
        if (nameFields == null) {
            return null;
        }
        ResourceModel.NameField[] destNameFields = new ResourceModel.NameField[nameFields.length];
        for (int nameIdx = 0; nameIdx < nameFields.length; ++nameIdx) {
            if (nameFields[nameIdx] == null) continue;
            this.splitNameLiteral(nameFields[nameIdx]);
            destNameFields[nameIdx] = new ResourceModel.NameField();
            destNameFields[nameIdx].family = nameFields[nameIdx].family;
            destNameFields[nameIdx].given = nameFields[nameIdx].given;
        }
        return destNameFields;
    }

    private String normalizeType(String type) {
        if (type != null) {
            switch (type.toLowerCase()) {
                case "journal-article": {
                    return "article-journal";
                }
                case "book-chapter": {
                    return "chapter";
                }
                case "proceedings-article": {
                    return "paper-conference";
                }
            }
        }
        return type;
    }

    private void splitNameLiteral(CrossrefCiteprocJSONModel.NameField author) {
        if (StringUtils.isEmpty((CharSequence)author.family)) {
            String given = null;
            if (!StringUtils.isEmpty((CharSequence)author.literal)) {
                if (author.literal.contains(",")) {
                    author.family = author.literal.substring(0, author.literal.indexOf(44));
                    given = author.literal.substring(author.literal.indexOf(44) + 1);
                } else if (author.literal.lastIndexOf(32) > -1) {
                    author.family = author.literal.substring(author.literal.lastIndexOf(32) + 1);
                    given = author.literal.substring(0, author.literal.lastIndexOf(32));
                } else {
                    author.family = author.literal;
                }
            }
            if (StringUtils.isEmpty((CharSequence)author.given)) {
                author.given = given;
            }
        }
    }

    private ResourceModel.DateField convertDateField(CrossrefCiteprocJSONModel.DateField dateField) {
        if (dateField != null) {
            ResourceModel.DateField resourceDate = new ResourceModel.DateField();
            if (dateField.dateParts != null && dateField.dateParts.length > 0 && dateField.dateParts[0].length > 0) {
                try {
                    resourceDate.year = Integer.parseInt(dateField.dateParts[0][0], 10);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (dateField.dateParts.length > 1) {
                    try {
                        resourceDate.month = Integer.parseInt(dateField.dateParts[0][1], 10);
                    }
                    catch (NumberFormatException nfe) {
                        switch (dateField.dateParts[0][1].toLowerCase()) {
                            case "jan": 
                            case "january": {
                                resourceDate.month = 1;
                                break;
                            }
                            case "feb": 
                            case "february": {
                                resourceDate.month = 2;
                                break;
                            }
                            case "mar": 
                            case "march": {
                                resourceDate.month = 3;
                                break;
                            }
                            case "apr": 
                            case "april": {
                                resourceDate.month = 4;
                                break;
                            }
                            case "may": {
                                resourceDate.month = 5;
                                break;
                            }
                            case "jun": 
                            case "june": {
                                resourceDate.month = 6;
                                break;
                            }
                            case "jul": 
                            case "july": {
                                resourceDate.month = 7;
                                break;
                            }
                            case "aug": 
                            case "august": {
                                resourceDate.month = 8;
                                break;
                            }
                            case "sep": 
                            case "september": {
                                resourceDate.month = 9;
                                break;
                            }
                            case "oct": 
                            case "october": {
                                resourceDate.month = 10;
                                break;
                            }
                            case "nov": 
                            case "november": {
                                resourceDate.month = 11;
                                break;
                            }
                            case "dec": 
                            case "december": {
                                resourceDate.month = 12;
                            }
                        }
                    }
                }
                if (dateField.dateParts.length > 2) {
                    try {
                        resourceDate.day = Integer.parseInt(dateField.dateParts[0][2], 10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return resourceDate;
        }
        return null;
    }

    private String readJSON(String url) {
        try {
            HttpClient client = HttpClientFactory.getHttpClient();
            HttpGet request = new HttpGet(url);
            request.setHeader("Accept", "application/vnd.citationstyles.csl+json;q=1.0");
            HttpResponse response = client.execute((HttpUriRequest)request);
            return HttpReader.fromResponse(response);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

