/*
 * Decompiled with CFR 0.152.
 */
package org.vivoweb.webapp.startup;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.individuallist.IndividualJsonWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;

public class JSONWrapperSetup
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(JSONWrapperSetup.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        IndividualJsonWrapper.setAddJSONFields((IndividualJsonWrapper.AddJSONFields)new IndividualJsonWrapper.AddJSONFields(){
            private String VCARD_DATA_QUERY = "PREFIX obo: <http://purl.obolibrary.org/obo/> \nPREFIX vcard: <http://www.w3.org/2006/vcard/ns#>  \nSELECT DISTINCT ?title  \nWHERE {  \n    ?subject obo:ARG_2000028 ?vIndividual .  \n    ?vIndividual vcard:hasTitle ?vTitle . \n    ?vTitle vcard:title ?title . \n} ";

            public void add(ObjectNode jo, VitroRequest vreq, Individual ind) {
                jo.put("preferredTitle", this.findPreferredTitle(vreq, ind));
            }

            private String findPreferredTitle(VitroRequest vreq, Individual ind) {
                String queryStr = QueryUtils.subUriForQueryVar((String)this.VCARD_DATA_QUERY, (String)"subject", (String)ind.getURI());
                log.debug((Object)("queryStr = " + queryStr));
                String value = "";
                try {
                    ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)vreq);
                    while (results.hasNext()) {
                        QuerySolution soln = results.nextSolution();
                        String t = QueryUtils.nodeToString((RDFNode)soln.get("title"));
                        if (!StringUtils.isNotBlank((CharSequence)t)) continue;
                        value = t;
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
                return value;
            }
        });
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

