/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ConstantFieldOptions;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.vocabulary.RDFS;

public class GeneratorUtil {
    private static final Log log = LogFactory.getLog(GeneratorUtil.class);

    public static ConstantFieldOptions buildResourceAndLabelFieldOptions(RDFService rdfService, WebappDaoFactory webappDaoFactory, String headerValue, String headerLabel, String ... resourceURIs) throws Exception {
        if (resourceURIs == null || resourceURIs.length == 0 || rdfService == null) {
            return new ConstantFieldOptions(new String[0]);
        }
        ArrayList<String> options = new ArrayList<String>();
        if (headerValue != null && headerLabel != null) {
            options.add(headerValue);
            options.add(headerLabel);
        }
        IRIFactory iriFactory = IRIFactory.iriImplementation();
        for (String resourceURI : resourceURIs) {
            IRI iri = iriFactory.create(resourceURI);
            if (iri.hasViolation(false)) {
                log.warn((Object)("Not adding invalid URI " + resourceURI + " to field options list"));
                continue;
            }
            String label = GeneratorUtil.getLabel(iri, rdfService, webappDaoFactory);
            if (StringUtils.isEmpty((CharSequence)label)) continue;
            options.add(iri.toString());
            options.add(label);
        }
        return new ConstantFieldOptions(options.toArray(new String[options.size()]));
    }

    private static String getLabel(IRI iri, RDFService rdfService, WebappDaoFactory webappDaoFactory) throws RDFServiceException {
        VClass vclass;
        if (webappDaoFactory != null && (vclass = webappDaoFactory.getVClassDao().getVClassByURI(iri.toString())) != null) {
            return vclass.getLabel();
        }
        StringBuilder select = new StringBuilder("SELECT ?label WHERE { \n");
        select.append("  <" + iri + "> <" + RDFS.label.getURI() + "> ?label \n");
        select.append("} ORDER BY ?label");
        LabelConsumer labelConsumer = new LabelConsumer();
        rdfService.sparqlSelectQuery(select.toString(), (ResultSetConsumer)labelConsumer);
        return labelConsumer.getLabel();
    }

    private static class LabelConsumer
    extends ResultSetConsumer {
        private String label;

        private LabelConsumer() {
        }

        protected void processQuerySolution(QuerySolution qsoln) {
            if (this.label != null) {
                return;
            }
            if (qsoln.contains("label") && qsoln.get("label").isLiteral()) {
                this.label = qsoln.getLiteral("label").getLexicalForm();
            }
        }

        public String getLabel() {
            return this.label;
        }
    }
}

