/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.menuManagement;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.InternalClassesDataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.menuManagement.ProcessIndividualsForClasses;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;

public class ProcessInternalClasses
extends ProcessIndividualsForClasses {
    private static final Log log = LogFactory.getLog(ProcessInternalClasses.class);

    protected void populateRestrictedClasses(Map<String, Object> pageData, Map<String, Object> templateData) {
        String internalClassUris = (String)pageData.get("internalClass");
        if (internalClassUris != null && !internalClassUris.isEmpty()) {
            templateData.put("isInternal", "true");
        }
    }

    public boolean useProcessor(VitroRequest vreq) {
        return this.internalClassSelected(vreq) || !this.allClassesSelected(vreq);
    }

    public Model processSubmission(VitroRequest vreq, Resource dataGetterResource) {
        String dataGetterTypeUri = DataGetterUtils.generateDataGetterTypeURI((String)InternalClassesDataGetter.class.getName());
        String[] selectedClasses = vreq.getParameterValues("classInClassGroup");
        Model dgModel = ModelFactory.createDefaultModel();
        dgModel.add(dgModel.createStatement(dataGetterResource, RDF.type, (RDFNode)ResourceFactory.createResource((String)dataGetterTypeUri)));
        for (String classUri : selectedClasses) {
            dgModel.add(dgModel.createStatement(dataGetterResource, ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ontologies/display/1.1#getIndividualsForClass"), (RDFNode)ResourceFactory.createResource((String)classUri)));
        }
        if (this.internalClassSelected(vreq)) {
            dgModel.add(dgModel.createStatement(dataGetterResource, ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ontologies/display/1.1#restrictResultsByInternalClass"), (RDFNode)dgModel.createLiteral("true")));
        }
        return dgModel;
    }

    private boolean allClassesSelected(VitroRequest vreq) {
        String allClasses = vreq.getParameter("allSelected");
        return allClasses != null && !allClasses.isEmpty();
    }

    private boolean internalClassSelected(VitroRequest vreq) {
        String internalClass = vreq.getParameter("display-internalClass");
        return internalClass != null && !internalClass.isEmpty();
    }
}

