/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing;

import com.hp.hpl.jena.rdf.model.Literal;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FirstAndLastNameValidator
implements N3ValidatorVTwo {
    private static String MISSING_FIRST_NAME_ERROR = "You must enter a value in the First Name field.";
    private static String MISSING_LAST_NAME_ERROR = "You must enter a value in the Last Name field.";
    private static String MALFORMED_LAST_NAME_ERROR = "The last name field may not contain a comma. Please enter first name in First Name field.";
    private String uriReceiver;

    public FirstAndLastNameValidator(String uriReceiver) {
        this.uriReceiver = uriReceiver;
    }

    public Map<String, String> validate(EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub) {
        Map urisFromForm = editSub.getUrisFromForm();
        Map literalsFromForm = editSub.getLiteralsFromForm();
        HashMap<String, String> errors = new HashMap<String, String>();
        List personUri = (List)urisFromForm.get(this.uriReceiver);
        if (this.allListElementsEmpty(personUri) || personUri.contains(">SUBMITTED VALUE WAS BLANK<")) {
            personUri = null;
        }
        if (personUri != null) {
            return null;
        }
        Literal firstName = null;
        List firstNameList = (List)literalsFromForm.get("firstName");
        if (firstNameList != null && firstNameList.size() > 0) {
            firstName = (Literal)firstNameList.get(0);
        }
        if (firstName != null && firstName.getLexicalForm() != null && "".equals(firstName.getLexicalForm())) {
            firstName = null;
        }
        List lastNameList = (List)literalsFromForm.get("lastName");
        Literal lastName = null;
        if (lastNameList != null && lastNameList.size() > 0) {
            lastName = (Literal)lastNameList.get(0);
        }
        String lastNameValue = "";
        if (lastName != null && "".equals(lastNameValue = lastName.getLexicalForm())) {
            lastName = null;
        }
        if (lastName == null) {
            errors.put("lastName", MISSING_LAST_NAME_ERROR);
        } else if (lastNameValue.contains(",")) {
            errors.put("lastName", MALFORMED_LAST_NAME_ERROR);
        }
        if (firstName == null) {
            errors.put("firstName", MISSING_FIRST_NAME_ERROR);
        }
        return errors.size() != 0 ? errors : null;
    }

    private boolean allListElementsEmpty(List<String> checkList) {
        if (checkList == null) {
            return true;
        }
        if (checkList.isEmpty()) {
            return true;
        }
        boolean allEmpty = true;
        for (String s : checkList) {
            if (s.length() == 0) continue;
            allEmpty = false;
            break;
        }
        return allEmpty;
    }
}

