/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.FirstAndLastNameValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddEditorsToInformationResourceGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    public static Log log = LogFactory.getLog(AddEditorsToInformationResourceGenerator.class);
    private static String EDITORSHIPS_MODEL = "PREFIX core: <http://vivoweb.org/ontology/core#>\nPREFIX afn:  <http://jena.hpl.hp.com/ARQ/function#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX foaf: <http://xmlns.com/foaf/0.1/>\nCONSTRUCT\n{\n    ?subject core:relatedBy ?editorshipURI .\n    ?editorshipURI a core:Editorship .\n    ?editorshipURI core:relates ?editorURI .\n    ?editorshipURI core:rank ?rank.\n    ?editorURI a foaf:Person .\n    ?editorURI rdfs:label ?editorName .\n}\nWHERE\n{\n    {\n        ?subject core:relatedBy ?editorshipURI .\n        ?editorshipURI a core:Editorship .\n        ?editorshipURI core:relates ?editorURI .\n        ?editorURI a foaf:Person .\n    }\n    UNION\n    {\n        ?subject core:relatedBy ?editorshipURI .\n        ?editorshipURI a core:Editorship .\n        ?editorshipURI core:relates ?editorURI .\n        ?editorURI a foaf:Person .\n        ?editorURI rdfs:label ?editorName .\n    }\n    UNION\n    {\n        ?subject core:relatedBy ?editorshipURI .\n        ?editorshipURI a core:Editorship .\n        ?editorshipURI core:rank ?rank.\n    }\n}\n";
    private static String EDITORSHIPS_QUERY = "PREFIX core: <http://vivoweb.org/ontology/core#> \nPREFIX afn:  <http://jena.hpl.hp.com/ARQ/function#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nSELECT ?editorshipURI (afn:localname(?editorshipURI) AS ?editorshipName) ?editorURI ?editorName ?rank \nWHERE { \n?subject core:relatedBy ?editorshipURI . \n?editorshipURI a core:Editorship . \n?editorshipURI core:relates ?editorURI . \n?editorURI a foaf:Person . \nOPTIONAL { ?editorURI rdfs:label ?editorName } \nOPTIONAL { ?editorshipURI core:rank ?rank } \n} ORDER BY ?rank";
    private static String MAX_RANK_QUERY = "PREFIX core: <http://vivoweb.org/ontology/core#> \nSELECT DISTINCT ?rank WHERE { \n    ?subject core:relatedBy ?editorship . \n    ?editorship a core:Editorship . \n    ?editorship core:rank ?rank .\n} ORDER BY DESC(?rank) LIMIT 1";
    static final String DEFAULT_NS_TOKEN = null;

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initBasics(editConfiguration, vreq);
        this.initPropertyParameters(vreq, session, editConfiguration);
        this.setUrlToReturnTo(editConfiguration, vreq);
        editConfiguration.setVarNameForSubject("infoResource");
        editConfiguration.setVarNameForPredicate("predicate");
        editConfiguration.setVarNameForObject("editorshipUri");
        editConfiguration.setN3Required(AddEditorsToInformationResourceGenerator.list((Object[])new Object[]{this.getN3NewEditorship()}));
        editConfiguration.setN3Optional(this.generateN3Optional());
        editConfiguration.addNewResource("editorshipUri", DEFAULT_NS_TOKEN);
        editConfiguration.addNewResource("newPerson", DEFAULT_NS_TOKEN);
        editConfiguration.addNewResource("vcardPerson", DEFAULT_NS_TOKEN);
        editConfiguration.addNewResource("vcardName", DEFAULT_NS_TOKEN);
        this.setUrisAndLiteralsInScope(editConfiguration, vreq);
        this.setUrisAndLiteralsOnForm(editConfiguration, vreq);
        this.setSparqlQueries(editConfiguration, vreq);
        this.setFields(editConfiguration, vreq, EditConfigurationUtils.getPredicateUri((VitroRequest)vreq));
        editConfiguration.setTemplate("addEditorsToInformationResource.ftl");
        editConfiguration.addValidator((N3ValidatorVTwo)new FirstAndLastNameValidator("personUri"));
        this.addFormSpecificData(editConfiguration, vreq);
        editConfiguration.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        return editConfiguration;
    }

    private void setUrlToReturnTo(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setUrlPatternToReturnTo(EditConfigurationUtils.getFormUrlWithoutContext((VitroRequest)vreq));
    }

    public String getN3PrefixString() {
        return "@prefix core: <http://vivoweb.org/ontology/core#> .\n@prefix foaf: <http://xmlns.com/foaf/0.1/> .  \n";
    }

    private String getN3NewEditorship() {
        return this.getN3PrefixString() + "?editorshipUri a core:Editorship ;\n" + "  core:relates ?infoResource .\n" + "?infoResource core:relatedBy ?editorshipUri .";
    }

    private String getN3EditorshipRank() {
        return this.getN3PrefixString() + "?editorshipUri core:editorRank ?rank .";
    }

    public List<String> generateN3Optional() {
        return AddEditorsToInformationResourceGenerator.list((Object[])new Object[]{this.getN3NewPersonFirstName(), this.getN3NewPersonMiddleName(), this.getN3NewPersonLastName(), this.getN3NewPerson(), this.getN3EditorshipRank(), this.getN3ForExistingPerson()});
    }

    private String getN3NewPersonFirstName() {
        return this.getN3PrefixString() + "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n" + "?newPerson <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n" + "?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?newPerson . \n" + "?vcardPerson a <http://www.w3.org/2006/vcard/ns#Individual> . \n" + "?vcardPerson vcard:hasName  ?vcardName . \n" + "?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n" + "?vcardName vcard:givenName ?firstName .";
    }

    private String getN3NewPersonMiddleName() {
        return this.getN3PrefixString() + "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n" + "?newPerson <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n" + "?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?newPerson . \n" + "?vcardPerson a vcard:Individual . \n" + "?vcardPerson vcard:hasName  ?vcardName . \n" + "?vcardName a vcard:Name . \n" + "?vcardName <http://vivoweb.org/ontology/core#middleName> ?middleName .";
    }

    private String getN3NewPersonLastName() {
        return this.getN3PrefixString() + "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n" + "?newPerson <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n" + "?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?newPerson . \n" + "?vcardPerson a <http://www.w3.org/2006/vcard/ns#Individual> . \n" + "?vcardPerson vcard:hasName  ?vcardName . \n" + "?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n" + "?vcardName vcard:familyName ?lastName .";
    }

    private String getN3NewPerson() {
        return this.getN3PrefixString() + "?newPerson a foaf:Person ;\n" + "<" + RDFS.label.getURI() + "> ?label .\n" + "?editorshipUri core:relates ?newPerson .\n" + "?newPerson core:relatedBy ?editorshipUri . ";
    }

    private String getN3ForExistingPerson() {
        return this.getN3PrefixString() + "?editorshipUri core:relates ?personUri .\n" + "?personUri core:relatedBy ?editorshipUri .";
    }

    private Map<String, String> generateNewResources(VitroRequest vreq) {
        HashMap<String, String> newResources = new HashMap<String, String>();
        newResources.put("editorshipUri", DEFAULT_NS_TOKEN);
        newResources.put("newPerson", DEFAULT_NS_TOKEN);
        newResources.put("vcardPerson", DEFAULT_NS_TOKEN);
        newResources.put("vcardName", DEFAULT_NS_TOKEN);
        return newResources;
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
        urisInScope.put(editConfiguration.getVarNameForSubject(), Arrays.asList(editConfiguration.getSubjectUri()));
        urisInScope.put(editConfiguration.getVarNameForPredicate(), Arrays.asList(editConfiguration.getPredicateUri()));
        editConfiguration.setUrisInScope(urisInScope);
    }

    public void setUrisAndLiteralsOnForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        urisOnForm.add("personUri");
        editConfiguration.setUrisOnform(urisOnForm);
        List literalsOnForm = AddEditorsToInformationResourceGenerator.list((Object[])new Object[]{"firstName", "middleName", "lastName", "rank", "label"});
        editConfiguration.setLiteralsOnForm(literalsOnForm);
    }

    private void setSparqlQueries(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap map = new HashMap();
        editConfiguration.setSparqlForExistingUris(new HashMap());
        editConfiguration.setSparqlForExistingLiterals(new HashMap());
        editConfiguration.setSparqlForAdditionalUrisInScope(new HashMap());
        editConfiguration.setSparqlForAdditionalLiteralsInScope(new HashMap());
    }

    public void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri) {
        this.setLabelField(editConfiguration);
        this.setFirstNameField(editConfiguration);
        this.setMiddleNameField(editConfiguration);
        this.setLastNameField(editConfiguration);
        this.setRankField(editConfiguration);
        this.setPersonUriField(editConfiguration);
    }

    private void setLabelField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("label").setValidators(AddEditorsToInformationResourceGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})).setRangeDatatypeUri(XSD.xstring.toString()));
    }

    private void setFirstNameField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("firstName").setValidators(AddEditorsToInformationResourceGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})).setRangeDatatypeUri(XSD.xstring.toString()));
    }

    private void setMiddleNameField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("middleName").setValidators(AddEditorsToInformationResourceGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})).setRangeDatatypeUri(XSD.xstring.toString()));
    }

    private void setLastNameField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("lastName").setValidators(AddEditorsToInformationResourceGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})).setRangeDatatypeUri(XSD.xstring.toString()));
    }

    private void setRankField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("rank").setValidators(AddEditorsToInformationResourceGenerator.list((Object[])new Object[]{"nonempty"})).setRangeDatatypeUri(XSD.xint.toString()));
    }

    private void setPersonUriField(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addField(new FieldVTwo().setName("personUri"));
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, Object> formSpecificData = new HashMap<String, Object>();
        formSpecificData.put("existingEditorInfo", this.getExistingEditorships(editConfiguration.getSubjectUri(), vreq));
        formSpecificData.put("newRank", this.getMaxRank(editConfiguration.getSubjectUri(), vreq) + 1);
        formSpecificData.put("rankPredicate", "http://vivoweb.org/ontology/core#rank");
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EditorshipInfo> getExistingEditorships(String subjectUri, VitroRequest vreq) {
        RDFService rdfService = vreq.getRDFService();
        ArrayList<Map<String, String>> editorships = new ArrayList<Map<String, String>>();
        try {
            String constructStr = QueryUtils.subUriForQueryVar((String)EDITORSHIPS_MODEL, (String)"subject", (String)subjectUri);
            Model constructedModel = ModelFactory.createDefaultModel();
            rdfService.sparqlConstructQuery(constructStr, constructedModel);
            String queryStr = QueryUtils.subUriForQueryVar((String)this.getEditorshipsQuery(), (String)"subject", (String)subjectUri);
            log.debug((Object)("Query string is: " + queryStr));
            try (QueryExecution qe = QueryExecutionFactory.create((String)queryStr, (Model)constructedModel);){
                ResultSet results = qe.execSelect();
                while (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    RDFNode node = soln.get("editorshipURI");
                    if (!node.isURIResource()) continue;
                    editorships.add(QueryUtils.querySolutionToStringValueMap((QuerySolution)soln));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        log.debug((Object)("editorships = " + editorships));
        return this.getEditorshipInfo(editorships);
    }

    private int getMaxRank(String subjectUri, VitroRequest vreq) {
        int maxRank = 0;
        String queryStr = QueryUtils.subUriForQueryVar((String)this.getMaxRankQueryStr(), (String)"subject", (String)subjectUri);
        log.debug((Object)("maxRank query string is: " + queryStr));
        try {
            int rank;
            QuerySolution soln;
            RDFNode node;
            ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)vreq);
            if (results != null && results.hasNext() && (node = (soln = results.next()).get("rank")) != null && node.isLiteral() && (rank = Integer.parseInt(node.asLiteral().getLexicalForm())) > maxRank) {
                log.debug((Object)("setting maxRank to " + rank));
                maxRank = rank;
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)"Invalid rank returned from query: not an integer value.");
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        log.debug((Object)("maxRank is: " + maxRank));
        return maxRank;
    }

    private List<EditorshipInfo> getEditorshipInfo(List<Map<String, String>> editorships) {
        ArrayList<EditorshipInfo> info = new ArrayList<EditorshipInfo>();
        String editorshipUri = "";
        String editorshipName = "";
        String editorUri = "";
        String editorName = "";
        for (Map<String, String> editorship : editorships) {
            for (Map.Entry<String, String> entry : editorship.entrySet()) {
                if (entry.getKey().equals("editorshipURI")) {
                    editorshipUri = entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("editorshipName")) {
                    editorshipName = entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("editorURI")) {
                    editorUri = entry.getValue();
                    continue;
                }
                if (!entry.getKey().equals("editorName")) continue;
                editorName = entry.getValue();
            }
            EditorshipInfo aaInfo = new EditorshipInfo(editorshipUri, editorshipName, editorUri, editorName);
            info.add(aaInfo);
        }
        log.debug((Object)("info = " + info));
        return info;
    }

    protected String getMaxRankQueryStr() {
        return MAX_RANK_QUERY;
    }

    protected String getEditorshipsQuery() {
        return EDITORSHIPS_QUERY;
    }

    public class EditorshipInfo {
        private String editorshipUri;
        private String editorshipName;
        private String editorUri;
        private String editorName;

        public EditorshipInfo(String inputEditorshipUri, String inputEditorshipName, String inputEditorUri, String inputEditorName) {
            this.editorshipUri = inputEditorshipUri;
            this.editorshipName = inputEditorshipName;
            this.editorUri = inputEditorUri;
            this.editorName = inputEditorName;
        }

        public String getEditorshipUri() {
            return this.editorshipUri;
        }

        public String getEditorshipName() {
            return this.editorshipName;
        }

        public String getEditorUri() {
            return this.editorUri;
        }

        public String getEditorName() {
            return this.editorName;
        }
    }
}

